#ifndef DETAIL_H
#define DETAIL_H

#include <k3dsdk/data.h>
#include <k3dsdk/i18n.h>
#include <k3dsdk/itransform_array_1d.h>
#include <k3dsdk/itransform_array_2d.h>
#include <k3dsdk/itransform_array_3d.h>
#include <k3dsdk/node_change_signal.h>

namespace libk3darray
{

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
// transform_array_1d

/// Boilerplate implementation of k3d::itransform_array_1d
template<typename base_t>
class transform_array_1d :
	public k3d::node_change_signal<base_t>,
	public k3d::itransform_array_1d
{
public:
	transform_array_1d(k3d::idocument& Document) :
		k3d::node_change_signal<base_t>(Document),
		m_layout(init_owner(*this) + init_name("layout") + init_label(_("Layout")) + init_description(_("Layout")) + init_value<k3d::itransform_array_1d*>(0))
	{
		m_layout.changed_signal().connect(k3d::node_change_signal<base_t>::node_changed_signal().make_slot());
	}

	const k3d::matrix4 get_element(unsigned long Index1, unsigned long Count1)
	{
		k3d::itransform_array_1d* const layout = m_layout.value();
		if(layout)
			return on_get_element(Index1, Count1) * layout->get_element(Index1, Count1);
		return on_get_element(Index1, Count1);
	}
	
private:
	virtual const k3d::matrix4 on_get_element(unsigned long Index1, unsigned long Count1) = 0;

	k3d_data(k3d::itransform_array_1d*, immutable_name, change_signal, with_undo, node_storage, no_constraint, node_property, node_serialization) m_layout;
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
// transform_array_2d

/// Boilerplate implementation of k3d::itransform_array_1d
template<typename base_t>
class transform_array_2d :
	public k3d::node_change_signal<base_t>,
	public k3d::itransform_array_2d
{
public:
	transform_array_2d(k3d::idocument& Document) :
		k3d::node_change_signal<base_t>(Document),
		m_layout(init_owner(*this) + init_name("layout") + init_label(_("Layout")) + init_description(_("Layout")) + init_value<k3d::itransform_array_2d*>(0))
	{
		m_layout.changed_signal().connect(k3d::node_change_signal<base_t>::node_changed_signal().make_slot());
	}

	const k3d::matrix4 get_element(unsigned long Index1, unsigned long Count1, unsigned long Index2, unsigned long Count2)
	{
		k3d::itransform_array_2d* const layout = m_layout.value();
		if(layout)
			return on_get_element(Index1, Count1, Index2, Count2) * layout->get_element(Index1, Count1, Index2, Count2);
		return on_get_element(Index1, Count1, Index2, Count2);
	}
	
private:
	virtual const k3d::matrix4 on_get_element(unsigned long Index1, unsigned long Count1, unsigned long Index2, unsigned long Count2) = 0;

	k3d_data(k3d::itransform_array_2d*, immutable_name, change_signal, with_undo, node_storage, no_constraint, node_property, node_serialization) m_layout;
};

///////////////////////////////////////////////////////////////////////////////////////////////////////////////
// transform_array_3d

/// Boilerplate implementation of k3d::itransform_array_1d
template<typename base_t>
class transform_array_3d :
	public k3d::node_change_signal<base_t>,
	public k3d::itransform_array_3d
{
public:
	transform_array_3d(k3d::idocument& Document) :
		k3d::node_change_signal<base_t>(Document),
		m_layout(init_owner(*this) + init_name("layout") + init_label(_("Layout")) + init_description(_("Layout")) + init_value<k3d::itransform_array_3d*>(0))
	{
		m_layout.changed_signal().connect(k3d::node_change_signal<base_t>::node_changed_signal().make_slot());
	}

	const k3d::matrix4 get_element(unsigned long Index1, unsigned long Count1, unsigned long Index2, unsigned long Count2, unsigned long Index3, unsigned long Count3)
	{
		k3d::itransform_array_3d* const layout = m_layout.value();
		if(layout)
			return on_get_element(Index1, Count1, Index2, Count2, Index3, Count3) * layout->get_element(Index1, Count1, Index2, Count2, Index3, Count3);
		return on_get_element(Index1, Count1, Index2, Count2, Index3, Count3);
	}
	
private:
	virtual const k3d::matrix4 on_get_element(unsigned long Index1, unsigned long Count1, unsigned long Index2, unsigned long Count2, unsigned long Index3, unsigned long Count3) = 0;

	k3d_data(k3d::itransform_array_3d*, immutable_name, change_signal, with_undo, node_storage, no_constraint, node_property, node_serialization) m_layout;
};

} // namespace libk3darray

#endif // !DETAIL_H

