
import _ApplicationModule
import _PluginFactoryModule
import _CommandNodeModule
import _PropertyModule
import _DocumentModule
import _BezierChannelModule
import _ObjectModule
import _UIModule
import _ScriptEnginesModule
import _mesh_module
import _point_module
import _polyhedron_module
import _face_module
import _blobby_module

class ObjectClass:
	def __init__(self, object):
		self.__dict__["object"] = object
	def __getattr__(self, method):
		if method == "name":
			return _ObjectModule.get_name(self.object)
		elif method == "mesh":
			mesh = _ObjectModule.get_mesh(self.object)
			if not mesh:
				return None
			return k3dmesh(self.Document(), mesh)
	def __setattr__(self, method, value):
		if method == "name":
			return _ObjectModule.set_name(self.object, value)
	def Document(self):
		return DocumentClass(_ObjectModule.get_document(self.object))
	def Factory(self):
		return PluginFactoryClass(_ObjectModule.get_factory(self.object))
	def EditObject(self):
		return _ObjectModule.EditObject(self.object)

class BezierChannelClass:
	def __init__(self, bezierchannel):
		self.object = bezierchannel
	def GetCurve(self):
		return _BezierChannelModule.GetCurve(self.object)

class DocumentClass:
	def __init__(self, document):
		self.object = document
	def GetApplication(self):
		return ApplicationClass()
	def GetPath(self):
		return _DocumentModule.GetPath(self.object)
	def Import(self, file, format):
		return _DocumentModule.Import(self.object, file, format)
	def Export(self, file, format):
		return _DocumentModule.Export(self.object, file, format)
	def Save(self, file):
		return _DocumentModule.Save(self.object, file)
	def StartChangeSet(self):
		return _DocumentModule.StartChangeSet(self.object)
	def FinishChangeSet(self, string):
		return _DocumentModule.FinishChangeSet(self.object, string)
	def RedrawAll(self):
		return _DocumentModule.RedrawAll(self.object)
	def CreateObject(self, name):
		return ObjectClass(_DocumentModule.CreateObject(self.object, name))
	def Objects(self):
		objects = _DocumentModule.Objects(self.object)
		result = []
		for object in objects:
			result.append(ObjectClass(object))
		return result
	def GetObject(self, name):
		return ObjectClass(_DocumentModule.GetObject(self.object, name))
	def DeleteObject(self, name):
		return _DocumentModule.DeleteObject(self.object, name)
	def meshes(self):
		objects = _DocumentModule.get_frozen_meshes(self.object)
		result = []
		for object in objects:
			result.append(ObjectClass(object))
		return result
	def mesh_instances(self):
		objects = _DocumentModule.get_mesh_instances(self.object)
		result = []
		for object in objects:
			result.append(ObjectClass(object))
		return result
	def objects_by_name(self, name):
		objects = _DocumentModule.get_objects_by_name(self.object)
		result = []
		for object in objects:
			result.append(ObjectClass(object))
		return result

class PropertyClass:
	def __init__(self, property):
		self.object = property
	def Name(self):
		return _PropertyModule.get_property_name(self.object)
	def Description(self):
		return _PropertyModule.get_property_description(self.object)
	def ReadOnly(self):
		return _PropertyModule.get_property_read_only(self.object)

class CommandNodeClass:
	def __init__(self, object):
		self.__dict__["object"] = object
	def Command(self, command, arguments):
		return _CommandNodeModule.Command(self.object, command, arguments)
	def __getattr__(self, name):
		child = _CommandNodeModule.get_child(self.object, name)
		if child:
			return CommandNodeClass(child)
		return _CommandNodeModule.get_property(self.object, name)
	def __setattr__(self, name, value):
		return _CommandNodeModule.set_property(self.object, name, value)
	def Children(self):
		return _CommandNodeModule.get_children(self.object)
	def Properties(self):
		return _CommandNodeModule.get_properties(self.object)
	def GetNode(self, name):
		child = _CommandNodeModule.get_child(self.object, name)
		if child:
			return CommandNodeClass(child)
		return None
	def GetProperty(self, name):
		return _CommandNodeModule.get_property(self.object, name)
	def SetProperty(self, name, value):
		return _CommandNodeModule.set_property(self.object, name, value)

class UIClass:
	def __init__(self, object):
		self.object = object
	def BrowserNavigate(self, url):
		return _UIModule.BrowserNavigate(self.object, url)
	def Message(self, message, title):
		return _UIModule.Message(self.object, message, title)
	def QueryMessage(self, message, title, buttons):
		return _UIModule.QueryMessage(self.object, message, title, buttons)
	def ErrorMessage(self, message, title):
		return _UIModule.ErrorMessage(self.object, message, title)
	def GetFilePath(self, type, prompt, promptoverwrite, oldpath):
		return _UIModule.GetFilePath(self.object, type, prompt, promptoverwrite, oldpath)

class ScriptEnginesClass:
	def __init__(self, object):
		self.object = object
	def PlayFile(filename):
		return _ScriptEnginesModule.PlayFile(filename)

class PluginFactoryClass:
	def __init__(self, object):
		self.__dict__["object"] = object
	def __getattr__(self, name):
		return _PluginFactoryModule.get_attribute(self.object, name)

class ApplicationClass:
	def __init__(self):
		pass
	def __getattr__(self, name):
		value = _ApplicationModule.get_attribute(name)
		if value:
			if name == "UI":
				return UIClass(value)
			if name == "ScriptEngine":
				return ScriptEnginesClass(value)
			return value
		raise AttributeError
	def Close(self):
		return _ApplicationModule.Close()
	def NewDocument(self):
		return DocumentClass(_ApplicationModule.NewDocument())
	def OpenDocument(self, file):
		return DocumentClass(_ApplicationModule.OpenDocument(file))
	def CloseDocument(self, document):
		return _ApplicationModule.CloseDocument(document.object)
	def CommandNode(self, object):
		return CommandNodeClass(_ApplicationModule.get_command_node(object))
	def PluginFactories(self):
		objects = _ApplicationModule.get_plugin_factories()
		result = []
		for object in objects:
			result.append(PluginFactoryClass(object))
		return result

class k3dmesh:
	def __init__(self, document, mesh=None):
		self.document = document
		if mesh:
			self.mesh = mesh
		else:
			self.mesh = _mesh_module.create_mesh()
	def create_mesh_object(self):
		return ObjectClass(_mesh_module.create_mesh_object(self.mesh, self.document.object))
	def create_mesh_instance(self, mesh_object):
		return ObjectClass(_mesh_module.create_mesh_instance(mesh_object.object, self.document.object))
	def create_point(self, vector=None):
		return k3dpoint(_mesh_module.create_point(self.mesh, vector))
	def points(self):
		objects = _mesh_module.get_points(self.mesh)
		result = []
		for object in objects:
			result.append(k3dpoint(object))
		return result
	def get_point_position(self, index=0):
		return _mesh_module.get_point_position(self.mesh, index)
	def set_point_position(self, index=0, vector=None):
		_mesh_module.set_point_position(self.mesh, index, vector)
	def create_polyhedron(self):
		return k3dpolyhedron(_mesh_module.create_polyhedron(self.mesh), self.mesh)
	def polyhedra(self):
		objects = _mesh_module.get_polyhedra(self.mesh)
		result = []
		for object in objects:
			result.append(k3dpolyhedron(object, self.mesh))
		return result
	def add_blobby(self, blobby_opcode):
		_mesh_module.add_blobby(self.mesh, blobby_opcode.object)

class k3dpoint:
	def __init__(self, object):
		self.__dict__["object"] = object
	def __getattr__(self, method):
		if method == "position":
			return _point_module.get_position(self.object)
		elif method == "reference":
			return _point_module.get_reference(self.object)
	def __setattr__(self, method, value):
		if method == "position":
			return _point_module.set_position(self.object, value)

class k3dpolyhedron:
	def __init__(self, polyhedron, mesh):
		self.polyhedron = polyhedron
		self.mesh = mesh
	def __getattr__(self, method):
		if method == "faces":
			objects = _polyhedron_module.get_faces(self.polyhedron)
			result = []
			for object in objects:
				result.append(k3dface(object))
			return result
	def create_face(self, point):
		return k3dface(_polyhedron_module.create_face(self.polyhedron, self.mesh, point.object))
	def add_point_to_face(self, face, point):
		_polyhedron_module.add_point_to_face(self.polyhedron, self.mesh, face.object, point.object)
	def create_face_from_vertex_indices(self, face_points):
		return k3dface(_polyhedron_module.create_face_from_vertex_indices(self.polyhedron, self.mesh, face_points))

class k3dface:
	def __init__(self, object):
		self.__dict__["object"] = object
	def __getattr__(self, method):
		if method == "points":
			objects = _face_module.get_edge_points(self.object)
			result = []
			for object in objects:
				result.append(k3dpoint(object))
			return result

class k3dblobby:
	def __init__(self, start, end=None, radius=None):
		if end and radius:
			self.object = _blobby_module.segment(start, end, radius)
		else:
			self.object = _blobby_module.ellipsoid(start)
	def set_color(self, color):
		_blobby_module.set_color(self.object, color)
	def add(self, blobby):
		self.object = _blobby_module.add(self.object, blobby.object)
	def multiply(self, blobby):
		self.object = _blobby_module.multiply(self.object, blobby.object)
	def max(self, blobby):
		self.object = _blobby_module.max(self.object, blobby.object)
	def min(self, blobby):
		self.object = _blobby_module.min(self.object, blobby.object)
	def subtract(self, blobby):
		self.object = _blobby_module.subtract(self.object, blobby.object)
	def divide(self, blobby):
		self.object = _blobby_module.divide(self.object, blobby.object)

Application = ApplicationClass()

