#ifndef SDPGTKTYPES_H
#define SDPGTKTYPES_H

// SDPGTK Library
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Public API for the entire SDPGTK library
		\author Tim Shead (tshead@k-3d.com)
*/

#include <sdptypes/sdptypes.h>
#include <glib.h>

/// A pointer to a string
typedef gchar* SDPSTRING;

/// Asserts on null or empty strings
#ifndef g_assert_string
#define g_assert_string(String) g_assert(String); g_assert(strlen(String));
#endif // !g_assert_string

/// Fails on null and empty strings
#ifndef g_return_if_string_fail
#define g_return_if_string_fail(String) g_return_if_fail(String); g_return_if_fail(strlen(String));
#endif // !g_return_if_string_fail

/// Fails on null and empty strings
#ifndef g_return_val_if_string_fail
#define g_return_val_if_string_fail(String, Result) g_return_val_if_fail(String, Result); g_return_val_if_fail(strlen(String), Result);
#endif // !g_return_val_if_string_fail

#endif // !SDPGTKTYPES_H


