//javascript

/// Boilerplate to determine which document to modify ...
function FindDocument(ScriptName)
{
	if(Document)
			return Document;
	else
			{
					if(Application.documents.length == 1)
							return Application.documents[0];
					else if(Application.documents.length == 0)
							Application.ui.ErrorMessage("You must have an open document to run this script!", ScriptName + ":");
					else
							Application.ui.ErrorMessage("Not sure which document to use ... try using the desired document's Document Window > Tools > Play Script.", ScriptName + ":");
			}
			
	return null;
}

document = FindDocument("dag_test.javascript");
if(document)
	{
		// Start recording changes for undo-purposes ...
		document.StartChangeSet();

		sphere1 = document.CreateObject("Sphere");
		sphere2 = document.CreateObject("Sphere");

		// Link the first sphere's radius property to the second's ...
		document.SetDependency(sphere1.Property("radius"), sphere2.Property("radius"));

		// Finish recording undos ...
		document.FinishChangeSet("DAG Test");

		sphere1.name = "Sphere1";
		sphere2.name = "Sphere2";

		sphere1.position = [-6, 0, 0];
		sphere2.position = [6, 0, 0];

		document.RedrawAll();

		Application.ui.Show(sphere2);
		Application.ui.Message("Modify the Sphere2 radius to see that the Sphere1 radius is linked", "dag_test:");
	}


