// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include "gtkml.h"
#include "splash_box.h"

#include <k3dsdk/paths.h>
#include <sdpgtk/sdpgtkutility.h>

#include <boost/timer.hpp>

// We have an unfortunate clash with "X" ...
#ifdef RootWindow
#undef RootWindow
#endif // RootWindow

namespace k3d
{

/////////////////////////////////////////////////////////////////////////////
// splash_box

splash_box::splash_box()
{
	return_if_fail(load_gtkml(dialog_template_path() / "splash.gtkml", *this));

	// Set our version and copyright notices ...
	Label("version").SetText(("K-3D Version " + version_string()).c_str());

	// Center it ...
	gtk_window_set_position(RootWindow(), GTK_WIN_POS_CENTER);

	// Make sure we're visible ...
	RootWidget().Show();

	// Give the dialog a chance to display itself ...
	for(unsigned int z = 0; z < 10; ++z)
		{
			boost::timer sleep;
			while(sleep.elapsed() < 0.010) {}
			sdpGtkHandlePendingEvents();
		}
}

splash_box::~splash_box()
{
	// Clean-up the GTK+ tree ...
	if(Root())
		RootWidget().Destroy();
}

void splash_box::on_startup_message(const std::string Message)
{
	Label("message").SetText(Message.c_str());
	sdpGtkHandlePendingEvents();
}

} // namespace k3d


