// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include "filter_selector_private.h"
#include "gtkml.h"

#include <k3dsdk/result.h>
#include <sdpgtk/sdpgtkevents.h>

namespace k3d
{

namespace implementation_private
{

/////////////////////////////////////////////////////////////////////////////
// filter_selector

filter_selector::filter_selector(const std::string Title, const boost::filesystem::path& File) :
	m_file(File),
	m_ok(false)
{
	// Create and load our UI template ...
	std::istringstream uitemplate(
		"<gtkml>"
			"<window title=\"Select File Format:\" type=\"dialog\" show=\"false\" allowgrow=\"false\">"
				"<vbox homogeneous=\"false\">"
					"<label labelpadding=\"6 6\">Select a file format.  You may select \"Automatic\"\n"
						"to attempt automatic selection based on file name / contents.</label>"
					"<combo homogeneous=\"false\" name=\"filter\"/>"
					"<hbuttonbox layout=\"end\">"
						"<button name=\"ok\">OK"
							"<event signal=\"clicked\" name=\"ok\"/>"
						"</button>"
						"<button name=\"cancel\">Cancel"
							"<event signal=\"clicked\" name=\"cancel\"/>"
						"</button>"
					"</hbuttonbox>"
				"</vbox>"
			"</window>"
		"</gtkml>\n");

	return_if_fail(load_gtkml(uitemplate, "filter selector builtin template", *this));

	// Set our title ...
	RootWindow().SetTitle(Title.c_str());
}

filter_selector::~filter_selector()
{
	RootWidget().Destroy();
}

bool filter_selector::do_modal(GtkWindow* TransientOwner)
{
	RootWidget().Show();
	DoModal(TransientOwner);

	return m_ok;
}

void filter_selector::OnEvent(sdpGtkEvent* Event)
{
	if(Event->Name() == "ok")
		OnOK();
	else if(Event->Name() == "cancel")
		OnCancel();
	else if(Event->Name() == "delete")
		OnDelete(Event);
	else
		base::OnEvent(Event);
}

void filter_selector::OnOK()
{
	m_ok = true;
	CancelModal();
}

void filter_selector::OnCancel()
{
	m_ok = false;
	CancelModal();
}

void filter_selector::OnDelete(sdpGtkEvent* const Event)
{
	// Sanity checks ...
	assert_warning(Event);

	// Don't allow the GTK+ tree to go away just yet ...
	static_cast<sdpGtkEventWidgetDeleteEvent*>(Event)->SetResult(true);

	// Turn it into a "cancel", instead ...
	OnCancel();
}

const std::string filter_selector::choice()
{
	return m_choices[Combo("filter").GetEntryText()];
}

} // namespace implementation_private

} // namespace k3d


