// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Implements property_collection, which provides a default implementation of iproperty_collection
		\author Tim Shead (tshead@k-3d.com)
*/

#include "property_collection.h"
#include "result.h"

#include <iostream>

namespace k3d
{

/////////////////////////////////////////////////////////////////////////////
// property_collection

property_collection::property_collection(idag& Dag) :
	m_dag(Dag)
{
}

property_collection::~property_collection()
{
}

const iproperty_collection::properties_t& property_collection::properties()
{
	return m_properties;
}

iproperty_collection::properties_changed_signal_t& property_collection::properties_changed_signal()
{
	return m_changed_signal;
}

void property_collection::register_property(iproperty& Property)
{
	m_properties.push_back(&Property);
	m_changed_signal.emit();
}

void property_collection::unregister_property(iproperty& Property)
{
	properties_t::iterator property = std::find(m_properties.begin(), m_properties.end(), &Property);
	return_if_fail(property != m_properties.end());

	m_properties.erase(property);
	m_changed_signal.emit();
}

} // namespace k3d


