#ifndef K3DSDK_PATH_DATA_H
#define K3DSDK_PATH_DATA_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares commandnode, which provides a default implementation of icommand_node
		\author Tim Shead (tshead@k-3d.com)
*/

#include "data.h"

namespace k3d
{

/////////////////////////////////////////////////////////////////////////////
// data

/// A partial specialization of k3d::data for storing boost::filesystem::path objects
template
	<
		class name_policy,
		class undo_policy,
		class constraint_policy
	>
class data<boost::filesystem::path, name_policy, undo_policy, constraint_policy> :
	public name_policy,
	public undo_policy,
	public constraint_policy
{
public:
	typedef boost::filesystem::path value_t;
	typedef name_policy name_policy_t;
	typedef undo_policy undo_policy_t;
	typedef constraint_policy constraint_policy_t;

	template<typename init_t>
	data(const init_t& Init) :
		name_policy_t(Init),
		undo_policy_t(Init),
		constraint_policy_t(Init)
	{
	}

	void set_value(value_t Value)
	{
		constraint_policy_t::constrain(Value);
		undo_policy_t::undo_set_value(Value);
	}

	void force_value(const value_t& Value)
	{
		undo_policy_t::undo_set_value(Value);
	}
};

} // namespace k3d

#endif // K3DSDK_PATH_DATA_H

