#ifndef K3DSDK_MOUSE_EVENT_OBSERVER_H
#define K3DSDK_MOUSE_EVENT_OBSERVER_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares the mouse_event_observer class, which provides a pluggable default implementation of imouse_event_observer
		\author Tim Shead (tshead@k-3d.com)
*/

#include "imouse_event_observer.h"

namespace k3d
{

/// Provides an implementation of imouse_event_observer
class mouse_event_observer :
	public imouse_event_observer
{
public:
	mouse_event_observer(const std::string& Usage);
	virtual ~mouse_event_observer();

	const std::string Usage();
	bool OnMouseMove(const event_state& State, const vector2& Current);
	bool OnLButtonDown(const event_state& State, const vector2& Current);
	bool OnLButtonClick(const event_state& State, const vector2& Current);
	bool OnLButtonUp(const event_state& State, const vector2& Current);
	bool OnLButtonDoubleClick(const event_state& State, const vector2& Current);
	bool OnLButtonDrag(const event_state& State, const vector2& Current, const vector2& Last, const vector2& Start, const drag_type_t DragType);
	bool OnMButtonDown(const event_state& State, const vector2& Current);
	bool OnMButtonClick(const event_state& State, const vector2& Current);
	bool OnMButtonUp(const event_state& State, const vector2& Current);
	bool OnMButtonDoubleClick(const event_state& State, const vector2& Current);
	bool OnMButtonDrag(const event_state& State, const vector2& Current, const vector2& Last, const vector2& Start, const drag_type_t DragType);
	bool OnRButtonDown(const event_state& State, const vector2& Current);
	bool OnRButtonClick(const event_state& State, const vector2& Current);
	bool OnRButtonUp(const event_state& State, const vector2& Current);
	bool OnRButtonDoubleClick(const event_state& State, const vector2& Current);
	bool OnRButtonDrag(const event_state& State, const vector2& Current, const vector2& Last, const vector2& Start, const drag_type_t DragType);

private:
	const std::string m_usage;
};

} // namespace k3d

#endif // K3DSDK_MOUSE_EVENT_OBSERVER_H


