#ifndef K3DSDK_MATERIAL_COLLECTION_H
#define K3DSDK_MATERIAL_COLLECTION_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include "imaterial_collection.h"
#include "material.h"
#include "object_data.h"
#include "persistence.h"
#include "property_collection.h"

#ifdef	interface
#undef	interface
#endif	// interface

namespace k3d
{

// Forward declarations
class idocument;

/// Adds a boilerplate implementation of k3d::imaterial_collection to a base class, using the parameterized-inheritance idiom
template<typename base_t>
class material_collection :
	public base_t,
	public imaterial_collection
{
public:
	material_collection(idocument& Document) :
		base_t(Document),
		m_material(init_name("material") + init_description("Surface material [object]") + init_object_value(k3d::default_material(Document)) + init_document(Document))
	{
		base_t::enable_serialization(k3d::persistence::object_proxy(m_material));
		base_t::register_property(m_material);
	}

	imaterial* material()
	{
		return m_material.interface();
	}
	
	void set_material(imaterial* const Material)
	{
		m_material.set_object(dynamic_cast<iobject*>(Material));
	}

protected:
	k3d_object_property(k3d::imaterial, k3d::immutable_name, k3d::with_undo, k3d::local_storage) m_material;
};

} // namespace k3d

#endif // K3DSDK_MATERIAL_COLLECTION_H

