;==========================================================
; This NSIS script was created by Kirstyn Amanda Fox
;  GeekGirl - GeekGirl(@)CyberBrats(.)Org
;
; Known Bugs: Can't be installed into a directory with
; spaces in the name. This is a problem with the program
; itself, and not my install script :)
;
; Kirstyn Amanda Fox (GeekGirl)


;==========================================================
; HM NIS Edit Wizard helper defines

!define PRODUCT_NAME "K-3D"
!define PRODUCT_VERSION "0.4.2.1"
!define PRODUCT_PUBLISHER "K-3D"
!define PRODUCT_WEB_SITE "http://k3d.sf.net"
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\k3d.bat"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "COPYING.txt"
; Directory page
;Section "val0"
;Function again
; again:
;FunctionEnd.
!insertmacro MUI_PAGE_DIRECTORY






; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!define MUI_FINISHPAGE_SHOWREADME "$INSTDIR\README.txt"
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "${PRODUCT_NAME}-${PRODUCT_VERSION}-W32-Setup.exe"
InstallDir "C:\progra~1\K-3D"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""
ShowInstDetails show
ShowUnInstDetails show
Section "val0"
  Push "$INSTDIR"
  Push "abcdefghijklmnopqrstuvwxyz0123456789_-+!=()^%~!/\:`'#@"
  Call Validate
  Pop $0
StrCmp $0 0 warnkill other
;MessageBox MB_OK $0
 warnkill:
  MessageBox MB_ICONSTOP "Sorry, but this program does not support being installed in directoroes containing spaces. To install into \Program Files\ try using \progra~1\ it's a windows shortcut."
;  goto kill
; kill:
  Quit
 other:
; continue
 sectionend
Function Validate
  Push $0
  Push $1
  Push $2
  Push $3 ;value length
  Push $4 ;count 1
  Push $5 ;tmp var 1
  Push $6 ;list length
  Push $7 ;count 2
  Push $8 ;tmp var 2
  Exch 9
  Pop $1 ;list
  Exch 9
  Pop $2 ;value
  StrCpy $0 1
  StrLen $3 $2
  StrLen $6 $1
  StrCpy $4 0
  lbl_loop:
    StrCpy $5 $2 1 $4
    StrCpy $7 0
    lbl_loop2:
      StrCpy $8 $1 1 $7
      StrCmp $5 $8 lbl_loop_next 0
      IntOp $7 $7 + 1
      IntCmp $7 $6 lbl_loop2 lbl_loop2 lbl_error
  lbl_loop_next:
  IntOp $4 $4 + 1
  IntCmp $4 $3 lbl_loop lbl_loop lbl_done
  lbl_error:
  StrCpy $0 0
  lbl_done:
  Pop $6
  Pop $5
  Pop $4
  Pop $3
  Pop $2
  Pop $1
  Exch 2
  Pop $7
  Pop $8
  Exch $0
FunctionEnd

Section "MainSection" SEC01
  SetOutPath "$INSTDIR"
  SetOverwrite try
  File "asprintf.dll"
  File "AUTHORS"
  File "blackbox.log"
  File "ChangeLog"
  File "charset.dll"
  File "COPYING"
  File "COPYING.txt"
  SetOutPath "$INSTDIR\dialogtemplates"
  File "dialogtemplates\about.gtkml"
  File "dialogtemplates\about.xpm"
  File "dialogtemplates\application_window.gtkml"
  File "dialogtemplates\bezier-channel24.xpm"
  File "dialogtemplates\black_box_recorder.gtkml"
  File "dialogtemplates\bone-object24.xpm"
  File "dialogtemplates\bone-object32.xpm"
  File "dialogtemplates\camera-object32.xpm"
  File "dialogtemplates\color_bezier_channel.gtkml"
  File "dialogtemplates\command_node_inspector.gtkml"
  File "dialogtemplates\cone-object24.xpm"
  File "dialogtemplates\cone-object32.xpm"
  File "dialogtemplates\connect_properties.gtkml"
  File "dialogtemplates\cube-object24.xpm"
  File "dialogtemplates\cube-object32.xpm"
  File "dialogtemplates\dag_control.gtkml"
  File "dialogtemplates\dag_window.gtkml"
  File "dialogtemplates\document_window.gtkml"
  File "dialogtemplates\error.gtkml"
  File "dialogtemplates\error.xpm"
  File "dialogtemplates\fastforward.xpm"
  File "dialogtemplates\inline_script_editor.gtkml"
  File "dialogtemplates\material-object24.xpm"
  File "dialogtemplates\message.gtkml"
  File "dialogtemplates\modifiers_control.xpm"
  File "dialogtemplates\modifiers_dim.xpm"
  File "dialogtemplates\modifiers_lock+control.xpm"
  File "dialogtemplates\modifiers_lock.xpm"
  File "dialogtemplates\modifiers_none.xpm"
  File "dialogtemplates\modifiers_shift+control.xpm"
  File "dialogtemplates\modifiers_shift+lock+control.xpm"
  File "dialogtemplates\modifiers_shift+lock.xpm"
  File "dialogtemplates\modifiers_shift.xpm"
  File "dialogtemplates\mouse.xpm"
  File "dialogtemplates\mouse_dim.xpm"
  File "dialogtemplates\mouse_lmb.xpm"
  File "dialogtemplates\mouse_lmb_1.xpm"
  File "dialogtemplates\mouse_lmb_2.xpm"
  File "dialogtemplates\mouse_lmb_rmb.xpm"
  File "dialogtemplates\mouse_mmb.xpm"
  File "dialogtemplates\mouse_mmb_1.xpm"
  File "dialogtemplates\mouse_mmb_2.xpm"
  File "dialogtemplates\mouse_rmb.xpm"
  File "dialogtemplates\mouse_rmb_1.xpm"
  File "dialogtemplates\mouse_rmb_2.xpm"
  File "dialogtemplates\new.xpm"
  File "dialogtemplates\open.xpm"
  File "dialogtemplates\options.gtkml"
  File "dialogtemplates\play.xpm"
  File "dialogtemplates\playloop.xpm"
  File "dialogtemplates\playreverse.xpm"
  File "dialogtemplates\playreverseloop.xpm"
  File "dialogtemplates\play_from_cursor.xpm"
  File "dialogtemplates\property_button.gtkml"
  File "dialogtemplates\property_linked.xpm"
  File "dialogtemplates\property_unlinked.xpm"
  File "dialogtemplates\query.gtkml"
  File "dialogtemplates\query.xpm"
  File "dialogtemplates\record.xpm"
  File "dialogtemplates\recordframe.xpm"
  File "dialogtemplates\renameobject.gtkml"
  File "dialogtemplates\renderanimation.xpm"
  File "dialogtemplates\renderframe.xpm"
  File "dialogtemplates\renderpreview.xpm"
  File "dialogtemplates\rewind.xpm"
  File "dialogtemplates\rotate-tool24.xpm"
  File "dialogtemplates\rotate-tool32.xpm"
  File "dialogtemplates\save.xpm"
  File "dialogtemplates\save_viewport_animation.xpm"
  File "dialogtemplates\save_viewport_frame.xpm"
  File "dialogtemplates\scalar_bezier_channel.gtkml"
  File "dialogtemplates\scale-tool24.xpm"
  File "dialogtemplates\scale-tool32.xpm"
  File "dialogtemplates\script.xpm"
  File "dialogtemplates\script_editor.gtkml"
  File "dialogtemplates\select_curves.xpm"
  File "dialogtemplates\select_edges.xpm"
  File "dialogtemplates\select_faces.xpm"
  File "dialogtemplates\select_meshes.xpm"
  File "dialogtemplates\select_objects.xpm"
  File "dialogtemplates\select_patches.xpm"
  File "dialogtemplates\select_points.xpm"
  File "dialogtemplates\select_point_groups.xpm"
  File "dialogtemplates\sphere-object24.xpm"
  File "dialogtemplates\sphere-object32.xpm"
  File "dialogtemplates\splash.gtkml"
  File "dialogtemplates\splash.xpm"
  File "dialogtemplates\stop.xpm"
  File "dialogtemplates\translate-tool24.xpm"
  File "dialogtemplates\translate-tool32.xpm"
  File "dialogtemplates\tutorial_menu.gtkml"
  File "dialogtemplates\tutorial_message.gtkml"
  File "dialogtemplates\tutorial_recorder.gtkml"
  File "dialogtemplates\viewport_window.gtkml"
  SetOutPath "$INSTDIR"
  File "freetype6.dll"
  File "gpp.exe"
  File "iconv.dll"
  File "INSTALL"
  File "intl.dll"
  File "jpeg62.dll"
  File "k3d-bin.exe"
  File "k3d-config"
  File "k3d-makempeg"
  File "k3d-renderframe.exe"
  File "k3d-renderjob.exe"
  File "k3d.bat"
  CreateDirectory "$SMPROGRAMS\K-3D"
  CreateShortCut "$SMPROGRAMS\K-3D\K-3D.lnk" "$INSTDIR\k3d.bat"
  CreateShortCut "$DESKTOP\K-3D.lnk" "$INSTDIR\k3d.bat"
  File "libgdk-0.dll"
  File "libglib-2.0-0.dll"
  File "libgmodule-2.0-0.dll"
  File "libgobject-2.0-0.dll"
  File "libgthread-2.0-0.dll"
  File "libgtk-0.dll"
  File "libHapy-0.dll"
  File "libk3dembed-0.dll"
  File "libk3dsdk-0.dll"
  File "libk3dui-0.dll"
  SetOutPath "$INSTDIR\libraries"
  File "libraries\libk3dbitmap-0.dll"
  File "libraries\libk3dchannels-0.dll"
  File "libraries\libk3dchem-0.dll"
  File "libraries\libk3dcore-0.dll"
  File "libraries\libk3dfreetype2-0.dll"
  File "libraries\libk3dgeometry-0.dll"
  File "libraries\libk3dgraphviz-0.dll"
  File "libraries\libk3djavascript-0.dll"
  File "libraries\libk3dlsystem-0.dll"
  File "libraries\libk3dmesh-0.dll"
  File "libraries\libk3dpov-0.dll"
  File "libraries\libk3dpython-0.dll"
  File "libraries\libk3dqslim-0.dll"
  File "libraries\libk3drenderman-0.dll"
  File "libraries\libk3dtiff-0.dll"
  File "libraries\libk3dviewport-0.dll"
  File "libraries\libk3dyafray-0.dll"
  SetOutPath "$INSTDIR"
  File "libsdpgl-0.dll"
  File "libsdpgtk-0.dll"
  File "libsdpsl-0.dll"
  File "libsdpxml-0.dll"
  File "libsigc-1.2-5.dll"
  File "libsigc-2.0-0.dll"
  File "libtiff3.dll"
  File "NEWS"
  File "options.k3d"
  File "python23.dll"
  File "README"
  File "README.txt"
  SetOutPath "$INSTDIR\scripts"
  File "scripts\blobby.python"
  File "scripts\command_node_inspector.python"
  File "scripts\create_mesh.python"
  File "scripts\dag_test.javascript"
  File "scripts\dag_test2.javascript"
  File "scripts\describe_object.javascript"
  File "scripts\describe_object_properties.javascript"
  File "scripts\describe_plugins.javascript"
  File "scripts\describe_plugins.python"
  File "scripts\export_raw.python"
  File "scripts\howdy_world.javascript"
  File "scripts\howdy_world.python"
  File "scripts\innovation.javascript"
  File "scripts\point_shadowmaps.javascript"
  File "scripts\render_test.javascript"
  File "scripts\script_context.javascript"
  File "scripts\script_context.python"
  SetOutPath "$INSTDIR\shaders"
  File "shaders\k3d_altitude_fog.sl"
  File "shaders\k3d_altitude_fog.sl.slmeta"
  File "shaders\k3d_ambientlight.sl"
  File "shaders\k3d_ambientlight.sl.slmeta"
  File "shaders\k3d_antialiasedchecks.sl"
  File "shaders\k3d_arealight.sl"
  File "shaders\k3d_arealight.sl.slmeta"
  File "shaders\k3d_background.sl"
  File "shaders\k3d_background.sl.slmeta"
  File "shaders\k3d_bluemarble.sl"
  File "shaders\k3d_brick.sl"
  File "shaders\k3d_brick.sl.slmeta"
  File "shaders\k3d_brick2.sl"
  File "shaders\k3d_brick3.sl"
  File "shaders\k3d_brickanti.sl"
  File "shaders\k3d_brickbump.sl"
  File "shaders\k3d_brickbump.sl.slmeta"
  File "shaders\k3d_brickbump2.sl"
  File "shaders\k3d_brickbump3.sl"
  File "shaders\k3d_brickperturb.sl"
  File "shaders\k3d_brushedmetal.sl"
  File "shaders\k3d_brushedmetal.sl.slmeta"
  File "shaders\k3d_brushedmetal2.sl"
  File "shaders\k3d_brushedmetal3.sl"
  File "shaders\k3d_bubbles.sl"
  File "shaders\k3d_bubbly.sl"
  File "shaders\k3d_castucco.sl"
  File "shaders\k3d_castucco.sl.slmeta"
  File "shaders\k3d_causticlight.sl"
  File "shaders\k3d_celld.sl"
  File "shaders\k3d_ceramic.sl"
  File "shaders\k3d_ceramic.sl.slmeta"
  File "shaders\k3d_ceramictiles.sl"
  File "shaders\k3d_ceramictiles.sl.slmeta"
  File "shaders\k3d_checkerboard.sl"
  File "shaders\k3d_checkerboard.sl.slmeta"
  File "shaders\k3d_checkerboard_solid.sl"
  File "shaders\k3d_checkerboard_solid.sl.slmeta"
  File "shaders\k3d_clamptoalpha.sl"
  File "shaders\k3d_clamptoalpha.sl.slmeta"
  File "shaders\k3d_clay.sl"
  File "shaders\k3d_clay.sl.slmeta"
  File "shaders\k3d_cloudplane.sl"
  File "shaders\k3d_constant.sl"
  File "shaders\k3d_constant.sl.slmeta"
  File "shaders\k3d_contacshadow.sl"
  File "shaders\k3d_corktile.sl"
  File "shaders\k3d_craters.sl"
  File "shaders\k3d_crayon.sl"
  File "shaders\k3d_crayontoon.sl"
  File "shaders\k3d_cs.sl"
  File "shaders\k3d_cyclone.sl"
  File "shaders\k3d_cyclone.sl.slmeta"
  File "shaders\k3d_decalplastic.sl"
  File "shaders\k3d_decalplastic.sl.slmeta"
  File "shaders\k3d_defaultsurface.sl"
  File "shaders\k3d_defaultsurface.sl.slmeta"
  File "shaders\k3d_dented.sl"
  File "shaders\k3d_dented.sl.slmeta"
  File "shaders\k3d_depthcue.sl"
  File "shaders\k3d_depthcue.sl.slmeta"
  File "shaders\k3d_displace.h"
  File "shaders\k3d_displacementmap.sl"
  File "shaders\k3d_displacementmap.sl.slmeta"
  File "shaders\k3d_distantlight.sl"
  File "shaders\k3d_distantlight.sl.slmeta"
  File "shaders\k3d_distant_shadow.sl"
  File "shaders\k3d_distant_shadow.sl.slmeta"
  File "shaders\k3d_droop.sl"
  File "shaders\k3d_dturb.sl"
  File "shaders\k3d_easysurface.sl"
  File "shaders\k3d_ember.sl"
  File "shaders\k3d_emboss.sl"
  File "shaders\k3d_envsurf.sl"
  File "shaders\k3d_eroded.sl"
  File "shaders\k3d_eyeball.sl"
  File "shaders\k3d_ez.sl"
  File "shaders\k3d_face_plastic.sl"
  File "shaders\k3d_fakesky.sl"
  File "shaders\k3d_filament.sl"
  File "shaders\k3d_fill.sl"
  File "shaders\k3d_filterwidth.h"
  File "shaders\k3d_fire.sl"
  File "shaders\k3d_flame.sl"
  File "shaders\k3d_flame.sl.slmeta"
  File "shaders\k3d_fog.sl"
  File "shaders\k3d_fog.sl.slmeta"
  File "shaders\k3d_fractal.sl"
  File "shaders\k3d_fresnelplastic.sl"
  File "shaders\k3d_funkyglass.sl"
  File "shaders\k3d_funkyglass.sl.slmeta"
  File "shaders\k3d_fur1.sl"
  File "shaders\k3d_fur2.sl"
  File "shaders\k3d_glass.sl"
  File "shaders\k3d_glass.sl.slmeta"
  File "shaders\k3d_gloop.sl"
  File "shaders\k3d_glow.sl"
  File "shaders\k3d_glow.sl.slmeta"
  File "shaders\k3d_gmarbtile_polish.sl"
  File "shaders\k3d_gmarbtile_polish.sl.slmeta"
  File "shaders\k3d_gooch.sl"
  File "shaders\k3d_gouge.sl"
  File "shaders\k3d_gradient_t.sl"
  File "shaders\k3d_gradient_t.sl.slmeta"
  File "shaders\k3d_granite.sl"
  File "shaders\k3d_grass_displace.sl"
  File "shaders\k3d_grass_surface.sl"
  File "shaders\k3d_greenmarble.sl"
  File "shaders\k3d_greenmarble.sl.slmeta"
  File "shaders\k3d_hair.sl"
  File "shaders\k3d_hair.sl.slmeta"
  File "shaders\k3d_hdri1.sl"
  File "shaders\k3d_hdri2.sl"
  File "shaders\k3d_hdr_light.sl"
  File "shaders\k3d_hdr_surface.sl"
  File "shaders\k3d_hexatile_bump.sl"
  File "shaders\k3d_hextile.sl"
  File "shaders\k3d_imagelayerclouds.sl"
  File "shaders\k3d_imagelayerclouds.sl.slmeta"
  File "shaders\k3d_imagelayergradient.sl"
  File "shaders\k3d_imagelayergradient.sl.slmeta"
  File "shaders\k3d_incandplastic.sl"
  File "shaders\k3d_indirect.sl"
  File "shaders\k3d_indirect.sl.slmeta"
  File "shaders\k3d_isshad.h"
  File "shaders\k3d_km.h"
  File "shaders\k3d_leather.sl"
  File "shaders\k3d_lensflare.sl"
  File "shaders\k3d_lensflare.sl.slmeta"
  File "shaders\k3d_locillum.h"
  File "shaders\k3d_luna.sl"
  File "shaders\k3d_luna.sl.slmeta"
  File "shaders\k3d_lunette.sl"
  File "shaders\k3d_material.h"
  File "shaders\k3d_matte.sl"
  File "shaders\k3d_matte.sl.slmeta"
  File "shaders\k3d_metal.sl"
  File "shaders\k3d_metal.sl.slmeta"
  File "shaders\k3d_mondometal.sl"
  File "shaders\k3d_mysky.sl"
  File "shaders\k3d_noises.h"
  File "shaders\k3d_noisysmoke.sl"
  File "shaders\k3d_noisysmoke.sl.slmeta"
  File "shaders\k3d_null.sl"
  File "shaders\k3d_null.sl.slmeta"
  File "shaders\k3d_oak.h"
  File "shaders\k3d_oak.sl"
  File "shaders\k3d_oak.sl.slmeta"
  File "shaders\k3d_oakplank.sl"
  File "shaders\k3d_oakplank.sl.slmeta"
  File "shaders\k3d_orange.sl"
  File "shaders\k3d_orennayar.sl"
  File "shaders\k3d_outlet.sl"
  File "shaders\k3d_outline.sl"
  File "shaders\k3d_paintedplastic.sl"
  File "shaders\k3d_paintedplastic.sl.slmeta"
  File "shaders\k3d_painted_constant.sl"
  File "shaders\k3d_painted_constant.sl.slmeta"
  File "shaders\k3d_parquet_plank.sl"
  File "shaders\k3d_parquet_plank.sl.slmeta"
  File "shaders\k3d_parquet_plank2.sl"
  File "shaders\k3d_parquet_tile.sl"
  File "shaders\k3d_particle.sl"
  File "shaders\k3d_particle.sl.slmeta"
  File "shaders\k3d_patterns.h"
  File "shaders\k3d_planetclouds.sl"
  File "shaders\k3d_planetclouds.sl.slmeta"
  File "shaders\k3d_plank.sl"
  File "shaders\k3d_plank.sl.slmeta"
  File "shaders\k3d_plastic.sl"
  File "shaders\k3d_plastic.sl.slmeta"
  File "shaders\k3d_plastic2.sl"
  File "shaders\k3d_pointlight.sl"
  File "shaders\k3d_pointlight.sl.slmeta"
  File "shaders\k3d_proctext.h"
  File "shaders\k3d_project.h"
  File "shaders\k3d_projectionmap_plastic.sl"
  File "shaders\k3d_projectionmap_plastic.sl.slmeta"
  File "shaders\k3d_pshad.h"
  File "shaders\k3d_puffyclouds.sl"
  File "shaders\k3d_rayserver.h"
  File "shaders\k3d_raysphere.h"
  File "shaders\k3d_redapple.sl"
  File "shaders\k3d_reflections.h"
  File "shaders\k3d_ridged_multifractal.sl"
  File "shaders\k3d_ripple.sl"
  File "shaders\k3d_rmannotes.h"
  File "shaders\k3d_roughmetal.sl"
  File "shaders\k3d_roughmetal.sl.slmeta"
  File "shaders\k3d_round.sl"
  File "shaders\k3d_rubber.sl"
  File "shaders\k3d_ruledpaper.sl"
  File "shaders\k3d_rustymetal.sl"
  File "shaders\k3d_saturn.sl"
  File "shaders\k3d_saturnring.sl"
  File "shaders\k3d_scartissue.sl"
  File "shaders\k3d_screen.sl"
  File "shaders\k3d_screen.sl.slmeta"
  File "shaders\k3d_screen_aa.sl"
  File "shaders\k3d_screen_aa.sl.slmeta"
  File "shaders\k3d_sdixon.sl"
  File "shaders\k3d_shadowdistant_rim.sl"
  File "shaders\k3d_shadowspot.sl"
  File "shaders\k3d_shadowspot.sl.slmeta"
  File "shaders\k3d_shifteddrtile.sl"
  File "shaders\k3d_shiftedmoontile.sl"
  File "shaders\k3d_shiny.sl"
  File "shaders\k3d_shiny.sl.slmeta"
  File "shaders\k3d_shinymetal.sl"
  File "shaders\k3d_shinymetal.sl.slmeta"
  File "shaders\k3d_shinyplastic.sl"
  File "shaders\k3d_shinyplastic.sl.slmeta"
  File "shaders\k3d_show_st.sl"
  File "shaders\k3d_show_st.sl.slmeta"
  File "shaders\k3d_skin1.sl"
  File "shaders\k3d_skin2.sl"
  File "shaders\k3d_skymetal.sl"
  File "shaders\k3d_slateroof.sl"
  File "shaders\k3d_slateroofd.sl"
  File "shaders\k3d_slideprojector.sl"
  File "shaders\k3d_slideprojector.sl.slmeta"
  File "shaders\k3d_smoke.sl"
  File "shaders\k3d_smoke.sl.slmeta"
  File "shaders\k3d_smoke2.sl"
  File "shaders\k3d_softboxes.sl"
  File "shaders\k3d_spacecloud.sl"
  File "shaders\k3d_spaceshiphull1.sl"
  File "shaders\k3d_spaceshiphull1.sl.slmeta"
  File "shaders\k3d_spotlight.sl"
  File "shaders\k3d_spotlight.sl.slmeta"
  File "shaders\k3d_square_ridges.sl"
  File "shaders\k3d_square_ridges.sl.slmeta"
  File "shaders\k3d_srfdeformation.sl"
  File "shaders\k3d_star.sl"
  File "shaders\k3d_starfield.sl"
  File "shaders\k3d_starfield.sl.slmeta"
  File "shaders\k3d_stones.sl"
  File "shaders\k3d_strata.sl"
  File "shaders\k3d_strata.sl.slmeta"
  File "shaders\k3d_stucco.sl"
  File "shaders\k3d_stucco.sl.slmeta"
  File "shaders\k3d_superkagee.sl"
  File "shaders\k3d_superplank.sl"
  File "shaders\k3d_superplank.sl.slmeta"
  File "shaders\k3d_superpplastic.sl"
  File "shaders\k3d_superpplastic.sl.slmeta"
  File "shaders\k3d_supertexmap.sl"
  File "shaders\k3d_supertexmap.sl.slmeta"
  File "shaders\k3d_supertoon.sl"
  File "shaders\k3d_terran.sl"
  File "shaders\k3d_terran.sl.slmeta"
  File "shaders\k3d_terran2.sl"
  File "shaders\k3d_terranbump.sl"
  File "shaders\k3d_terranbump.sl.slmeta"
  File "shaders\k3d_texblender.sl"
  File "shaders\k3d_threads.sl"
  File "shaders\k3d_tile.h"
  File "shaders\k3d_tooledsteel.sl"
  File "shaders\k3d_translucency.sl"
  File "shaders\k3d_uberlight.sl"
  File "shaders\k3d_uberlight.sl.slmeta"
  File "shaders\k3d_veinedmarble.sl"
  File "shaders\k3d_veinedmarble.sl.slmeta"
  File "shaders\k3d_velvet.sl"
  File "shaders\k3d_venus.sl"
  File "shaders\k3d_venus.sl.slmeta"
  File "shaders\k3d_venus2.sl"
  File "shaders\k3d_volcube.sl"
  File "shaders\k3d_wallpaper.sl"
  File "shaders\k3d_wallpaper_2stripe.sl"
  File "shaders\k3d_wallpaper_2stripe.sl.slmeta"
  File "shaders\k3d_warningstripes.sl"
  File "shaders\k3d_warningstripes.sl.slmeta"
  File "shaders\k3d_water.sl"
  File "shaders\k3d_watercolor.sl"
  File "shaders\k3d_waterdisplacement.sl"
  File "shaders\k3d_waterlight.sl"
  File "shaders\k3d_waterlight.sl.slmeta"
  File "shaders\k3d_windowlight.sl"
  File "shaders\k3d_windowlight.sl.slmeta"
  File "shaders\k3d_windywave.sl"
  File "shaders\k3d_windywave.sl.slmeta"
  File "shaders\k3d_wood2.sl"
  File "shaders\k3d_wood2.sl.slmeta"
  SetOutPath "$INSTDIR\share\desktop"
  File "share\desktop\k3d.desktop"
  File "share\desktop\k3d.desktop.in"
  SetOutPath "$INSTDIR\share\doc"
  File "share\doc\lsystem.txt"
  SetOutPath "$INSTDIR\share\icons"
  File "share\icons\favicon.ico"
  File "share\icons\favicon.png"
  File "share\icons\k3d.ico"
  File "share\icons\k3d.png"
  File "share\icons\k3d1.ico"
  File "share\icons\k3d1.png"
  File "share\icons\k3d2.ico"
  File "share\icons\k3d2.png"
  File "share\icons\k3d3.ico"
  File "share\icons\k3d3.png"
  SetOutPath "$INSTDIR\share\lsystem"
  File "share\lsystem\abop-2d-form.ls"
  File "share\lsystem\abop-block-form.ls"
  File "share\lsystem\abop-bush.ls"
  File "share\lsystem\abop-compound-leave-3d.ls"
  File "share\lsystem\abop-compound-leave.ls"
  File "share\lsystem\abop-cordate-leave.ls"
  File "share\lsystem\abop-dragon-curves.ls"
  File "share\lsystem\abop-fractal.ls"
  File "share\lsystem\abop-lychnis-structure.ls"
  File "share\lsystem\abop-maple-like-leave.ls"
  File "share\lsystem\abop-monopodial-tree.ls"
  File "share\lsystem\abop-monopodial-tree2.ls"
  File "share\lsystem\abop-nested-polygon-leaves.ls"
  File "share\lsystem\abop-plant.ls"
  File "share\lsystem\abop-ternary-tree.ls"
  File "share\lsystem\airhorse.ls"
  File "share\lsystem\axis.ls"
  File "share\lsystem\best-tree.ls"
  File "share\lsystem\cees-3dartist.ls"
  File "share\lsystem\cees-crystal-with-leaves.ls"
  File "share\lsystem\cees-crystal-with-leaves2.ls"
  File "share\lsystem\cees-crystal.ls"
  File "share\lsystem\cees-crystals.ls"
  File "share\lsystem\cees-koch.ls"
  File "share\lsystem\cees-koch2.ls"
  File "share\lsystem\cees-pascal-cube.ls"
  File "share\lsystem\cees-pascal-cube2.ls"
  File "share\lsystem\cees-passion-flower.ls"
  File "share\lsystem\cees-plant-kwal.ls"
  File "share\lsystem\cees-plant.ls"
  File "share\lsystem\cees-plant2.ls"
  File "share\lsystem\cees-sierpinski-gasket.ls"
  File "share\lsystem\cees-sierpinski-gasket2.ls"
  File "share\lsystem\cello-plant.ls"
  File "share\lsystem\circle-form.ls"
  File "share\lsystem\conifer-type-tree.ls"
  File "share\lsystem\conifer-type-tree2.ls"
  File "share\lsystem\cordate-leave-arrangement.ls"
  File "share\lsystem\cordate-leaves.ls"
  File "share\lsystem\dasysiphonia-rigidula.ls"
  File "share\lsystem\daysa-rigidula.ls"
  File "share\lsystem\fern-plant.ls"
  File "share\lsystem\flower.ls"
  File "share\lsystem\fractint.ls"
  File "share\lsystem\fractint2.ls"
  File "share\lsystem\fractint3.ls"
  File "share\lsystem\fractint4.ls"
  File "share\lsystem\half-cycle.ls"
  File "share\lsystem\half-cycle2.ls"
  File "share\lsystem\higgs-butterfly.ls"
  File "share\lsystem\higgs-copepoda-crustacean-mutated.ls"
  File "share\lsystem\higgs-copepoda-crustacean.ls"
  File "share\lsystem\higgs-lobster.ls"
  File "share\lsystem\higgs-sierpinski-variants.ls"
  File "share\lsystem\large-spiral-plant.ls"
  File "share\lsystem\large-spiral-plant2.ls"
  File "share\lsystem\leavy-ternary-tree-type.ls"
  File "share\lsystem\lobster-form.ls"
  File "share\lsystem\lobster-form2.ls"
  File "share\lsystem\lobster-form3.ls"
  File "share\lsystem\lobster-form4.ls"
  File "share\lsystem\lobster-form5.ls"
  File "share\lsystem\menger-cube.ls"
  File "share\lsystem\octo-spider.ls"
  File "share\lsystem\palm-tree.ls"
  File "share\lsystem\shell.ls"
  File "share\lsystem\shell2.ls"
  File "share\lsystem\shell3.ls"
  File "share\lsystem\shell4.ls"
  File "share\lsystem\spiral-bush.ls"
  File "share\lsystem\spiral-design.ls"
  File "share\lsystem\spiral-form.ls"
  File "share\lsystem\spiral-tree.ls"
  File "share\lsystem\spiral-types.ls"
  File "share\lsystem\tree-base.ls"
  File "share\lsystem\tree.ls"
  File "share\lsystem\tree2.ls"
  File "share\lsystem\tree3.ls"
  File "share\lsystem\trees.ls"
  File "share\lsystem\trees2.ls"
  File "share\lsystem\trees3.ls"
  File "share\lsystem\tropism-experimental-tree.ls"
  File "share\lsystem\tropism.ls"
  File "share\lsystem\willow-tree.ls"
  SetOutPath "$INSTDIR\share\man"
  File "share\man\k3d.1"
  File "share\man\k3d.1.in"
  SetOutPath "$INSTDIR\share"
  File "share\netpbm.conf"
  File "share\netpbm.conf.in"
  File "share\outputformats.conf"
  SetOutPath "$INSTDIR\share\python_engine"
  File "share\python_engine\k3d_interface.py"
  SetOutPath "$INSTDIR"
  File "sl2xml.exe"
  File "TODO"
  SetOutPath "$INSTDIR\tutorials"
  File "tutorials\data_entry"
  SetOutPath "$INSTDIR\tutorials\fr"
  File "tutorials\fr\pour_commencer"
  File "tutorials\fr\signalement_de_bugs"
  SetOutPath "$INSTDIR\tutorials"
  File "tutorials\getting_started"
  SetOutPath "$INSTDIR\tutorials\it"
  File "tutorials\it\getting_started"
  SetOutPath "$INSTDIR\tutorials"
  File "tutorials\mesh_booleans"
  File "tutorials\procedural_modeling"
  File "tutorials\reporting_bugs"
  File "tutorials\sds"
  SetOutPath "$INSTDIR\tutorials\se"
  File "tutorials\se\getting_started"
  SetOutPath "$INSTDIR\tutorials"
  File "tutorials\selection"
  File "tutorials\tutorialindex.k3d"
  File "tutorials\tutorialindex.k3d.fr"
  File "tutorials\tutorialindex.k3d.it"
  File "tutorials\tutorialindex.k3d.se"
  File "tutorials\viewport_navigation"
  File "tutorials\visualization"
  SetOutPath "$INSTDIR"
  File "zlib1.dll"
SectionEnd

Section -AdditionalIcons
  WriteIniStr "$INSTDIR\${PRODUCT_NAME}.url" "InternetShortcut" "URL" "${PRODUCT_WEB_SITE}"
  CreateShortCut "$SMPROGRAMS\K-3D\Website.lnk" "$INSTDIR\${PRODUCT_NAME}.url"
  CreateShortCut "$SMPROGRAMS\K-3D\Uninstall.lnk" "$INSTDIR\uninst.exe"
SectionEnd

Section -Post

;==========================================================
;
; Code to feed info to WriteToFileLin2 function, which
; writes the install path info into the k-3d.bat file.
;

Push 'set k3dpath="$INSTDIR"'
Push 2
Push "$INSTDIR\k3d.bat"
Call WriteToFileLine2


;==========================================================
;
; Old code, to write install path info to batch file, but
;it was a little bit messy, and caused some problems during
;testing

;FileOpen $4 "$INSTDIR\k3d.bat" a
;FileSeek $4 10 ;
;FileWrite $4 "$\r$\n" ; we write a new line
;FileWrite $4 'set k3dpath="$INSTDIR"'
;FileWrite $4 "$\r$\n" ; we write an extra line
;FileClose $4 ; and close the file

;==========================================================
;
; Standard post installation completion stuff.

  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\gpp.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\gpp.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"

SectionEnd

;==========================================================
;
; WriteToFileLine2 function that writes the path statement
; to k-3d.bat by overwriting line 2 in the file.


Function WriteToFileLine2
Exch $0 ;file
Exch
Exch $1 ;line number
Exch 2
Exch $2 ;string to write
Exch 2
Push $3
Push $4
Push $5
Push $6
Push $7

 GetTempFileName $7
 FileOpen $4 $0 r
 FileOpen $5 $7 w
 StrCpy $3 0

Loop:
ClearErrors
FileRead $4 $6
IfErrors Exit
 IntOp $3 $3 + 1
 StrCmp $3 $1 0 +3
FileWrite $5 "$2$\r$\n"
Goto Loop
FileWrite $5 $6
Goto Loop
Exit:

 FileClose $5
 FileClose $4

SetDetailsPrint none
Delete $0
Rename $7 $0
SetDetailsPrint both

Pop $7
Pop $6
Pop $5
Pop $4
Pop $3
Pop $2
Pop $1
Pop $0
FunctionEnd

Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  Delete "$INSTDIR\${PRODUCT_NAME}.url"
  Delete "$INSTDIR\uninst.exe"
  Delete "$INSTDIR\zlib1.dll"
  Delete "$INSTDIR\tutorials\visualization"
  Delete "$INSTDIR\tutorials\viewport_navigation"
  Delete "$INSTDIR\tutorials\tutorialindex.k3d.se"
  Delete "$INSTDIR\tutorials\tutorialindex.k3d.it"
  Delete "$INSTDIR\tutorials\tutorialindex.k3d.fr"
  Delete "$INSTDIR\tutorials\tutorialindex.k3d"
  Delete "$INSTDIR\tutorials\selection"
  Delete "$INSTDIR\tutorials\se\getting_started"
  Delete "$INSTDIR\tutorials\sds"
  Delete "$INSTDIR\tutorials\reporting_bugs"
  Delete "$INSTDIR\tutorials\procedural_modeling"
  Delete "$INSTDIR\tutorials\mesh_booleans"
  Delete "$INSTDIR\tutorials\it\getting_started"
  Delete "$INSTDIR\tutorials\getting_started"
  Delete "$INSTDIR\tutorials\fr\signalement_de_bugs"
  Delete "$INSTDIR\tutorials\fr\pour_commencer"
  Delete "$INSTDIR\tutorials\data_entry"
  Delete "$INSTDIR\TODO"
  Delete "$INSTDIR\sl2xml.exe"
  Delete "$INSTDIR\share\python_engine\k3d_interface.py"
  Delete "$INSTDIR\share\outputformats.conf"
  Delete "$INSTDIR\share\netpbm.conf.in"
  Delete "$INSTDIR\share\netpbm.conf"
  Delete "$INSTDIR\share\man\k3d.1.in"
  Delete "$INSTDIR\share\man\k3d.1"
  Delete "$INSTDIR\share\lsystem\willow-tree.ls"
  Delete "$INSTDIR\share\lsystem\tropism.ls"
  Delete "$INSTDIR\share\lsystem\tropism-experimental-tree.ls"
  Delete "$INSTDIR\share\lsystem\trees3.ls"
  Delete "$INSTDIR\share\lsystem\trees2.ls"
  Delete "$INSTDIR\share\lsystem\trees.ls"
  Delete "$INSTDIR\share\lsystem\tree3.ls"
  Delete "$INSTDIR\share\lsystem\tree2.ls"
  Delete "$INSTDIR\share\lsystem\tree.ls"
  Delete "$INSTDIR\share\lsystem\tree-base.ls"
  Delete "$INSTDIR\share\lsystem\spiral-types.ls"
  Delete "$INSTDIR\share\lsystem\spiral-tree.ls"
  Delete "$INSTDIR\share\lsystem\spiral-form.ls"
  Delete "$INSTDIR\share\lsystem\spiral-design.ls"
  Delete "$INSTDIR\share\lsystem\spiral-bush.ls"
  Delete "$INSTDIR\share\lsystem\shell4.ls"
  Delete "$INSTDIR\share\lsystem\shell3.ls"
  Delete "$INSTDIR\share\lsystem\shell2.ls"
  Delete "$INSTDIR\share\lsystem\shell.ls"
  Delete "$INSTDIR\share\lsystem\palm-tree.ls"
  Delete "$INSTDIR\share\lsystem\octo-spider.ls"
  Delete "$INSTDIR\share\lsystem\menger-cube.ls"
  Delete "$INSTDIR\share\lsystem\lobster-form5.ls"
  Delete "$INSTDIR\share\lsystem\lobster-form4.ls"
  Delete "$INSTDIR\share\lsystem\lobster-form3.ls"
  Delete "$INSTDIR\share\lsystem\lobster-form2.ls"
  Delete "$INSTDIR\share\lsystem\lobster-form.ls"
  Delete "$INSTDIR\share\lsystem\leavy-ternary-tree-type.ls"
  Delete "$INSTDIR\share\lsystem\large-spiral-plant2.ls"
  Delete "$INSTDIR\share\lsystem\large-spiral-plant.ls"
  Delete "$INSTDIR\share\lsystem\higgs-sierpinski-variants.ls"
  Delete "$INSTDIR\share\lsystem\higgs-lobster.ls"
  Delete "$INSTDIR\share\lsystem\higgs-copepoda-crustacean.ls"
  Delete "$INSTDIR\share\lsystem\higgs-copepoda-crustacean-mutated.ls"
  Delete "$INSTDIR\share\lsystem\higgs-butterfly.ls"
  Delete "$INSTDIR\share\lsystem\half-cycle2.ls"
  Delete "$INSTDIR\share\lsystem\half-cycle.ls"
  Delete "$INSTDIR\share\lsystem\fractint4.ls"
  Delete "$INSTDIR\share\lsystem\fractint3.ls"
  Delete "$INSTDIR\share\lsystem\fractint2.ls"
  Delete "$INSTDIR\share\lsystem\fractint.ls"
  Delete "$INSTDIR\share\lsystem\flower.ls"
  Delete "$INSTDIR\share\lsystem\fern-plant.ls"
  Delete "$INSTDIR\share\lsystem\daysa-rigidula.ls"
  Delete "$INSTDIR\share\lsystem\dasysiphonia-rigidula.ls"
  Delete "$INSTDIR\share\lsystem\cordate-leaves.ls"
  Delete "$INSTDIR\share\lsystem\cordate-leave-arrangement.ls"
  Delete "$INSTDIR\share\lsystem\conifer-type-tree2.ls"
  Delete "$INSTDIR\share\lsystem\conifer-type-tree.ls"
  Delete "$INSTDIR\share\lsystem\circle-form.ls"
  Delete "$INSTDIR\share\lsystem\cello-plant.ls"
  Delete "$INSTDIR\share\lsystem\cees-sierpinski-gasket2.ls"
  Delete "$INSTDIR\share\lsystem\cees-sierpinski-gasket.ls"
  Delete "$INSTDIR\share\lsystem\cees-plant2.ls"
  Delete "$INSTDIR\share\lsystem\cees-plant.ls"
  Delete "$INSTDIR\share\lsystem\cees-plant-kwal.ls"
  Delete "$INSTDIR\share\lsystem\cees-passion-flower.ls"
  Delete "$INSTDIR\share\lsystem\cees-pascal-cube2.ls"
  Delete "$INSTDIR\share\lsystem\cees-pascal-cube.ls"
  Delete "$INSTDIR\share\lsystem\cees-koch2.ls"
  Delete "$INSTDIR\share\lsystem\cees-koch.ls"
  Delete "$INSTDIR\share\lsystem\cees-crystals.ls"
  Delete "$INSTDIR\share\lsystem\cees-crystal.ls"
  Delete "$INSTDIR\share\lsystem\cees-crystal-with-leaves2.ls"
  Delete "$INSTDIR\share\lsystem\cees-crystal-with-leaves.ls"
  Delete "$INSTDIR\share\lsystem\cees-3dartist.ls"
  Delete "$INSTDIR\share\lsystem\best-tree.ls"
  Delete "$INSTDIR\share\lsystem\axis.ls"
  Delete "$INSTDIR\share\lsystem\airhorse.ls"
  Delete "$INSTDIR\share\lsystem\abop-ternary-tree.ls"
  Delete "$INSTDIR\share\lsystem\abop-plant.ls"
  Delete "$INSTDIR\share\lsystem\abop-nested-polygon-leaves.ls"
  Delete "$INSTDIR\share\lsystem\abop-monopodial-tree2.ls"
  Delete "$INSTDIR\share\lsystem\abop-monopodial-tree.ls"
  Delete "$INSTDIR\share\lsystem\abop-maple-like-leave.ls"
  Delete "$INSTDIR\share\lsystem\abop-lychnis-structure.ls"
  Delete "$INSTDIR\share\lsystem\abop-fractal.ls"
  Delete "$INSTDIR\share\lsystem\abop-dragon-curves.ls"
  Delete "$INSTDIR\share\lsystem\abop-cordate-leave.ls"
  Delete "$INSTDIR\share\lsystem\abop-compound-leave.ls"
  Delete "$INSTDIR\share\lsystem\abop-compound-leave-3d.ls"
  Delete "$INSTDIR\share\lsystem\abop-bush.ls"
  Delete "$INSTDIR\share\lsystem\abop-block-form.ls"
  Delete "$INSTDIR\share\lsystem\abop-2d-form.ls"
  Delete "$INSTDIR\share\icons\k3d3.png"
  Delete "$INSTDIR\share\icons\k3d3.ico"
  Delete "$INSTDIR\share\icons\k3d2.png"
  Delete "$INSTDIR\share\icons\k3d2.ico"
  Delete "$INSTDIR\share\icons\k3d1.png"
  Delete "$INSTDIR\share\icons\k3d1.ico"
  Delete "$INSTDIR\share\icons\k3d.png"
  Delete "$INSTDIR\share\icons\k3d.ico"
  Delete "$INSTDIR\share\icons\favicon.png"
  Delete "$INSTDIR\share\icons\favicon.ico"
  Delete "$INSTDIR\share\doc\lsystem.txt"
  Delete "$INSTDIR\share\desktop\k3d.desktop.in"
  Delete "$INSTDIR\share\desktop\k3d.desktop"
  Delete "$INSTDIR\shaders\k3d_wood2.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_wood2.sl"
  Delete "$INSTDIR\shaders\k3d_windywave.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_windywave.sl"
  Delete "$INSTDIR\shaders\k3d_windowlight.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_windowlight.sl"
  Delete "$INSTDIR\shaders\k3d_waterlight.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_waterlight.sl"
  Delete "$INSTDIR\shaders\k3d_waterdisplacement.sl"
  Delete "$INSTDIR\shaders\k3d_watercolor.sl"
  Delete "$INSTDIR\shaders\k3d_water.sl"
  Delete "$INSTDIR\shaders\k3d_warningstripes.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_warningstripes.sl"
  Delete "$INSTDIR\shaders\k3d_wallpaper_2stripe.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_wallpaper_2stripe.sl"
  Delete "$INSTDIR\shaders\k3d_wallpaper.sl"
  Delete "$INSTDIR\shaders\k3d_volcube.sl"
  Delete "$INSTDIR\shaders\k3d_venus2.sl"
  Delete "$INSTDIR\shaders\k3d_venus.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_venus.sl"
  Delete "$INSTDIR\shaders\k3d_velvet.sl"
  Delete "$INSTDIR\shaders\k3d_veinedmarble.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_veinedmarble.sl"
  Delete "$INSTDIR\shaders\k3d_uberlight.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_uberlight.sl"
  Delete "$INSTDIR\shaders\k3d_translucency.sl"
  Delete "$INSTDIR\shaders\k3d_tooledsteel.sl"
  Delete "$INSTDIR\shaders\k3d_tile.h"
  Delete "$INSTDIR\shaders\k3d_threads.sl"
  Delete "$INSTDIR\shaders\k3d_texblender.sl"
  Delete "$INSTDIR\shaders\k3d_terranbump.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_terranbump.sl"
  Delete "$INSTDIR\shaders\k3d_terran2.sl"
  Delete "$INSTDIR\shaders\k3d_terran.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_terran.sl"
  Delete "$INSTDIR\shaders\k3d_supertoon.sl"
  Delete "$INSTDIR\shaders\k3d_supertexmap.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_supertexmap.sl"
  Delete "$INSTDIR\shaders\k3d_superpplastic.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_superpplastic.sl"
  Delete "$INSTDIR\shaders\k3d_superplank.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_superplank.sl"
  Delete "$INSTDIR\shaders\k3d_superkagee.sl"
  Delete "$INSTDIR\shaders\k3d_stucco.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_stucco.sl"
  Delete "$INSTDIR\shaders\k3d_strata.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_strata.sl"
  Delete "$INSTDIR\shaders\k3d_stones.sl"
  Delete "$INSTDIR\shaders\k3d_starfield.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_starfield.sl"
  Delete "$INSTDIR\shaders\k3d_star.sl"
  Delete "$INSTDIR\shaders\k3d_srfdeformation.sl"
  Delete "$INSTDIR\shaders\k3d_square_ridges.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_square_ridges.sl"
  Delete "$INSTDIR\shaders\k3d_spotlight.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_spotlight.sl"
  Delete "$INSTDIR\shaders\k3d_spaceshiphull1.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_spaceshiphull1.sl"
  Delete "$INSTDIR\shaders\k3d_spacecloud.sl"
  Delete "$INSTDIR\shaders\k3d_softboxes.sl"
  Delete "$INSTDIR\shaders\k3d_smoke2.sl"
  Delete "$INSTDIR\shaders\k3d_smoke.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_smoke.sl"
  Delete "$INSTDIR\shaders\k3d_slideprojector.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_slideprojector.sl"
  Delete "$INSTDIR\shaders\k3d_slateroofd.sl"
  Delete "$INSTDIR\shaders\k3d_slateroof.sl"
  Delete "$INSTDIR\shaders\k3d_skymetal.sl"
  Delete "$INSTDIR\shaders\k3d_skin2.sl"
  Delete "$INSTDIR\shaders\k3d_skin1.sl"
  Delete "$INSTDIR\shaders\k3d_show_st.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_show_st.sl"
  Delete "$INSTDIR\shaders\k3d_shinyplastic.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_shinyplastic.sl"
  Delete "$INSTDIR\shaders\k3d_shinymetal.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_shinymetal.sl"
  Delete "$INSTDIR\shaders\k3d_shiny.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_shiny.sl"
  Delete "$INSTDIR\shaders\k3d_shiftedmoontile.sl"
  Delete "$INSTDIR\shaders\k3d_shifteddrtile.sl"
  Delete "$INSTDIR\shaders\k3d_shadowspot.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_shadowspot.sl"
  Delete "$INSTDIR\shaders\k3d_shadowdistant_rim.sl"
  Delete "$INSTDIR\shaders\k3d_sdixon.sl"
  Delete "$INSTDIR\shaders\k3d_screen_aa.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_screen_aa.sl"
  Delete "$INSTDIR\shaders\k3d_screen.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_screen.sl"
  Delete "$INSTDIR\shaders\k3d_scartissue.sl"
  Delete "$INSTDIR\shaders\k3d_saturnring.sl"
  Delete "$INSTDIR\shaders\k3d_saturn.sl"
  Delete "$INSTDIR\shaders\k3d_rustymetal.sl"
  Delete "$INSTDIR\shaders\k3d_ruledpaper.sl"
  Delete "$INSTDIR\shaders\k3d_rubber.sl"
  Delete "$INSTDIR\shaders\k3d_round.sl"
  Delete "$INSTDIR\shaders\k3d_roughmetal.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_roughmetal.sl"
  Delete "$INSTDIR\shaders\k3d_rmannotes.h"
  Delete "$INSTDIR\shaders\k3d_ripple.sl"
  Delete "$INSTDIR\shaders\k3d_ridged_multifractal.sl"
  Delete "$INSTDIR\shaders\k3d_reflections.h"
  Delete "$INSTDIR\shaders\k3d_redapple.sl"
  Delete "$INSTDIR\shaders\k3d_raysphere.h"
  Delete "$INSTDIR\shaders\k3d_rayserver.h"
  Delete "$INSTDIR\shaders\k3d_puffyclouds.sl"
  Delete "$INSTDIR\shaders\k3d_pshad.h"
  Delete "$INSTDIR\shaders\k3d_projectionmap_plastic.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_projectionmap_plastic.sl"
  Delete "$INSTDIR\shaders\k3d_project.h"
  Delete "$INSTDIR\shaders\k3d_proctext.h"
  Delete "$INSTDIR\shaders\k3d_pointlight.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_pointlight.sl"
  Delete "$INSTDIR\shaders\k3d_plastic2.sl"
  Delete "$INSTDIR\shaders\k3d_plastic.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_plastic.sl"
  Delete "$INSTDIR\shaders\k3d_plank.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_plank.sl"
  Delete "$INSTDIR\shaders\k3d_planetclouds.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_planetclouds.sl"
  Delete "$INSTDIR\shaders\k3d_patterns.h"
  Delete "$INSTDIR\shaders\k3d_particle.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_particle.sl"
  Delete "$INSTDIR\shaders\k3d_parquet_tile.sl"
  Delete "$INSTDIR\shaders\k3d_parquet_plank2.sl"
  Delete "$INSTDIR\shaders\k3d_parquet_plank.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_parquet_plank.sl"
  Delete "$INSTDIR\shaders\k3d_painted_constant.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_painted_constant.sl"
  Delete "$INSTDIR\shaders\k3d_paintedplastic.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_paintedplastic.sl"
  Delete "$INSTDIR\shaders\k3d_outline.sl"
  Delete "$INSTDIR\shaders\k3d_outlet.sl"
  Delete "$INSTDIR\shaders\k3d_orennayar.sl"
  Delete "$INSTDIR\shaders\k3d_orange.sl"
  Delete "$INSTDIR\shaders\k3d_oakplank.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_oakplank.sl"
  Delete "$INSTDIR\shaders\k3d_oak.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_oak.sl"
  Delete "$INSTDIR\shaders\k3d_oak.h"
  Delete "$INSTDIR\shaders\k3d_null.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_null.sl"
  Delete "$INSTDIR\shaders\k3d_noisysmoke.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_noisysmoke.sl"
  Delete "$INSTDIR\shaders\k3d_noises.h"
  Delete "$INSTDIR\shaders\k3d_mysky.sl"
  Delete "$INSTDIR\shaders\k3d_mondometal.sl"
  Delete "$INSTDIR\shaders\k3d_metal.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_metal.sl"
  Delete "$INSTDIR\shaders\k3d_matte.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_matte.sl"
  Delete "$INSTDIR\shaders\k3d_material.h"
  Delete "$INSTDIR\shaders\k3d_lunette.sl"
  Delete "$INSTDIR\shaders\k3d_luna.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_luna.sl"
  Delete "$INSTDIR\shaders\k3d_locillum.h"
  Delete "$INSTDIR\shaders\k3d_lensflare.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_lensflare.sl"
  Delete "$INSTDIR\shaders\k3d_leather.sl"
  Delete "$INSTDIR\shaders\k3d_km.h"
  Delete "$INSTDIR\shaders\k3d_isshad.h"
  Delete "$INSTDIR\shaders\k3d_indirect.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_indirect.sl"
  Delete "$INSTDIR\shaders\k3d_incandplastic.sl"
  Delete "$INSTDIR\shaders\k3d_imagelayergradient.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_imagelayergradient.sl"
  Delete "$INSTDIR\shaders\k3d_imagelayerclouds.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_imagelayerclouds.sl"
  Delete "$INSTDIR\shaders\k3d_hextile.sl"
  Delete "$INSTDIR\shaders\k3d_hexatile_bump.sl"
  Delete "$INSTDIR\shaders\k3d_hdr_surface.sl"
  Delete "$INSTDIR\shaders\k3d_hdr_light.sl"
  Delete "$INSTDIR\shaders\k3d_hdri2.sl"
  Delete "$INSTDIR\shaders\k3d_hdri1.sl"
  Delete "$INSTDIR\shaders\k3d_hair.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_hair.sl"
  Delete "$INSTDIR\shaders\k3d_greenmarble.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_greenmarble.sl"
  Delete "$INSTDIR\shaders\k3d_grass_surface.sl"
  Delete "$INSTDIR\shaders\k3d_grass_displace.sl"
  Delete "$INSTDIR\shaders\k3d_granite.sl"
  Delete "$INSTDIR\shaders\k3d_gradient_t.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_gradient_t.sl"
  Delete "$INSTDIR\shaders\k3d_gouge.sl"
  Delete "$INSTDIR\shaders\k3d_gooch.sl"
  Delete "$INSTDIR\shaders\k3d_gmarbtile_polish.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_gmarbtile_polish.sl"
  Delete "$INSTDIR\shaders\k3d_glow.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_glow.sl"
  Delete "$INSTDIR\shaders\k3d_gloop.sl"
  Delete "$INSTDIR\shaders\k3d_glass.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_glass.sl"
  Delete "$INSTDIR\shaders\k3d_fur2.sl"
  Delete "$INSTDIR\shaders\k3d_fur1.sl"
  Delete "$INSTDIR\shaders\k3d_funkyglass.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_funkyglass.sl"
  Delete "$INSTDIR\shaders\k3d_fresnelplastic.sl"
  Delete "$INSTDIR\shaders\k3d_fractal.sl"
  Delete "$INSTDIR\shaders\k3d_fog.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_fog.sl"
  Delete "$INSTDIR\shaders\k3d_flame.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_flame.sl"
  Delete "$INSTDIR\shaders\k3d_fire.sl"
  Delete "$INSTDIR\shaders\k3d_filterwidth.h"
  Delete "$INSTDIR\shaders\k3d_fill.sl"
  Delete "$INSTDIR\shaders\k3d_filament.sl"
  Delete "$INSTDIR\shaders\k3d_fakesky.sl"
  Delete "$INSTDIR\shaders\k3d_face_plastic.sl"
  Delete "$INSTDIR\shaders\k3d_ez.sl"
  Delete "$INSTDIR\shaders\k3d_eyeball.sl"
  Delete "$INSTDIR\shaders\k3d_eroded.sl"
  Delete "$INSTDIR\shaders\k3d_envsurf.sl"
  Delete "$INSTDIR\shaders\k3d_emboss.sl"
  Delete "$INSTDIR\shaders\k3d_ember.sl"
  Delete "$INSTDIR\shaders\k3d_easysurface.sl"
  Delete "$INSTDIR\shaders\k3d_dturb.sl"
  Delete "$INSTDIR\shaders\k3d_droop.sl"
  Delete "$INSTDIR\shaders\k3d_distant_shadow.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_distant_shadow.sl"
  Delete "$INSTDIR\shaders\k3d_distantlight.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_distantlight.sl"
  Delete "$INSTDIR\shaders\k3d_displacementmap.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_displacementmap.sl"
  Delete "$INSTDIR\shaders\k3d_displace.h"
  Delete "$INSTDIR\shaders\k3d_depthcue.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_depthcue.sl"
  Delete "$INSTDIR\shaders\k3d_dented.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_dented.sl"
  Delete "$INSTDIR\shaders\k3d_defaultsurface.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_defaultsurface.sl"
  Delete "$INSTDIR\shaders\k3d_decalplastic.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_decalplastic.sl"
  Delete "$INSTDIR\shaders\k3d_cyclone.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_cyclone.sl"
  Delete "$INSTDIR\shaders\k3d_cs.sl"
  Delete "$INSTDIR\shaders\k3d_crayontoon.sl"
  Delete "$INSTDIR\shaders\k3d_crayon.sl"
  Delete "$INSTDIR\shaders\k3d_craters.sl"
  Delete "$INSTDIR\shaders\k3d_corktile.sl"
  Delete "$INSTDIR\shaders\k3d_contacshadow.sl"
  Delete "$INSTDIR\shaders\k3d_constant.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_constant.sl"
  Delete "$INSTDIR\shaders\k3d_cloudplane.sl"
  Delete "$INSTDIR\shaders\k3d_clay.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_clay.sl"
  Delete "$INSTDIR\shaders\k3d_clamptoalpha.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_clamptoalpha.sl"
  Delete "$INSTDIR\shaders\k3d_checkerboard_solid.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_checkerboard_solid.sl"
  Delete "$INSTDIR\shaders\k3d_checkerboard.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_checkerboard.sl"
  Delete "$INSTDIR\shaders\k3d_ceramictiles.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_ceramictiles.sl"
  Delete "$INSTDIR\shaders\k3d_ceramic.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_ceramic.sl"
  Delete "$INSTDIR\shaders\k3d_celld.sl"
  Delete "$INSTDIR\shaders\k3d_causticlight.sl"
  Delete "$INSTDIR\shaders\k3d_castucco.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_castucco.sl"
  Delete "$INSTDIR\shaders\k3d_bubbly.sl"
  Delete "$INSTDIR\shaders\k3d_bubbles.sl"
  Delete "$INSTDIR\shaders\k3d_brushedmetal3.sl"
  Delete "$INSTDIR\shaders\k3d_brushedmetal2.sl"
  Delete "$INSTDIR\shaders\k3d_brushedmetal.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_brushedmetal.sl"
  Delete "$INSTDIR\shaders\k3d_brickperturb.sl"
  Delete "$INSTDIR\shaders\k3d_brickbump3.sl"
  Delete "$INSTDIR\shaders\k3d_brickbump2.sl"
  Delete "$INSTDIR\shaders\k3d_brickbump.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_brickbump.sl"
  Delete "$INSTDIR\shaders\k3d_brickanti.sl"
  Delete "$INSTDIR\shaders\k3d_brick3.sl"
  Delete "$INSTDIR\shaders\k3d_brick2.sl"
  Delete "$INSTDIR\shaders\k3d_brick.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_brick.sl"
  Delete "$INSTDIR\shaders\k3d_bluemarble.sl"
  Delete "$INSTDIR\shaders\k3d_background.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_background.sl"
  Delete "$INSTDIR\shaders\k3d_arealight.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_arealight.sl"
  Delete "$INSTDIR\shaders\k3d_antialiasedchecks.sl"
  Delete "$INSTDIR\shaders\k3d_ambientlight.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_ambientlight.sl"
  Delete "$INSTDIR\shaders\k3d_altitude_fog.sl.slmeta"
  Delete "$INSTDIR\shaders\k3d_altitude_fog.sl"
  Delete "$INSTDIR\scripts\script_context.python"
  Delete "$INSTDIR\scripts\script_context.javascript"
  Delete "$INSTDIR\scripts\render_test.javascript"
  Delete "$INSTDIR\scripts\point_shadowmaps.javascript"
  Delete "$INSTDIR\scripts\innovation.javascript"
  Delete "$INSTDIR\scripts\howdy_world.python"
  Delete "$INSTDIR\scripts\howdy_world.javascript"
  Delete "$INSTDIR\scripts\export_raw.python"
  Delete "$INSTDIR\scripts\describe_plugins.python"
  Delete "$INSTDIR\scripts\describe_plugins.javascript"
  Delete "$INSTDIR\scripts\describe_object_properties.javascript"
  Delete "$INSTDIR\scripts\describe_object.javascript"
  Delete "$INSTDIR\scripts\dag_test2.javascript"
  Delete "$INSTDIR\scripts\dag_test.javascript"
  Delete "$INSTDIR\scripts\create_mesh.python"
  Delete "$INSTDIR\scripts\command_node_inspector.python"
  Delete "$INSTDIR\scripts\blobby.python"
  Delete "$INSTDIR\README"
  Delete "$INSTDIR\python23.dll"
  Delete "$INSTDIR\options.k3d"
  Delete "$INSTDIR\NEWS"
  Delete "$INSTDIR\libtiff3.dll"
  Delete "$INSTDIR\libsigc-2.0-0.dll"
  Delete "$INSTDIR\libsigc-1.2-5.dll"
  Delete "$INSTDIR\libsdpxml-0.dll"
  Delete "$INSTDIR\libsdpsl-0.dll"
  Delete "$INSTDIR\libsdpgtk-0.dll"
  Delete "$INSTDIR\libsdpgl-0.dll"
  Delete "$INSTDIR\libraries\libk3dyafray-0.dll"
  Delete "$INSTDIR\libraries\libk3dviewport-0.dll"
  Delete "$INSTDIR\libraries\libk3dtiff-0.dll"
  Delete "$INSTDIR\libraries\libk3drenderman-0.dll"
  Delete "$INSTDIR\libraries\libk3dqslim-0.dll"
  Delete "$INSTDIR\libraries\libk3dpython-0.dll"
  Delete "$INSTDIR\libraries\libk3dpov-0.dll"
  Delete "$INSTDIR\libraries\libk3dmesh-0.dll"
  Delete "$INSTDIR\libraries\libk3dlsystem-0.dll"
  Delete "$INSTDIR\libraries\libk3djavascript-0.dll"
  Delete "$INSTDIR\libraries\libk3dgraphviz-0.dll"
  Delete "$INSTDIR\libraries\libk3dgeometry-0.dll"
  Delete "$INSTDIR\libraries\libk3dfreetype2-0.dll"
  Delete "$INSTDIR\libraries\libk3dcore-0.dll"
  Delete "$INSTDIR\libraries\libk3dchem-0.dll"
  Delete "$INSTDIR\libraries\libk3dchannels-0.dll"
  Delete "$INSTDIR\libraries\libk3dbitmap-0.dll"
  Delete "$INSTDIR\libk3dui-0.dll"
  Delete "$INSTDIR\libk3dsdk-0.dll"
  Delete "$INSTDIR\libk3dembed-0.dll"
  Delete "$INSTDIR\libHapy-0.dll"
  Delete "$INSTDIR\libgtk-0.dll"
  Delete "$INSTDIR\libgthread-2.0-0.dll"
  Delete "$INSTDIR\libgobject-2.0-0.dll"
  Delete "$INSTDIR\libgmodule-2.0-0.dll"
  Delete "$INSTDIR\libglib-2.0-0.dll"
  Delete "$INSTDIR\libgdk-0.dll"
  Delete "$INSTDIR\k3d.bat"
  Delete "$INSTDIR\k3d-renderjob.exe"
  Delete "$INSTDIR\k3d-renderframe.exe"
  Delete "$INSTDIR\k3d-makempeg"
  Delete "$INSTDIR\k3d-config"
  Delete "$INSTDIR\k3d-bin.exe"
  Delete "$INSTDIR\jpeg62.dll"
  Delete "$INSTDIR\intl.dll"
  Delete "$INSTDIR\INSTALL"
  Delete "$INSTDIR\iconv.dll"
  Delete "$INSTDIR\gpp.exe"
  Delete "$INSTDIR\freetype6.dll"
  Delete "$INSTDIR\dialogtemplates\viewport_window.gtkml"
  Delete "$INSTDIR\dialogtemplates\tutorial_recorder.gtkml"
  Delete "$INSTDIR\dialogtemplates\tutorial_message.gtkml"
  Delete "$INSTDIR\dialogtemplates\tutorial_menu.gtkml"
  Delete "$INSTDIR\dialogtemplates\translate-tool32.xpm"
  Delete "$INSTDIR\dialogtemplates\translate-tool24.xpm"
  Delete "$INSTDIR\dialogtemplates\stop.xpm"
  Delete "$INSTDIR\dialogtemplates\splash.xpm"
  Delete "$INSTDIR\dialogtemplates\splash.gtkml"
  Delete "$INSTDIR\dialogtemplates\sphere-object32.xpm"
  Delete "$INSTDIR\dialogtemplates\sphere-object24.xpm"
  Delete "$INSTDIR\dialogtemplates\select_point_groups.xpm"
  Delete "$INSTDIR\dialogtemplates\select_points.xpm"
  Delete "$INSTDIR\dialogtemplates\select_patches.xpm"
  Delete "$INSTDIR\dialogtemplates\select_objects.xpm"
  Delete "$INSTDIR\dialogtemplates\select_meshes.xpm"
  Delete "$INSTDIR\dialogtemplates\select_faces.xpm"
  Delete "$INSTDIR\dialogtemplates\select_edges.xpm"
  Delete "$INSTDIR\dialogtemplates\select_curves.xpm"
  Delete "$INSTDIR\dialogtemplates\script_editor.gtkml"
  Delete "$INSTDIR\dialogtemplates\script.xpm"
  Delete "$INSTDIR\dialogtemplates\scale-tool32.xpm"
  Delete "$INSTDIR\dialogtemplates\scale-tool24.xpm"
  Delete "$INSTDIR\dialogtemplates\scalar_bezier_channel.gtkml"
  Delete "$INSTDIR\dialogtemplates\save_viewport_frame.xpm"
  Delete "$INSTDIR\dialogtemplates\save_viewport_animation.xpm"
  Delete "$INSTDIR\dialogtemplates\save.xpm"
  Delete "$INSTDIR\dialogtemplates\rotate-tool32.xpm"
  Delete "$INSTDIR\dialogtemplates\rotate-tool24.xpm"
  Delete "$INSTDIR\dialogtemplates\rewind.xpm"
  Delete "$INSTDIR\dialogtemplates\renderpreview.xpm"
  Delete "$INSTDIR\dialogtemplates\renderframe.xpm"
  Delete "$INSTDIR\dialogtemplates\renderanimation.xpm"
  Delete "$INSTDIR\dialogtemplates\renameobject.gtkml"
  Delete "$INSTDIR\dialogtemplates\recordframe.xpm"
  Delete "$INSTDIR\dialogtemplates\record.xpm"
  Delete "$INSTDIR\dialogtemplates\query.xpm"
  Delete "$INSTDIR\dialogtemplates\query.gtkml"
  Delete "$INSTDIR\dialogtemplates\property_unlinked.xpm"
  Delete "$INSTDIR\dialogtemplates\property_linked.xpm"
  Delete "$INSTDIR\dialogtemplates\property_button.gtkml"
  Delete "$INSTDIR\dialogtemplates\play_from_cursor.xpm"
  Delete "$INSTDIR\dialogtemplates\playreverseloop.xpm"
  Delete "$INSTDIR\dialogtemplates\playreverse.xpm"
  Delete "$INSTDIR\dialogtemplates\playloop.xpm"
  Delete "$INSTDIR\dialogtemplates\play.xpm"
  Delete "$INSTDIR\dialogtemplates\options.gtkml"
  Delete "$INSTDIR\dialogtemplates\open.xpm"
  Delete "$INSTDIR\dialogtemplates\new.xpm"
  Delete "$INSTDIR\dialogtemplates\mouse_rmb_2.xpm"
  Delete "$INSTDIR\dialogtemplates\mouse_rmb_1.xpm"
  Delete "$INSTDIR\dialogtemplates\mouse_rmb.xpm"
  Delete "$INSTDIR\dialogtemplates\mouse_mmb_2.xpm"
  Delete "$INSTDIR\dialogtemplates\mouse_mmb_1.xpm"
  Delete "$INSTDIR\dialogtemplates\mouse_mmb.xpm"
  Delete "$INSTDIR\dialogtemplates\mouse_lmb_rmb.xpm"
  Delete "$INSTDIR\dialogtemplates\mouse_lmb_2.xpm"
  Delete "$INSTDIR\dialogtemplates\mouse_lmb_1.xpm"
  Delete "$INSTDIR\dialogtemplates\mouse_lmb.xpm"
  Delete "$INSTDIR\dialogtemplates\mouse_dim.xpm"
  Delete "$INSTDIR\dialogtemplates\mouse.xpm"
  Delete "$INSTDIR\dialogtemplates\modifiers_shift.xpm"
  Delete "$INSTDIR\dialogtemplates\modifiers_shift+lock.xpm"
  Delete "$INSTDIR\dialogtemplates\modifiers_shift+lock+control.xpm"
  Delete "$INSTDIR\dialogtemplates\modifiers_shift+control.xpm"
  Delete "$INSTDIR\dialogtemplates\modifiers_none.xpm"
  Delete "$INSTDIR\dialogtemplates\modifiers_lock.xpm"
  Delete "$INSTDIR\dialogtemplates\modifiers_lock+control.xpm"
  Delete "$INSTDIR\dialogtemplates\modifiers_dim.xpm"
  Delete "$INSTDIR\dialogtemplates\modifiers_control.xpm"
  Delete "$INSTDIR\dialogtemplates\message.gtkml"
  Delete "$INSTDIR\dialogtemplates\material-object24.xpm"
  Delete "$INSTDIR\dialogtemplates\inline_script_editor.gtkml"
  Delete "$INSTDIR\dialogtemplates\fastforward.xpm"
  Delete "$INSTDIR\dialogtemplates\error.xpm"
  Delete "$INSTDIR\dialogtemplates\error.gtkml"
  Delete "$INSTDIR\dialogtemplates\document_window.gtkml"
  Delete "$INSTDIR\dialogtemplates\dag_window.gtkml"
  Delete "$INSTDIR\dialogtemplates\dag_control.gtkml"
  Delete "$INSTDIR\dialogtemplates\cube-object32.xpm"
  Delete "$INSTDIR\dialogtemplates\cube-object24.xpm"
  Delete "$INSTDIR\dialogtemplates\connect_properties.gtkml"
  Delete "$INSTDIR\dialogtemplates\cone-object32.xpm"
  Delete "$INSTDIR\dialogtemplates\cone-object24.xpm"
  Delete "$INSTDIR\dialogtemplates\command_node_inspector.gtkml"
  Delete "$INSTDIR\dialogtemplates\color_bezier_channel.gtkml"
  Delete "$INSTDIR\dialogtemplates\camera-object32.xpm"
  Delete "$INSTDIR\dialogtemplates\bone-object32.xpm"
  Delete "$INSTDIR\dialogtemplates\bone-object24.xpm"
  Delete "$INSTDIR\dialogtemplates\black_box_recorder.gtkml"
  Delete "$INSTDIR\dialogtemplates\bezier-channel24.xpm"
  Delete "$INSTDIR\dialogtemplates\application_window.gtkml"
  Delete "$INSTDIR\dialogtemplates\about.xpm"
  Delete "$INSTDIR\dialogtemplates\about.gtkml"
  Delete "$INSTDIR\COPYING"
  Delete "$INSTDIR\charset.dll"
  Delete "$INSTDIR\ChangeLog"
  Delete "$INSTDIR\blackbox.log"
  Delete "$INSTDIR\AUTHORS"
  Delete "$INSTDIR\asprintf.dll"

  Delete "$SMPROGRAMS\K-3D\Uninstall.lnk"
  Delete "$SMPROGRAMS\K-3D\Website.lnk"
  Delete "$DESKTOP\K-3D.lnk"
  Delete "$SMPROGRAMS\K-3D\K-3D.lnk"

  RMDir "$SMPROGRAMS\K-3D"
  RMDir "$INSTDIR\tutorials\se"
  RMDir "$INSTDIR\tutorials\it"
  RMDir "$INSTDIR\tutorials\fr"
  RMDir "$INSTDIR\tutorials"
  RMDir "$INSTDIR\share\python_engine"
  RMDir "$INSTDIR\share\man"
  RMDir "$INSTDIR\share\lsystem"
  RMDir "$INSTDIR\share\icons"
  RMDir "$INSTDIR\share\doc"
  RMDir "$INSTDIR\share\desktop"
  RMDir "$INSTDIR\share"
  RMDir "$INSTDIR\shaders"
  RMDir "$INSTDIR\scripts"
  RMDir "$INSTDIR\libraries"
  RMDir "$INSTDIR\dialogtemplates"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  SetAutoClose true
SectionEnd
