// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\author Tim Shead (tshead@k-3d.com)
*/

#include <k3dsdk/classes.h>
#include <k3dsdk/object.h>
#include <k3dsdk/persistence.h>
#include <k3dsdk/measurement.h>
#include <k3dsdk/module.h>

#include <limits>

namespace libk3dcore
{

/////////////////////////////////////////////////////////////////////////////
// time_source_implementation

class time_source_implementation :
	public k3d::persistent<k3d::object> 
{
	typedef k3d::persistent<k3d::object>  base;

public:
	time_source_implementation(k3d::idocument& Document) :
		base(Document),
		m_start_time(k3d::init_name("start_time") + k3d::init_description("Start Time [seconds]") + k3d::init_value(0.0) + k3d::init_document(Document) + k3d::init_precision(2) + k3d::init_step_increment(0.1) + k3d::init_units(typeid(k3d::measurement::time))),
		m_end_time(k3d::init_name("end_time") + k3d::init_description("End Time [seconds]") + k3d::init_value(4.0) + k3d::init_document(Document) + k3d::init_precision(2) + k3d::init_step_increment(0.1) + k3d::init_units(typeid(k3d::measurement::time))),
		m_frame_rate(k3d::init_name("frame_rate") + k3d::init_description("Frame Rate [frames per second]") + k3d::init_value(30.0) + k3d::init_document(Document) + k3d::init_precision(2) + k3d::init_step_increment(1) + k3d::init_units(typeid(k3d::measurement::scalar)) + k3d::init_constraint(k3d::constraint::minimum(std::numeric_limits<double>::epsilon()))),
		m_time(k3d::init_name("time") + k3d::init_description("Time [seconds]") + k3d::init_value(0.0) + k3d::init_document(Document) + k3d::init_precision(2) + k3d::init_step_increment(0.1) + k3d::init_units(typeid(k3d::measurement::time)))
	{
		enable_serialization(k3d::persistence::proxy(m_start_time));
		enable_serialization(k3d::persistence::proxy(m_end_time));
		enable_serialization(k3d::persistence::proxy(m_frame_rate));
		enable_serialization(k3d::persistence::proxy(m_time));

		register_property(m_start_time);
		register_property(m_end_time);
		register_property(m_frame_rate);
		register_property(m_time);
	}

	k3d::iplugin_factory& factory()
	{
		return get_factory();
	}

	static k3d::iplugin_factory& get_factory()
	{
		static k3d::plugin_factory<k3d::document_plugin<time_source_implementation> > factory(
			k3d::classes::TimeSource(),
			"TimeSource",
			"Provides a time source for a K-3D document",
			"Objects",
			k3d::iplugin_factory::STABLE);

		return factory;
	}

private:
	k3d_measurement_property(double, k3d::immutable_name, k3d::change_signal, k3d::with_undo, k3d::local_storage, k3d::no_constraint) m_start_time;
	k3d_measurement_property(double, k3d::immutable_name, k3d::change_signal, k3d::with_undo, k3d::local_storage, k3d::no_constraint) m_end_time;
	k3d_measurement_property(double, k3d::immutable_name, k3d::change_signal, k3d::with_undo, k3d::local_storage, k3d::with_constraint) m_frame_rate;
	k3d_measurement_property(double, k3d::immutable_name, k3d::change_signal, k3d::no_undo, k3d::local_storage, k3d::no_constraint) m_time;
};

/////////////////////////////////////////////////////////////////////////////
// time_source_factory

k3d::iplugin_factory& time_source_factory()
{
	return time_source_implementation::get_factory();
}

} // namespace libk3dcore



