#ifndef K3DCONTROL_H
#define K3DCONTROL_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares the k3dControl class, which provides features common to all K-3D UI controls
		\author Tim Shead (tshead@k-3d.com)
*/

#include "k3duserinterfaceelement.h"

// Forward declarations
class k3d::idocument;
class k3d::istate_recorder;

/////////////////////////////////////////////////////////////////////////////
// k3dControl

/// Provides features common to all K-3D UI controls
class k3dControl :
	public k3dUserInterfaceElement
{
	typedef k3dUserInterfaceElement base;
	
public:
	k3dControl(k3d::iunknown* CommandNodeParent, const std::string& CommandNodeName);
	virtual ~k3dControl();

protected:
	bool Attach(k3d::istate_recorder* const StateRecorder, const std::string& StateChangeName);

	/// Stores an optional object that will record state changes for the undo/redo system
	k3d::istate_recorder* m_StateRecorder;
	/// Stores the state change name for undo / redo purposes
	std::string m_StateChangeName;
};

#endif // K3DCONTROL_H
