#include "gtkml.h"

#include <k3dsdk/application.h>
#include <k3dsdk/ioptions.h>

#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/path.hpp>

namespace k3d
{

namespace detail
{

boost::filesystem::path g_dialog_template_path;

} // namespace detail

void set_dialog_template_path(const boost::filesystem::path& Path)
{
	// Sanity checks ... this function can only be called once!
	assert(detail::g_dialog_template_path.empty());
	assert(!Path.empty());

	detail::g_dialog_template_path = Path;
}

const boost::filesystem::path dialog_template_path()
{
	// Sanity checks ... you *must* call set_dialog_template_path prior to calling this function!
	assert(!detail::g_dialog_template_path.empty());
	
	return detail::g_dialog_template_path;
}

const boost::filesystem::path preferred_language_template(const boost::filesystem::path& Template)
{
	const std::string preferred_language = k3d::application().options().preferred_language();
	if(!preferred_language.empty())
		{
			const boost::filesystem::path preferred_template = Template / "." / preferred_language;
			if(boost::filesystem::exists(preferred_template))
				return preferred_template;
		}
	
	return Template;
}

} // namespace k3d

