#ifndef K3DUI_BLACK_BOX_RECORDER_H
#define K3DUI_BLACK_BOX_RECORDER_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares the black_box_recorder class, which provides a UI for real-time recording of user actions for troubleshooting purposes
		\author Tim Shead (tshead@k-3d.com)
*/

#include "k3ddialog.h"

#include <boost/filesystem/path.hpp>
#include <boost/filesystem/fstream.hpp>

namespace k3d
{

// Forward declarations
class iscript_engine;

/////////////////////////////////////////////////////////////////////////////
// black_box_recorder

/// Implements the black box recorder
class black_box_recorder :
	public k3dDialog
{
	typedef k3dDialog base;

public:
	black_box_recorder(k3d::icommand_node& Parent, const boost::filesystem::path& LogFile);
	~black_box_recorder();

private:
	/// Called by the signal system as commands are emitted
	void on_command(k3d::icommand_node* CommandNode, k3d::icommand_node::command_t::type_t Type, std::string Command, std::string Arguments);

	/// Script engine for the script being recorded
	k3d::iscript_engine* m_script_engine;
	/// Path to the output file stream during recording
	boost::filesystem::path m_log_file;
	/// Output file stream during recording
	boost::filesystem::ofstream m_log_stream;
};

} // namespace k3d

#endif // K3DUI_BLACK_BOX_RECORDER_H
