#ifndef K3DSDK_GLUTILITY_PRIVATE_H
#define K3DSDK_GLUTILITY_PRIVATE_H

#include "iunknown.h"
#include <sdpgl/sdpgl.h>

namespace k3d
{

namespace implementation_private
{

#if SIZEOF_VOIDP == 4

inline void gl_load_name(const iunknown* const Name)
{
	::glLoadName(reinterpret_cast<GLuint>(Name));
}

inline void gl_push_name(const iunknown* const Name)
{
	::glPushName(reinterpret_cast<GLuint>(Name));
}

inline void gl_pop_name()
{
	::glPopName();
}

inline iunknown* gl_get_name(GLuint*& Names)
{
	iunknown* result = reinterpret_cast<iunknown*>(*Names);
	++Names;
	
	return result;
}

#elif SIZEOF_VOIDP == 8

#warning Since you are the bigshot owner of a 64 bit machine, please consider contributing a better implementation for the following functions
void gl_load_name(const iunknown* const Name);
void gl_push_name(const iunknown* const Name);
void gl_pop_name();
iunknown* gl_get_name(GLuint*& Names);

#else

	#error SIZEOF_VOIDP unknown or undefined - did you remember to run configure?

#endif
	
} // namespace implementation_private
	
} // namespace k3d

#endif // !K3DSDK_GLUTILITY_PRIVATE_H

