#ifndef K3DSDK_CHANNEL_H
#define K3DSDK_CHANNEL_H

// K-3D
// Copyright (c) 1995-2004, Timothy M. Shead
//
// Contact: tshead@k-3d.com
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

/** \file
		\brief Declares the k3d::channel namespace
		\author Tim Shead (tshead@k-3d.com)
*/

#include "vectors.h"
#include <boost/any.hpp>

namespace k3d
{

// Forward declarations
class iunknown;

namespace channel
{

/// Sets a channel to a constant value (if possible)
bool set_constant_value(iunknown& Channel, const boost::any Value);

/*
/// Sets a channel to a constant value (if possible)
bool set_constant_value(k3d::iunknown& Channel, const k3d::vector3 Value);

/// Sets a channel to a linear range of values (if possible)
bool set_linear_value(k3d::iunknown& Channel, const double X1, const double Value1, const double X2, const double Value2);
/// Sets a channel to a linear range of values (if possible)
bool set_linear_value(k3d::iunknown& Channel, const double X1, const k3d::vector3 Value1, const double X2, const k3d::vector3 Value2);
*/

} // namespace channel

} // namespace k3d

#endif // !K3DSDK_CHANNEL_H


