package Juman::Sexp;
require 5.004_04; # For base pragma.
use Carp;
use IO::File;
use strict;
use base qw/ Exporter /;
use vars qw/ @EXPORT_OK /;
@EXPORT_OK = qw/ parse /;

=head1 NAME

Juman::Sexp - Sɤ߹⥸塼

=head1 SYNOPSIS

 use Data::Dumper;
 use Juman::Sexp qw/ parse /;
 print &Dumper( &parse( file => "Noun.dic" ) );

=head1 DESCRIPTION

C<Juman::Sexp> ϡJuman եѤƤSɤ߹
िδؿ C<parse> Ƥ롥

=head1 FUNCTIONS

=over 4

=item parse

ꤵ줿оݤSȤƲϤؿʲΥץդ롥

=over 4

=item file => FILE

Ϥեꤹ롥

=item string => STRING

Ϥʸꤹ롥

=item comment => STRING

ȳʸꤹ롥ȤޤäޤޤʤоݤϤ
ϡʲΤ褦̤ͤꤹ롥

  Example:

    &parse( file => "example.dat", comment => undef );

=item debug => BOOLEAN

ǥХåѤξϤ褦˻ؼ롥

=back

=back

㤨СʸоݤȤƲϤϡʲΤ褦˻ꤹ롥

  Example:

    &parse( string =>
            "(̾ (̾ ((ɤ )(Ф   ))))" );

ξ硤Τ褦ʲϷ̤֤롥

    ( [ '̾',
         [ '̾',
           [ [ 'ɤ', '' ],
             [ 'Ф', '', '', '' ]
           ]
         ]
       ] )

=cut
sub parse {
    my %option;
    $option{comment} = ";";
    while( @_ ){
	my $key = shift;
	my $val = shift;
	$key =~ s/\A-+//;
	$option{lc($key)} = $val;
    }
    if( $option{file} ){
	my $file = $option{file};
	if( my $fh = IO::File->new( $file, "r" ) ){
	    my $num = 0;
	    &_parse( sub { if( $fh->eof ){ undef; } else { $num++; $fh->getline; } },
		     sub { "at $file line $num"; },
		     $option{comment},
		     $option{debug} );
	} else {
	    warn "Cannot open $file: $!\n";
	    wantarray ? () : 0;
	}
    } elsif( $option{string} ){
	my $string = $option{string};
	&_parse( sub { my $x = $string; $string = undef; $x; },
		 sub { "in string"; },
		 $option{comment},
		 $option{debug} );
    } else {
	carp "Neither `file' option nor `string' option is specified";
	wantarray ? () : 0;
    }
}

sub _parse {
    my( $getline, $place, $comment, $debug ) = @_;
    my $str = "";
    my @stack;		# shift-reduce ˡǹʸϤ뤿Υå 
    my @offset;		# reduce ٤ǿϿƤ
    while(1){
	$str =~ s/\A\s*//;
	$str =~ s/\A$comment[^\n]*\n\s*// if $comment;
	if( ! $str ){
	    if( $str = &$getline() ){
		print STDERR "PARSE: $str" if $debug;
	    } else {
		if( @offset ){
		    die "Syntax error: end of target during parsing.\n";
		} else {
		    last;
		}
	    }
	}
	# ̤ shift 
	elsif( $str =~ s/\A\(// ){
	    $offset[0]-- if @offset;
	    unshift( @offset, 0 );
	}
	# ʸ shift 
	elsif( $str =~ m/\A"/ ){
	    while(1){
		if( $str =~ s/\A("(?:[^"\\]+|\\.)*")// ){
		    $offset[0]--;
		    push( @stack, $1 );
		    last;
		} elsif( my $next = &$getline() ){
		    $str .= $next;
		} else {
		    die "Syntax error: end of target during string.\n";
		}
	    }
	}
	# ܥ shift 
	elsif( $str =~ s/\A([^\s"()]+)// ){
	    $offset[0]--;
	    push( @stack, $1 );
	}
	# ĳ(= ꥹ) reduce 
	elsif( $str =~ s/\A\)// ){
	    unless( @offset ){
		die( "Syntax error: too much close brackets ", &$place(), ".\n" );
	    } else {
		my $offset = shift @offset;
		if( $offset < 0 ){
		    push( @stack, [ splice( @stack, $offset ) ] );
		} else {
		    push( @stack, [] );
		}
	    }
	}
	else {
	    die( "Syntax error: unknown syntax element ", &$place(), ".\n" );
	}
    }
    @stack;
}

1;

=head1 AUTHOR

=over 4

=item
TSUCHIYA Masatoshi <tsuchiya@pine.kuee.kyoto-u.ac.jp>

=back

=head1 COPYRIGHT

ѵڤӺۤˤĤƤ GPL2 ޤ Artistic License ˽äƤ

=cut

__END__
# Local Variables:
# mode: perl
# coding: euc-japan
# use-kuten-for-period: nil
# use-touten-for-comma: nil
# End:
