
/*
 * playlist.C -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef PLAYLIST_C
#define PLAYLIST_C

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "dialogs/typedefs.h"
#include "dialogs/windows.h"
#include "dialogs/vfs.h"
#include "dialogs/dialogs.h"
#include "dialogs/utils.h"

#include "player/child.h"

#include "mpg123/mpg123.h"
#include "mpg123/describe.h"
#include "mpg123/id3.h"

#include "typedefs.h"
#include "playlist.h"

#ifdef DEBUG
extern void fatal_error (const char *msg, ...);
#endif

/*
 * class Selection
 */

Selection::Selection ()
{
   selected = NULL;
   nselected = 0;
}

void Selection::CreateTracks (int ntracks)
{
   nselected = ntracks;
   selected = (bool *) realloc (selected,nselected * sizeof (bool));
   for (int i = 0; i < nselected; i++) selected[i] = FALSE;
}

void Selection::DestroyTracks ()
{
   if (selected != NULL)
	 {
		free (selected);
		selected = NULL;
		nselected = 0;
	 }
}

void Selection::SelectTrack (int trackno)
{
   selected[trackno] = TRUE;
}

void Selection::SelectAllTracks ()
{
   for (int i = 0; i < nselected; i++) selected[i] = TRUE;
}

void Selection::DeselectTrack (int trackno)
{
   selected[trackno] = FALSE;
}

void Selection::DeselectAllTracks ()
{
   for (int i = 0; i < nselected; i++) selected[i] = FALSE;
}

void Selection::InvertTrack (int trackno)
{
   selected[trackno] = selected[trackno] ? FALSE : TRUE;
}

void Selection::InvertAllTracks ()
{
   for (int i = 0; i < nselected; i++) selected[i] = selected[i] ? FALSE : TRUE;
}

bool Selection::SelectedTrack (int trackno)
{
   return selected[trackno];
}

int Selection::NumSelectedTracks ()
{
   int result = 0;
   for (int i = 0; i < nselected; i++) if (selected[i]) result++;
   return result;
}

/*
 * class Playlist
 */

Playlist::Playlist ()
{
   browsefirst = TRUE;
}

void Playlist::Edit ()
{
   WINDOW *curwin;
   PANEL *curpan;
   chtype ch;
   bool top = FALSE,finished = FALSE,search = FALSE;
   char txt[70];
#if 0
   char searchstr[65];
#endif
   int i,j,k,topchoice = 0,tactive = 0,bactive = 1;
   curtrack = -1;	/* No files currently playing */
   Add (70,19,(COLS - 70) >> 1,(LINES - 19) >> 1,"Track list",A_BOLD,WHITE,BLUE);
   disableframes ();
   curwin = GetWindow ();
   curpan = GetPanel ();
   horzline (curpan,0,71,18,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
   vertline (curpan,18,18,20,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
   vertline (curpan,36,18,20,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
   vertline (curpan,54,18,20,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
   CreateTracks (tracks.NumEntries ());
   if (tracks.NumEntries () > 15) scrollframe (curpan,FALSE,TRUE,FRAME_FILEDIR);
   txt[66] = '\0';
   keypad (curwin,TRUE);
   do
	 {
		if (mpg123frontend)
		  {
			 if (mpg123_poll_status.playstat == 4) curtrack = -1;
		  }
		else
		  {
			 if (!child_alive ()) curtrack = -1;
		  }
#if 0
/* FIN */
/*
 * Highlight searchstr op onderste bar. By Ishotkey (ch), sal frame verander moet word.
 */
/* FIN */
		if (search)
		  {
			 horzline (curpan,0,71,18,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 horzline (curpan,0,71,20,FALSE,TRUE,SIDE_TUP,SIDE_TUP);
		  }
		else
		  {
#endif
			 if ((!top) && (bactive == 1)) setcolor (curwin,GREEN,GREEN,A_BOLD); else setcolor (curwin,WHITE,BLUE,A_BOLD);
			 mvwaddstr (curwin,19,5," Browse ");
			 if ((!top) && (bactive == 2)) setcolor (curwin,GREEN,GREEN,A_BOLD); else setcolor (curwin,WHITE,BLUE,A_BOLD);
			 mvwaddstr (curwin,19,22," Rearrange ");
			 if ((!top) && (bactive == 3)) setcolor (curwin,GREEN,GREEN,A_BOLD); else setcolor (curwin,WHITE,BLUE,A_BOLD);
			 mvwaddstr (curwin,19,41," Shuffle ");
			 if ((!top) && (bactive == 4)) setcolor (curwin,GREEN,GREEN,A_BOLD); else setcolor (curwin,WHITE,BLUE,A_BOLD);
			 mvwaddstr (curwin,19,57," Playlists ");
#if 0
		  }
#endif
		k = topchoice + 15;
		if (tracks.NumEntries () < k) k = tracks.NumEntries ();
		setcolor (curwin,WHITE,BLUE,A_BOLD);
        for (i = 0; i < 66; i++) txt[i] = ' ';
		for (i = 2; i < 17; i++) mvwaddstr (curwin,i,2,txt);
		for (i = topchoice; i < k; i++)
		  {
			 sprintf (txt,"%d. ",i + 1);
			 strcat (txt,tracks.EntryName (i));
			 for (j = strlen (txt); j < 66; j++) txt[j] = ' ';
			 if ((i == tactive) && top)
			   {
				  if (SelectedTrack (i)) setcolor (curwin,YELLOW,GREEN,A_BOLD); else setcolor (curwin,GREEN,GREEN,A_BOLD);
			   }
			 else
			   {
				  if (SelectedTrack (i)) setcolor (curwin,YELLOW,BLUE,A_BOLD); else setcolor (curwin,WHITE,BLUE,A_BOLD);
			   }
			 mvwaddstr (curwin,i - topchoice + 2,2,txt);
		  }
		setcolor (curwin,WHITE,BLUE,A_BOLD);
		if (tracks.NumEntries () > 15)
		  scrollbutton (curpan,tactive,tracks.NumEntries (),TRUE,FRAME_FILEDIR);
		Update ();
		ch = wgetch (curwin);
		if (tracks.NumEntries () > 15)
		  scrollbutton (curpan,tactive,tracks.NumEntries (),FALSE,FRAME_FILEDIR);
		if (IsHotkey (ch))
		  {
			 bool visible;
			 flushinp ();
			 singleframe (curpan);
			 showtitle (curpan,"Track list");
			 horzline (curpan,0,71,18,TRUE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 vertline (curpan,18,18,20,TRUE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 vertline (curpan,36,18,20,TRUE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 vertline (curpan,54,18,20,TRUE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 visible = tracks.NumEntries () > 15;
			 scrollframe (curpan,TRUE,visible,FRAME_FILEDIR);
			 execfunc (ch);
			 doubleframe (curpan);
			 showtitle (curpan,"Track list");
			 horzline (curpan,0,71,18,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 vertline (curpan,18,18,20,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 vertline (curpan,36,18,20,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 vertline (curpan,54,18,20,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 scrollframe (curpan,FALSE,visible,FRAME_FILEDIR);
			 finished = abortflag;
		  }
		else if (ch == XCTRL ('l'))
		  {
			 Refresh ();
		  }
		else if (ch == '\t')
		  {
			 if ((!top) && (tracks.NumEntries () == 0)) beep (); else top = (!top);
			 search = FALSE;
		  }
		else if (ch == KEY_UP)
		  {
			 if (!top) beep (); else
			   {
				  if (tactive == 0) beep (); else
					{
					   if (tactive > topchoice) tactive--; else
						 {
							tactive--;
							topchoice--;
						 }
					}
			   }
			 search = FALSE;
		  }
		else if (ch == KEY_DOWN)
		  {
			 if (!top) beep (); else
			   {
				  if (tactive == tracks.NumEntries () - 1) beep (); else
					{
					   if (tactive < k - 1) tactive++; else
						 {
							tactive++;
							topchoice++;
						 }
					}
			   }
			 search = FALSE;
		  }
#if 0
		else if ((!search) && ((ch == XCTRL ('s')) || (ch == ALT ('s'))))
		  {
			 search = TRUE;
			 *searchstr = '\0';
		  }
		else if (search && (isalnum (ch) || ispunct (ch)))
		  {
			 int i = tracks.NumEntries () - 1;
			 if (strlen (searchstr) < sizeof (searchstr) - 1)
			   {
				  if (ch == '\b') searchstr[strlen (searchstr) - 1] = '\0'; else
					{
					   searchstr[strlen (searchstr)] = ch;
					   searchstr[strlen (searchstr) + 1] = '\0';
					}
				  while ((i > 0) && (strncmp (searchstr,tracks.EntryName (i),strlen (searchstr)) < 0)) i--;
				  tactive = i;
				  if (topchoice < tactive - 14) topchoice = tactive - 14;
			   }
			 else beep ();
		  }
#endif
		else if (ch == KEY_HOME)
		  {
			 if (!top) beep (); else topchoice = tactive = 0;
			 search = FALSE;
		  }
		else if (ch == KEY_END)
		  {
			 if (!top) beep (); else
			   {
				  tactive = tracks.NumEntries () - 1;
				  topchoice = tactive - 14;
				  if (topchoice < 0) topchoice = 0;
			   }
			 search = FALSE;
		  }
		else if (ch == KEY_NPAGE)       /* Page Down */
		  {
			 if (!top) beep (); else
			   {
				  if (tactive == tracks.NumEntries () - 1) beep (); else
					{
					   if (tactive < tracks.NumEntries () - 16)
						 {
							topchoice += 15;
							tactive += 15;
							while (topchoice > tracks.NumEntries () - 16)
							  {
								 topchoice--;
								 tactive--;
							  }
						 }
					   else
						 {
							tactive = tracks.NumEntries () - 1;
							topchoice = tactive - 14;
							if (topchoice < 0) topchoice = 0;
						 }
					}
			   }
			 search = FALSE;
		  }
		else if (ch == KEY_PPAGE)       /* Page Up */
		  {
			 if (!top) beep (); else
			   {
				  if (tactive == 0) beep (); else
					{
					   if (tactive > 14)
						 {
							tactive -= 15;
							topchoice -= 15;
							if (topchoice < 0) topchoice = 0;
						 }
					   else tactive = topchoice = 0;
					}
			   }
			 search = FALSE;
		  }
		else if (ch == KEY_LEFT)
		  {
			 if (top || (bactive == 1)) beep (); else bactive--;
			 search = FALSE;
		  }
		else if (ch == KEY_RIGHT)
		  {
			 if (top || (bactive == 4)) beep (); else bactive++;
			 search = FALSE;
		  }
		else if (ch == '\n')
		  {
			 bool visible;
			 flushinp ();
			 singleframe (curpan);
			 showtitle (curpan,"Track list");
			 horzline (curpan,0,71,18,TRUE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 vertline (curpan,18,18,20,TRUE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 vertline (curpan,36,18,20,TRUE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 vertline (curpan,54,18,20,TRUE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 visible = tracks.NumEntries () > 15;
			 scrollframe (curpan,TRUE,visible,FRAME_FILEDIR);
			 if (top)
			   {
				  if (NumSelectedTracks ())
					{
					   (playselected_function)();
					   DeselectAllTracks ();
					}
				  else
					{
					   curtrack = tactive;
					   (playtrack_function)();
					}
			   }
			 else
			   {
				  switch (bactive)
					{
					 case 1:
					   DestroyTracks ();
					   (browse_wrapper)();
					   CreateTracks (tracks.NumEntries ());
					   break;
					 case 2:
					   (rearrange_wrapper)();
					   break;
					 case 3:
					   (shuffle_wrapper)();
					   break;
					 case 4:
					   DestroyTracks ();
					   (playlists_wrapper)();
					   CreateTracks (tracks.NumEntries ());
					   break;
					 default:
					   /* This shouldn't happen */
					   break;
					}
				  tactive = topchoice = 0;
				  DeselectAllTracks ();
			   }
			 doubleframe (curpan);
			 showtitle (curpan,"Track list");
			 horzline (curpan,0,71,18,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 vertline (curpan,18,18,20,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 vertline (curpan,36,18,20,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 vertline (curpan,54,18,20,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 visible = tracks.NumEntries () > 15;
			 scrollframe (curpan,FALSE,visible,FRAME_FILEDIR);
			 finished = abortflag;
			 search = FALSE;
		  }
		else if (ch == XCTRL ('o'))
		  {
			 if (mpg123frontend)
			   {
				  /*if (mpg123_poll_status.playstat == 4) */(switchmode_function)();
			   }
			 else
			   {
				  if (child_alive ()) (switchmode_function)();
			   }
			 search = FALSE;
		  }
		else if (ch == KEY_IC)	/* Insert */
		  {
			 if (!top) beep (); else
			   {
				  InvertTrack (tactive);
				  if (tactive < tracks.NumEntries () - 1)
					{
					   if (tactive < k - 1) tactive++; else
						 {
							tactive++;
							topchoice++;
						 }
					}
			   }
			 search = FALSE;
		  }
		else beep ();
		flushinp ();
	 }
   while (!finished);
   keypad (curwin,FALSE);
   tracks.RemoveEntries ();
   Remove ();
   Update ();
}

void Playlist::Browse ()
{
   WINDOW *curwin;
   PANEL *curpan;
   chtype ch;
   VirtualFS list;
   EntryRec entry;
   bool left = TRUE,finished = FALSE,result1,result2;
   int i,j,lk,rk,l;
   int ltopchoice = 0,lactive = 0,rtopchoice = 0,ractive = 0,lbactive = 1,rbactive = 1;
   char line[70],*tmp,tmp2[256];
   song_t song;
   id3_t id3;
   Add (70,19,(COLS - 70) >> 1,(LINES - 19) >> 1,"",A_BOLD,WHITE,BLUE);
   disableframes ();
   curwin = GetWindow ();
   curpan = GetPanel ();
   doubleframe (curpan);
   horzline (curpan,0,71,16,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
   horzline (curpan,0,71,18,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
   vertline (curpan,24,18,20,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
   vertline (curpan,48,18,20,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
   vertline (curpan,36,0,16,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
   if (browsefirst)
	 {
		browsefirst = FALSE;
		strcpy (lastdir,audiopath);
	 }
   list.CreateFileListing (lastdir,audiotype,60);
   list.SortEntries (SORT_EXT);
   for (i = 0; i < list.NumEntries (); i++)
	 {
		if (list.EntryType (i) == FT_FILE)
		  {
			 result1 = describe (&song,list.EntryFilename (i)) && (strlen (song.title) > 0);
			 result2 = getid3 (&id3,list.EntryFilename (i)) && (strlen (id3.title) > 0);
			 if ((result1 && ((displaymode == 1) || (displaymode == 3))) || (result1 && (!result2) && (displaymode == 4)))
			   {
				  strcpy (tmp2,song.title);
				  switch (displayformat)
					{
					 case 0:
					   if (strlen (song.artist) > 0)
						 {
							strcat (tmp2," - ");
							strcat (tmp2,song.artist);
						 }
					   if (strlen (song.album) > 0)
						 {
							strcat (tmp2," (");
							strcat (tmp2,song.album);
							strcat (tmp2,")");
						 }
					   break;
					 case 1:
					   if (strlen (song.artist) > 0)
						 {
							strcat (tmp2," - ");
							strcat (tmp2,song.artist);
						 }
					   break;
					 case 2:
					   if (strlen (song.album) > 0)
						 {
							strcat (tmp2," (");
							strcat (tmp2,song.album);
							strcat (tmp2,")");
						 }
					   break;
					 case 3:
					   break;
					}
				  entry.filename = list.EntryFilename (i);
				  list.shortenmethod = shortenmethod == 0 ? METHOD_SPLIT : METHOD_TRUNCATE;
				  list.shortname (&entry.name,tmp2,60);
				  entry.type = FT_FILE;
				  list.ChangeEntry (i,&entry);
				  free (entry.name);
			   }
			 if ((result2 && ((displaymode == 2) || (displaymode == 4))) || (result2 && (!result1) && (displaymode == 3)))
			   {
				  strcpy (tmp2,id3.title);
				  switch (displayformat)
					{
					 case 0:
					   if (strlen (id3.artist) > 0)
						 {
							strcat (tmp2," - ");
							strcat (tmp2,id3.artist);
						 }
					   if (strlen (id3.album) > 0)
						 {
							strcat (tmp2," (");
							strcat (tmp2,id3.album);
							strcat (tmp2,")");
						 }
					   break;
					 case 1:
					   if (strlen (id3.artist) > 0)
						 {
							strcat (tmp2," - ");
							strcat (tmp2,id3.artist);
						 }
					   break;
					 case 2:
					   if (strlen (id3.album) > 0)
						 {
							strcat (tmp2," (");
							strcat (tmp2,id3.album);
							strcat (tmp2,")");
						 }
					   break;
					 case 3:
					   break;
					}
				  entry.filename = list.EntryFilename (i);
				  list.shortenmethod = shortenmethod == 0 ? METHOD_SPLIT : METHOD_TRUNCATE;
				  list.shortname (&entry.name,tmp2,60);
				  entry.type = FT_FILE;
				  list.ChangeEntry (i,&entry);
				  free (entry.name);
			   }
		  }
	 }
   setcolor (curwin,WHITE,BLUE,A_BOLD);
   if (list.NumEntries () > 13) scrollframe (curpan,FALSE,TRUE,FRAME_MIDDLE);
   if (tracks.NumEntries () > 13) scrollframe (curpan,FALSE,TRUE,FRAME_SAVE);
   keypad (curwin,TRUE);
   do
	 {
		setcolor (curwin,WHITE,BLUE,A_BOLD);
		mvwaddstr (curwin,19,7,"         ");
		mvwaddstr (curwin,19,30,"            ");
		mvwaddstr (curwin,19,55,"          ");
		if (left)
		  {
			 if (lbactive == 1) setcolor (curwin,GREEN,GREEN,A_BOLD); else setcolor (curwin,WHITE,BLUE,A_BOLD);
			 mvwaddstr (curwin,19,10," Add ");
			 if (lbactive == 2) setcolor (curwin,GREEN,GREEN,A_BOLD); else setcolor (curwin,WHITE,BLUE,A_BOLD);
			 mvwaddstr (curwin,19,32," Add All ");
			 if (lbactive == 3) setcolor (curwin,GREEN,GREEN,A_BOLD); else setcolor (curwin,WHITE,BLUE,A_BOLD);
			 mvwaddstr (curwin,19,55," Finished ");
		  }
		else
		  {
			 if (rbactive == 1) setcolor (curwin,GREEN,GREEN,A_BOLD); else setcolor (curwin,WHITE,BLUE,A_BOLD);
			 mvwaddstr (curwin,19,8," Remove ");
			 if (rbactive == 2) setcolor (curwin,GREEN,GREEN,A_BOLD); else setcolor (curwin,WHITE,BLUE,A_BOLD);
			 mvwaddstr (curwin,19,30," Remove All ");
			 if (rbactive == 3) setcolor (curwin,GREEN,GREEN,A_BOLD); else setcolor (curwin,WHITE,BLUE,A_BOLD);
			 mvwaddstr (curwin,19,55," Finished ");
		  }
		lk = ltopchoice + 13;
		rk = rtopchoice + 13;
		if (list.NumEntries () < lk) lk = list.NumEntries ();
		if (tracks.NumEntries () < rk) rk = tracks.NumEntries ();
		setcolor (curwin,WHITE,BLUE,A_BOLD);
		if (left)
		  {
			 strcpy (line,list.EntryName (lactive));
			 if (list.EntryType (lactive) == FT_DIR) strcat (line,"/"); else wattroff (curwin,/*A_NORMAL*/A_BOLD);
		  }
		else strcpy (line,tracks.EntryName (ractive));
		for (i = strlen (line); i < 68; i++) mvwaddch (curwin,17,i,' ');
		mvwaddstr (curwin,17,2,line);
		setcolor (curwin,WHITE,BLUE,A_BOLD);
		line[31] = '\0';
		for (i = 0; i < 31; i++) line[i] = ' ';
		for (i = 2; i < 15; i++)
		  {
			 mvwaddstr (curwin,i,2,line);
			 mvwaddstr (curwin,i,38,line);
		  }
		for (i = ltopchoice; i < lk; i++)
		  {
			 list.shortenmethod = shortenmethod == 0 ? METHOD_SPLIT : METHOD_TRUNCATE;
			 list.shortname (&tmp,list.EntryName (i),29);
			 strcpy (line,tmp);
			 free (tmp);
			 if (list.EntryType (i) == FT_DIR) strcat (line,"/");
			 for (j = strlen (line); j < 31; j++) line[j] = ' ';
			 line[31] = '\0';
			 if ((i == lactive) && left) setcolor (curwin,GREEN,GREEN,A_BOLD); else
			   {
				  setcolor (curwin,WHITE,BLUE,A_BOLD);
				  if (list.EntryType (i) == FT_FILE) wattroff (curwin,/*A_NORMAL*/A_BOLD);
			   }
			 mvwaddstr (curwin,i - ltopchoice + 2,2,line);
			 wattron (curwin,A_BOLD);
		  }
		for (i = rtopchoice; i < rk; i++)
		  {
			 tracks.shortenmethod = shortenmethod == 0 ? METHOD_SPLIT : METHOD_TRUNCATE;
			 tracks.shortname (&tmp,tracks.EntryName (i),29);
			 strcpy (line,tmp);
			 free (tmp);
			 for (j = strlen (line); j < 31; j++) line[j] = ' ';
			 line[31] = '\0';
			 if ((i == ractive) && (!left)) setcolor (curwin,GREEN,GREEN,A_BOLD); else setcolor (curwin,WHITE,BLUE,A_BOLD);
			 mvwaddstr (curwin,i - rtopchoice + 2,38,line);
		  }
		if (list.NumEntries () > 13)
		  scrollbutton (curpan,lactive,list.NumEntries (),TRUE,FRAME_MIDDLE);
		if (tracks.NumEntries () > 13)
		  scrollbutton (curpan,ractive,tracks.NumEntries (),TRUE,FRAME_SAVE);
		Update ();
		ch = wgetch (curwin);
		if (list.NumEntries () > 13)
		  scrollbutton (curpan,lactive,list.NumEntries (),FALSE,FRAME_MIDDLE);
		if (tracks.NumEntries () > 13)
		  scrollbutton (curpan,ractive,tracks.NumEntries (),FALSE,FRAME_SAVE);
		if (IsHotkey (ch))
		  {
			 bool lvisible,rvisible;
			 flushinp ();
			 singleframe (curpan);
             horzline (curpan,0,71,16,TRUE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 horzline (curpan,0,71,18,TRUE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 vertline (curpan,24,18,20,TRUE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 vertline (curpan,48,18,20,TRUE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 vertline (curpan,36,0,16,TRUE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 lvisible = list.NumEntries () > 13;
			 rvisible = tracks.NumEntries () > 13;
			 setcolor (curwin,WHITE,BLUE,A_BOLD);
			 scrollframe (curpan,TRUE,lvisible,FRAME_MIDDLE);
			 scrollframe (curpan,TRUE,rvisible,FRAME_SAVE);
			 execfunc (ch);
			 doubleframe (curpan);
             horzline (curpan,0,71,16,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 horzline (curpan,0,71,18,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 vertline (curpan,24,18,20,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 vertline (curpan,48,18,20,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 vertline (curpan,36,0,16,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 lvisible = list.NumEntries () > 13;
			 rvisible = tracks.NumEntries () > 13;
			 setcolor (curwin,WHITE,BLUE,A_BOLD);
			 scrollframe (curpan,FALSE,lvisible,FRAME_MIDDLE);
			 scrollframe (curpan,FALSE,rvisible,FRAME_SAVE);
			 finished = abortflag;
		  }
		else if (ch == XCTRL ('l'))
		  {
			 Refresh ();
		  }
		else if (ch == '\t')
		  {
			 if (left && (tracks.NumEntries () == 0)) beep (); else left = (!left);
		  }
		else if (ch == KEY_UP)
		  {
			 if (left)
			   {
				  if (lactive == 0) beep (); else
					{
					   if (lactive > ltopchoice) lactive--; else
						 {
							lactive--;
							ltopchoice--;
						 }
					}
			   }
			 else
			   {
				  if (ractive == 0) beep (); else
					{
					   if (ractive > rtopchoice) ractive--; else
						 {
							ractive--;
							rtopchoice--;
						 }
					}
			   }
		  }
		else if (ch == KEY_DOWN)
		  {
			 if (left)
			   {
				  if (lactive == list.NumEntries () - 1) beep (); else
					{
					   if (lactive < lk - 1) lactive++; else
						 {
							lactive++;
							ltopchoice++;
						 }
					}
			   }
			 else
			   {
                  if (ractive == tracks.NumEntries () - 1) beep (); else
					{
					   if (ractive < rk - 1) ractive++; else
						 {
							ractive++;
							rtopchoice++;
						 }
					}
			   }
		  }
		else if (ch == KEY_HOME)
		  {
			 if (left)
			   {
				  if (lactive == 0) beep (); else lactive = ltopchoice = 0;
			   }
			 else
			   {
				  if (ractive == 0) beep (); else ractive = rtopchoice = 0;
			   }
		  }
		else if (ch == KEY_END)
		  {
			 if (left)
			   {
				  if (lactive == list.NumEntries () - 1) beep (); else
					{
					   lactive = list.NumEntries () - 1;
					   ltopchoice = lactive - 12;
					   if (ltopchoice < 0) ltopchoice = 0;
					}
			   }
			 else
			   {
				  if (ractive == tracks.NumEntries () - 1) beep (); else
					{
					   ractive = tracks.NumEntries () - 1;
					   rtopchoice = ractive - 12;
					   if (rtopchoice < 0) rtopchoice = 0;
					}
			   }
		  }
		else if (ch == KEY_NPAGE)	/* PGDN */
		  {
			 if (left)
			   {
				  if (lactive == list.NumEntries () - 1) beep (); else
					{
					   if (lactive < list.NumEntries () - 14)
						 {
							ltopchoice += 13;
							lactive += 13;
							while (ltopchoice > list.NumEntries () - 14)
							  {
								 ltopchoice--;
								 lactive--;
							  }
						 }
					   else
						 {
							lactive = list.NumEntries () - 1;
							ltopchoice = lactive - 12;
							if (ltopchoice < 0) ltopchoice = 0;
						 }
					}
			   }
			 else
			   {
				  if (ractive == tracks.NumEntries () - 1) beep (); else
					{
					   if (ractive < tracks.NumEntries () - 14)
						 {
							rtopchoice += 13;
							ractive += 13;
							while (rtopchoice > tracks.NumEntries () - 14)
							  {
								 rtopchoice--;
								 ractive--;
							  }
						 }
					   else
						 {
							ractive = tracks.NumEntries () - 1;
							rtopchoice = ractive - 12;
							if (rtopchoice < 0) rtopchoice = 0;
						 }
					}
			   }
		  }
		else if (ch == KEY_PPAGE)	/* PGUP */
		  {
			 if (left)
			   {
                  if (lactive == 0) beep (); else
					{
					   if (lactive > 12)
						 {
							lactive -= 13;
							ltopchoice -= 13;
							if (ltopchoice < 0) ltopchoice = 0;
						 }
					   else lactive = ltopchoice = 0;
					}
			   }
			 else
			   {
                  if (ractive == 0) beep (); else
					{
					   if (ractive > 12)
						 {
							ractive -= 13;
							rtopchoice -= 13;
							if (rtopchoice < 0) rtopchoice = 0;
						 }
					   else ractive = rtopchoice = 0;
					}
			   }
		  }
		else if (ch == KEY_LEFT)
		  {
			 if (left)
			   {
				  if (lbactive == 1) beep (); else lbactive--;
			   }
			 else
			   {
				  if (rbactive == 1) beep (); else rbactive--;
			   }
		  }
		else if (ch == KEY_RIGHT)
		  {
			 if (left)
			   {
				  if (lbactive == 3) beep (); else lbactive++;
			   }
			 else
			   {
				  if (rbactive == 3) beep (); else rbactive++;
			   }
		  }
		else if (ch == '\n')
		  {
             if (left)
			   {
				  bool visible;
				  switch (lbactive)
					{
					 case 1:
					   if (list.EntryType (lactive) == FT_FILE)
						 {
							entry.filename = list.EntryFilename (lactive);
							entry.name = list.EntryName (lactive);
							entry.type = list.EntryType (lactive);
							tracks.AddEntry (&entry);
							visible = tracks.NumEntries () > 13;
							setcolor (curwin,WHITE,BLUE,A_BOLD);
							scrollframe (curpan,FALSE,visible,FRAME_SAVE);
						 }
					   else
						 {
							strcpy (lastdir,list.EntryFilename (lactive));
							list.RemoveEntries ();
							canonicalize_pathname (lastdir,PATH_MAX);
							list.CreateFileListing (lastdir,audiotype,60);
							list.SortEntries (SORT_EXT);
							for (i = 0; i < list.NumEntries (); i++)
							  {
								 if (list.EntryType (i) == FT_FILE)
								   {
									  result1 = describe (&song,list.EntryFilename (i)) && (strlen (song.title) > 0);
									  result2 = getid3 (&id3,list.EntryFilename (i)) && (strlen (id3.title) > 0);
									  if ((result1 && ((displaymode == 1) || (displaymode == 3))) || (result1 && (!result2) && (displaymode == 4)))
										{
										   strcpy (tmp2,song.title);
										   switch (displayformat)
											 {
											  case 0:
												if (strlen (song.artist) > 0)
												  {
													 strcat (tmp2," - ");
													 strcat (tmp2,song.artist);
												  }
												if (strlen (song.album) > 0)
												  {
													 strcat (tmp2," (");
													 strcat (tmp2,song.album);
													 strcat (tmp2,")");
												  }
												break;
											  case 1:
												if (strlen (song.artist) > 0)
												  {
													 strcat (tmp2," - ");
													 strcat (tmp2,song.artist);
												  }
												break;
											  case 2:
												if (strlen (song.album) > 0)
												  {
													 strcat (tmp2," (");
													 strcat (tmp2,song.album);
													 strcat (tmp2,")");
												  }
												break;
											  case 3:
												break;
											 }
										   entry.filename = list.EntryFilename (i);
										   list.shortenmethod = shortenmethod == 0 ? METHOD_SPLIT : METHOD_TRUNCATE;
										   list.shortname (&entry.name,tmp2,60);
										   entry.type = FT_FILE;
										   list.ChangeEntry (i,&entry);
										   free (entry.name);
										}
									  if ((result2 && ((displaymode == 2) || (displaymode == 4))) || (result2 && (!result1) && (displaymode == 3)))
										{
										   strcpy (tmp2,id3.title);
										   switch (displayformat)
											 {
											  case 0:
												if (strlen (id3.artist) > 0)
												  {
													 strcat (tmp2," - ");
													 strcat (tmp2,id3.artist);
												  }
												if (strlen (id3.album) > 0)
												  {
													 strcat (tmp2," (");
													 strcat (tmp2,id3.album);
													 strcat (tmp2,")");
												  }
												break;
											  case 1:
												if (strlen (id3.artist) > 0)
												  {
													 strcat (tmp2," - ");
													 strcat (tmp2,id3.artist);
												  }
												break;
											  case 2:
												if (strlen (id3.album) > 0)
												  {
													 strcat (tmp2," (");
													 strcat (tmp2,id3.album);
													 strcat (tmp2,")");
												  }
												break;
											  case 3:
												break;
											 }
										   entry.filename = list.EntryFilename (i);
										   list.shortenmethod = shortenmethod == 0 ? METHOD_SPLIT : METHOD_TRUNCATE;
										   list.shortname (&entry.name,tmp2,60);
										   entry.type = FT_FILE;
										   list.ChangeEntry (i,&entry);
										   free (entry.name);
										}
								   }
							  }
							setcolor (curwin,WHITE,BLUE,A_BOLD);
							visible = list.NumEntries () > 13;
							setcolor (curwin,WHITE,BLUE,A_BOLD);
							scrollframe (curpan,FALSE,visible,FRAME_MIDDLE);
							ltopchoice = lactive = 0;
						 }
					   break;
                     case 2:
					   if (list.EntryType (lactive) == FT_FILE)
						 {
							for (l = 0; l < list.NumEntries (); l++) if (list.EntryType (l) == FT_FILE)
							  {
								 entry.filename = list.EntryFilename (l);
								 entry.name = list.EntryName (l);
								 entry.type = list.EntryType (l);
								 tracks.AddEntry (&entry);
							  }
							visible = tracks.NumEntries () > 13;
							setcolor (curwin,WHITE,BLUE,A_BOLD);
							scrollframe (curpan,FALSE,visible,FRAME_SAVE);
						 }
					   else
						 {
							strcpy (lastdir,list.EntryFilename (lactive));
							list.RemoveEntries ();
							canonicalize_pathname (lastdir,PATH_MAX);
							list.CreateFileListing (lastdir,audiotype,60);
							list.SortEntries (SORT_EXT);
							for (i = 0; i < list.NumEntries (); i++)
							  {
								 if (list.EntryType (i) == FT_FILE)
								   {
									  result1 = describe (&song,list.EntryFilename (i)) && (strlen (song.title) > 0);
									  result2 = getid3 (&id3,list.EntryFilename (i)) && (strlen (id3.title) > 0);
									  if ((result1 && ((displaymode == 1) || (displaymode == 3))) || (result1 && (!result2) && (displaymode == 4)))
										{
										   strcpy (tmp2,song.title);
										   switch (displayformat)
											 {
											  case 0:
												if (strlen (song.artist) > 0)
												  {
													 strcat (tmp2," - ");
													 strcat (tmp2,song.artist);
												  }
												if (strlen (song.album) > 0)
												  {
													 strcat (tmp2," (");
													 strcat (tmp2,song.album);
													 strcat (tmp2,")");
												  }
												break;
											  case 1:
												if (strlen (song.artist) > 0)
												  {
													 strcat (tmp2," - ");
													 strcat (tmp2,song.artist);
												  }
												break;
											  case 2:
												if (strlen (song.album) > 0)
												  {
													 strcat (tmp2," (");
													 strcat (tmp2,song.album);
													 strcat (tmp2,")");
												  }
												break;
											  case 3:
												break;
											 }
										   entry.filename = list.EntryFilename (i);
										   list.shortenmethod = shortenmethod == 0 ? METHOD_SPLIT : METHOD_TRUNCATE;
										   list.shortname (&entry.name,tmp2,60);
										   entry.type = FT_FILE;
										   list.ChangeEntry (i,&entry);
										   free (entry.name);
										}
									  if ((result2 && ((displaymode == 2) || (displaymode == 4))) || (result2 && (!result1) && (displaymode == 3)))
										{
										   strcpy (tmp2,id3.title);
										   switch (displayformat)
											 {
											  case 0:
												if (strlen (id3.artist) > 0)
												  {
													 strcat (tmp2," - ");
													 strcat (tmp2,id3.artist);
												  }
												if (strlen (id3.album) > 0)
												  {
													 strcat (tmp2," (");
													 strcat (tmp2,id3.album);
													 strcat (tmp2,")");
												  }
												break;
											  case 1:
												if (strlen (id3.artist) > 0)
												  {
													 strcat (tmp2," - ");
													 strcat (tmp2,id3.artist);
												  }
												break;
											  case 2:
												if (strlen (id3.album) > 0)
												  {
													 strcat (tmp2," (");
													 strcat (tmp2,id3.album);
													 strcat (tmp2,")");
												  }
												break;
											  case 3:
												break;
											 }
										   entry.filename = list.EntryFilename (i);
										   list.shortenmethod = shortenmethod == 0 ? METHOD_SPLIT : METHOD_TRUNCATE;
										   list.shortname (&entry.name,tmp2,60);
										   entry.type = FT_FILE;
										   list.ChangeEntry (i,&entry);
										   free (entry.name);
										}
								   }
							  }
							setcolor (curwin,WHITE,BLUE,A_BOLD);
							visible = list.NumEntries () > 13;
							setcolor (curwin,WHITE,BLUE,A_BOLD);
							scrollframe (curpan,FALSE,visible,FRAME_MIDDLE);
							ltopchoice = lactive = 0;
						 }
					   break;
					 case 3:
					   finished = 1;
					}
			   }
			 else
			   {
				  setcolor (curwin,WHITE,BLUE,A_BOLD);
				  switch (rbactive)
					{
					 case 1:
					   tracks.RemoveEntry (ractive);
					   if (tracks.NumEntries () > 13)
						 {
							scrollframe (curpan,FALSE,TRUE,FRAME_SAVE);
							if (ractive >= tracks.NumEntries ())
							  {
								 if (rtopchoice > 0) rtopchoice--;
								 if (ractive > 0) ractive--;
							  }
						 }
					   else if (tracks.NumEntries () > 0)
						 {
							scrollframe (curpan,FALSE,FALSE,FRAME_SAVE);
							if ((ractive >= tracks.NumEntries ()) && (ractive > 0)) ractive--;
						 }
					   else
						 {
							scrollframe (curpan,FALSE,FALSE,FRAME_SAVE);
							left = TRUE;
							rtopchoice = ractive = 0;
						 }
					   break;
					 case 2:
					   tracks.RemoveEntries ();
					   scrollframe (curpan,FALSE,FALSE,FRAME_SAVE);
					   left = TRUE;
					   rtopchoice = ractive = 0;
					   break;
					 case 3:
					   finished = 1;
					}
			   }
		  }
		else beep ();
		flushinp ();
	 }
   while (!finished);
   keypad (curwin,FALSE);
   list.RemoveEntries ();
   Remove ();
   Update ();
}

void Playlist::Rearrange ()
{
   WINDOW *curwin;
   PANEL *curpan;
   chtype ch;
   bool finished = FALSE,top = FALSE,left = TRUE;
   int i,j,k,flipped = 0,topchoice = 0,active = 0;
   char line[70],txt[70],*tmp;
   Add (70,19,(COLS - 70) >> 1,(LINES - 19) >> 1,"",A_BOLD,WHITE,BLUE);
   disableframes ();
   curwin = GetWindow ();
   curpan = GetPanel ();
   doubleframe (curpan);
   horzline (curpan,0,71,16,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
   horzline (curpan,0,71,18,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
   vertline (curpan,36,0,16,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
   setcolor (curwin,WHITE,BLUE,A_BOLD);
   if (tracks.NumEntries () > 13) scrollframe (curpan,FALSE,TRUE,FRAME_SAVE);
   keypad (curwin,TRUE);
   do
	 {
		if (top) setcolor (curwin,WHITE,BLUE,A_BOLD); else setcolor (curwin,GREEN,GREEN,A_BOLD);
		mvwaddstr (curwin,19,32," Finished ");
		k = topchoice + 13;
		if (tracks.NumEntries () < k) k = tracks.NumEntries ();
		if (tracks.NumEntries () > 0)
		  {
			 setcolor (curwin,WHITE,BLUE,A_BOLD);
			 strcpy (line,tracks.EntryName (active));
			 for (i = strlen (line); i < 68; i++) mvwaddch (curwin,17,i,' ');
			 mvwaddstr (curwin,17,2,line);
		  }
		setcolor (curwin,WHITE,BLUE,A_BOLD);
		line[31] = '\0';
		for (i = 0; i < 31; i++) line[i] = ' ';
		for (i = 2; i < 15; i++)
		  {
			 mvwaddstr (curwin,i,2,line);
			 mvwaddstr (curwin,i,38,line);
		  }
		for (i = topchoice; i < k; i++)
		  {
			 sprintf (line,"%d. ",i + 1);
			 //if (strlen (line) == 3) sprintf (line," %d. ",i + 1);
			 if (left || (i != flipped))
			   {
				  tracks.shortenmethod = shortenmethod == 0 ? METHOD_SPLIT : METHOD_TRUNCATE;
				  tracks.shortname (&tmp,tracks.EntryName (i),25);
				  strcat (line,tmp);
				  free (tmp);
			   }
			 for (j = strlen (line); j < 31; j++) line[j] = ' ';
			 line[31] = '\0';
			 if (i != active)
			   {
				  setcolor (curwin,WHITE,BLUE,A_BOLD);
				  mvwaddstr (curwin,i - topchoice + 2,2,line);
			   }
			 else
			   {
				  if (left)
					{
					   if (top) setcolor (curwin,GREEN,GREEN,A_BOLD); else setcolor (curwin,WHITE,BLUE,A_BOLD);
					   mvwaddstr (curwin,i - topchoice + 2,2,line);
					}
				  else
					{
                       strcpy (txt,"    ");
					   tracks.shortenmethod = shortenmethod == 0 ? METHOD_SPLIT : METHOD_TRUNCATE;
					   tracks.shortname (&tmp,tracks.EntryName (flipped),25);
					   strcat (txt,tmp);
					   free (tmp);
					   for (j = strlen (txt); j < 31; j++) txt[j] = ' ';
					   txt[31] = '\0';
					   if (top) setcolor (curwin,GREEN,GREEN,A_BOLD); else setcolor (curwin,WHITE,BLUE,A_BOLD);
					   mvwaddstr (curwin,i - topchoice + 2,38,txt);
					   setcolor (curwin,WHITE,BLUE,A_BOLD);
					   mvwaddstr (curwin,i - topchoice + 2,2,line);
					}
			   }
		  }
		if (tracks.NumEntries () > 13) scrollbutton (curpan,active,tracks.NumEntries (),TRUE,FRAME_SAVE);
		setcolor (curwin,WHITE,BLUE,A_BOLD);
		Update ();
		ch = wgetch (curwin);
		if (tracks.NumEntries () > 13) scrollbutton (curpan,active,tracks.NumEntries (),FALSE,FRAME_SAVE);
		if (IsHotkey (ch))
		  {
			 bool visible;
			 flushinp ();
			 singleframe (curpan);
			 horzline (curpan,0,71,16,TRUE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 horzline (curpan,0,71,18,TRUE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 vertline (curpan,36,0,16,TRUE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 visible = tracks.NumEntries () > 13;
			 scrollframe (curpan,TRUE,visible,FRAME_SAVE);
			 execfunc (ch);
			 doubleframe (curpan);
			 horzline (curpan,0,71,16,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 horzline (curpan,0,71,18,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 vertline (curpan,36,0,16,FALSE,TRUE,SIDE_TNORMAL,SIDE_TNORMAL);
			 visible = tracks.NumEntries () > 13;
			 scrollframe (curpan,FALSE,visible,FRAME_SAVE);
			 finished = abortflag;
		  }
		else if (ch == XCTRL ('l'))
		  {
			 Refresh ();
		  }
		else if (ch == '\t')
		  {
			 if ((top && (!left)) || (tracks.NumEntries () == 0)) beep (); else top = (!top);
		  }
		else if (ch == '\n')
		  {
			 if (top) beep (); else finished = TRUE;
		  }
		else if (ch == KEY_UP)
		  {
			 if (!top) beep (); else
			   {
				  if (active == 0) beep (); else
					{
					   if (active > topchoice) active--; else
						 {
							active--;
							topchoice--;
						 }
					}
			   }
		  }
		else if (ch == KEY_DOWN)
		  {
			 if (!top) beep (); else
			   {
				  if (active == tracks.NumEntries () - 1) beep (); else
					{
					   if (active < k - 1) active++; else
						 {
							active++;
							topchoice++;
						 }
					}
			   }
		  }
		else if (ch == KEY_LEFT)
		  {
			 if ((!top) || (top && left)) beep (); else
			   {
				  if (active == flipped)
					{
					   left = TRUE;
					   flipped = 0;
					}
				  else tracks.SwapEntries (flipped,active);
			   }
		  }
		else if (ch == KEY_RIGHT)
		  {
			 if (!top) beep (); else
			   {
				  if (left)
					{
					   flipped = active;
					   left = FALSE;
					}
				  else if (active == flipped) beep ();
				  else tracks.SwapEntries (flipped,active);
			   }
		  }
		else if (ch == KEY_HOME)
		  {
			 if ((!top) || (top && (active == 0))) beep (); else topchoice = active = 0;
		  }
		else if (ch == KEY_END)
		  {
			 if ((!top) || (top && (active == tracks.NumEntries () - 1))) beep (); else
			   {
				  active = tracks.NumEntries () - 1;
				  topchoice = active - 12;
				  if (topchoice < 0) topchoice = 0;
			   }
		  }
		else if (ch == KEY_NPAGE)	/* PGDN */
		  {
			 if ((!top) || (top && (active == tracks.NumEntries () - 1))) beep (); else
			   {
				  if (active < tracks.NumEntries () - 14)
					{
					   topchoice += 13;
					   active += 13;
					   while (topchoice > tracks.NumEntries () - 14)
						 {
							topchoice--;
							active--;
						 }
					}
				  else
					{
					   active = tracks.NumEntries () - 1;
					   topchoice = active - 12;
					   if (topchoice < 0) topchoice = 0;
					}
			   }
		  }
		else if (ch == KEY_PPAGE)	/* PGUP */
		  {
			 if ((!top) || (top && (active == 0))) beep (); else
			   {
				  if (active > 12)
					{
					   active -= 13;
					   topchoice -= 13;
					   if (topchoice < 0) topchoice = 0;
					}
				  else active = topchoice = 0;
			   }
		  }
		else beep ();
		flushinp ();
	 }
   while (!finished);
   keypad (curwin,FALSE);
   Remove ();
   Update ();
}

void Playlist::Shuffle ()
{
   if (confirmdialogs)
	 {
		if (Question ((COLS - 30) >> 1,LINES >> 1,"Shuffle tracks",A_BOLD,WHITE,RED))
		  tracks.ShuffleEntries ();
	 }
   else
	 {
		Info ((COLS - 20) >> 1,LINES >> 1,"Shuffling tracks",A_BOLD,WHITE,MAGENTA);
		tracks.ShuffleEntries ();
	 }
}

void Playlist::SetWrapper (int wrapper,void (*function)())
{
   switch (wrapper)
	 {
	  case WRAPPER_BROWSE:
		browse_wrapper = function;
		break;
	  case WRAPPER_REARRANGE:
		rearrange_wrapper = function;
		break;
	  case WRAPPER_SHUFFLE:
		shuffle_wrapper = function;
		break;
	  case WRAPPER_PLAYLISTS:
		playlists_wrapper = function;
		break;
	  default:
		/* This shouldn't happen */
		break;
	 }
}

void Playlist::SetFunction (int functype,void (*function)())
{
   switch (functype)
	 {
	  case FUNCTION_SWITCHMODE:
		switchmode_function = function;
		break;
	  case FUNCTION_PLAYTRACK:
		playtrack_function = function;
		break;
	  case FUNCTION_PLAYSELECTED:
		playselected_function = function;
	  default:
		/* This shouldn't happen */
		break;
	 }
}

#endif
