/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.prop;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.JPanel;
import jugglinglab.core.VersionSpecific;
import jugglinglab.prop.Prop;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;
import jugglinglab.util.ParameterList;

public class imageProp
extends Prop {
    private URL url_def;
    private URL url;
    private Image image;
    private Image scaled_image;
    private final float width_def = 10.0f;
    private float height_def;
    private float width;
    private float height;
    private Dimension size = null;
    private Dimension center = null;
    private Dimension grip = null;
    private double last_zoom = 0.0;

    public imageProp() throws JuggleExceptionUser {
        VersionSpecific versionSpecific = VersionSpecific.getVersionSpecific();
        this.url = this.url_def = versionSpecific.getDefaultPropImage();
        this.loadImage();
        this.rescaleImage(1.0);
    }

    private void loadImage() throws JuggleExceptionUser {
        try {
            MediaTracker mediaTracker = new MediaTracker(new JPanel());
            this.image = Toolkit.getDefaultToolkit().getImage(this.url);
            mediaTracker.addImage(this.image, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (mediaTracker.isErrorAny()) {
                this.image = null;
                throw new JuggleExceptionUser(errorstrings.getString("Error_bad_file"));
            }
            float f = (float)this.image.getHeight(null) / (float)this.image.getWidth(null);
            this.height_def = this.width_def * f;
            this.width = 10.0f;
            this.height = this.height_def;
        }
        catch (SecurityException securityException) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_security_restriction"));
        }
    }

    private void rescaleImage(double d) {
        int n;
        int n2 = (int)(0.5 + d * (double)this.width);
        if (n2 < 1) {
            n2 = 1;
        }
        if ((n = (int)(0.5 + d * (double)this.height)) < 1) {
            n = 1;
        }
        this.size = new Dimension(n2, n);
        this.center = new Dimension(n2 / 2, n / 2);
        int n3 = n2 / 2;
        int n4 = n;
        this.grip = new Dimension(n3, n4);
        this.last_zoom = d;
        this.scaled_image = this.image.getScaledInstance(n2, n, 4);
    }

    public String getName() {
        return "Image";
    }

    public Color getEditorColor() {
        return Color.white;
    }

    public ParameterDescriptor[] getParameterDescriptors() {
        ParameterDescriptor[] parameterDescriptorArray = new ParameterDescriptor[]{new ParameterDescriptor("image", 5, null, this.url_def, this.url), new ParameterDescriptor("width", 2, null, new Double(10.0), new Double(this.width))};
        return parameterDescriptorArray;
    }

    protected void init(String string) throws JuggleExceptionUser {
        String string2;
        if (string == null) {
            return;
        }
        ParameterList parameterList = new ParameterList(string);
        String string3 = parameterList.getParameter("image");
        if (string3 != null) {
            try {
                this.url = new URL(string3);
                this.loadImage();
            }
            catch (MalformedURLException malformedURLException) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_malformed_URL"));
            }
        }
        if ((string2 = parameterList.getParameter("width")) != null) {
            try {
                Float f = Float.valueOf(string2);
                float f2 = f.floatValue();
                if (!(f2 > 0.0f)) {
                    throw new NumberFormatException();
                }
                this.width = f2;
                float f3 = (float)this.image.getHeight(null) / (float)this.image.getWidth(null);
                this.height = this.width * f3;
            }
            catch (NumberFormatException numberFormatException) {
                String string4 = errorstrings.getString("Error_number_format");
                Object[] objectArray = new Object[]{"width"};
                throw new JuggleExceptionUser(MessageFormat.format(string4, objectArray));
            }
        }
    }

    public Image getProp2DImage(Component component, double d, double[] dArray) {
        if (d != this.last_zoom) {
            this.rescaleImage(d);
        }
        return this.scaled_image;
    }

    public Coordinate getMax() {
        return new Coordinate(this.width / 2.0f, 0.0, this.width);
    }

    public Coordinate getMin() {
        return new Coordinate(-this.width / 2.0f, 0.0, 0.0);
    }

    public Dimension getProp2DSize(Component component, double d) {
        if (this.size == null || d != this.last_zoom) {
            this.rescaleImage(d);
        }
        return this.size;
    }

    public Dimension getProp2DCenter(Component component, double d) {
        if (this.center == null || d != this.last_zoom) {
            this.rescaleImage(d);
        }
        return this.center;
    }

    public Dimension getProp2DGrip(Component component, double d) {
        if (this.grip == null || d != this.last_zoom) {
            this.rescaleImage(d);
        }
        return this.grip;
    }
}

