/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLPosition;
import jugglinglab.jml.JMLSymmetry;
import jugglinglab.jml.JMLTransition;
import jugglinglab.jml.PropDef;
import jugglinglab.notation.Notation;
import jugglinglab.notation.mhnPattern;
import jugglinglab.notation.mhnSymmetry;
import jugglinglab.notation.mhnThrow;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.Permutation;

public class mhnNotation
extends Notation {
    protected static final double[] samethrowx = new double[]{0.0, 20.0, 25.0, 12.0, 10.0, 7.5, 5.0, 5.0, 5.0};
    protected static final double[] crossingthrowx = new double[]{0.0, 20.0, 25.0, 12.0, 10.0, 18.0, 25.0, 25.0, 30.0};
    protected static final double[] catchx = new double[]{0.0, 30.0, 25.0, 30.0, 40.0, 45.0, 45.0, 50.0, 50.0};
    protected static final double restingx = 25.0;
    protected static final double splitcatchfactor = 0.4;
    protected static final double[] throwspersec = new double[]{2.0, 2.0, 2.0, 2.9, 3.4, 4.1, 4.25, 5.0, 5.0, 5.5};

    public String getName() {
        return "MHN";
    }

    public JMLPattern getJMLPattern(String string) throws JuggleExceptionUser, JuggleExceptionInternal {
        return null;
    }

    protected static JMLPattern getJML(mhnPattern mhnPattern2) throws JuggleExceptionUser, JuggleExceptionInternal {
        mhnNotation.findMasterThrows(mhnPattern2);
        mhnNotation.assignPaths(mhnPattern2);
        mhnNotation.findThrowSources(mhnPattern2);
        mhnNotation.setCatchOrder(mhnPattern2);
        JMLPattern jMLPattern = mhnNotation.convertPatternToJML(mhnPattern2);
        return jMLPattern;
    }

    protected static void findMasterThrows(mhnPattern mhnPattern2) throws JuggleExceptionInternal {
        int n;
        int n2;
        for (n2 = 0; n2 < mhnPattern2.indexes; ++n2) {
            for (n = 0; n < mhnPattern2.numjugglers; ++n) {
                for (int i = 0; i < 2; ++i) {
                    for (int j = 0; j < mhnPattern2.max_occupancy; ++j) {
                        mhnThrow mhnThrow2 = mhnPattern2.th[n][i][n2][j];
                        if (mhnThrow2 == null) continue;
                        mhnThrow2.master = mhnThrow2;
                        mhnThrow2.source = null;
                    }
                }
            }
        }
        n2 = 1;
        while (n2 != 0) {
            n2 = 0;
            for (n = 0; n < mhnPattern2.getNumberOfSymmetries(); ++n) {
                mhnSymmetry mhnSymmetry2 = mhnPattern2.getSymmetry(n);
                Permutation permutation = mhnSymmetry2.getJugglerPerm();
                int n3 = mhnSymmetry2.getDelay();
                for (int i = 0; i < mhnPattern2.indexes; ++i) {
                    int n4 = i + n3;
                    if (n4 >= mhnPattern2.indexes) continue;
                    for (int j = 0; j < mhnPattern2.numjugglers; ++j) {
                        for (int k = 0; k < 2; ++k) {
                            for (int i2 = 0; i2 < mhnPattern2.max_occupancy; ++i2) {
                                mhnThrow mhnThrow3 = mhnPattern2.th[j][k][i][i2];
                                if (mhnThrow3 == null) continue;
                                int n5 = permutation.getMapping(j + 1);
                                int n6 = n5 > 0 ? k : 1 - k;
                                mhnThrow mhnThrow4 = mhnPattern2.th[n5 = Math.abs(n5) - 1][n6][n4][i2];
                                if (mhnThrow4 == null) {
                                    throw new JuggleExceptionInternal("Problem finding master throws");
                                }
                                mhnThrow mhnThrow5 = mhnThrow3.master;
                                mhnThrow mhnThrow6 = mhnThrow4.master;
                                if (mhnThrow5 == mhnThrow6) continue;
                                mhnThrow mhnThrow7 = mhnThrow5;
                                if (mhnThrow5.index > mhnThrow6.index) {
                                    mhnThrow7 = mhnThrow6;
                                } else if (mhnThrow5.index == mhnThrow6.index) {
                                    if (mhnThrow5.juggler > mhnThrow6.juggler) {
                                        mhnThrow7 = mhnThrow6;
                                    } else if (mhnThrow5.juggler == mhnThrow6.juggler && mhnThrow5.hand > mhnThrow6.hand) {
                                        mhnThrow7 = mhnThrow6;
                                    }
                                }
                                mhnThrow3.master = mhnThrow4.master = mhnThrow7;
                                n2 = 1;
                            }
                        }
                    }
                }
            }
        }
    }

    protected static void assignPaths(mhnPattern mhnPattern2) throws JuggleExceptionUser, JuggleExceptionInternal {
        int n;
        int n2;
        int n3;
        int n4;
        for (n4 = 0; n4 < mhnPattern2.indexes; ++n4) {
            for (n3 = 0; n3 < mhnPattern2.numjugglers; ++n3) {
                for (n2 = 0; n2 < 2; ++n2) {
                    for (n = 0; n < mhnPattern2.max_occupancy; ++n) {
                        mhnThrow mhnThrow2;
                        int n5;
                        int n6;
                        int n7;
                        int n8;
                        int n9;
                        mhnThrow mhnThrow3 = mhnPattern2.th[n3][n2][n4][n];
                        if (mhnThrow3 == null || mhnThrow3.master != mhnThrow3) continue;
                        for (n9 = 0; n9 < mhnPattern2.max_occupancy; ++n9) {
                            n8 = 1;
                            for (n7 = 0; n7 < mhnPattern2.indexes; ++n7) {
                                for (n6 = 0; n6 < mhnPattern2.numjugglers; ++n6) {
                                    for (n5 = 0; n5 < 2; ++n5) {
                                        for (int i = 0; i < mhnPattern2.max_occupancy; ++i) {
                                            mhnThrow2 = mhnPattern2.th[n6][n5][n7][i];
                                            if (mhnThrow2 == null || mhnThrow2.master != mhnThrow3 || mhnThrow2.targetindex >= mhnPattern2.indexes) continue;
                                            mhnThrow mhnThrow4 = mhnPattern2.th[mhnThrow2.targetjuggler - 1][mhnThrow2.targethand][mhnThrow2.targetindex][n9];
                                            if (mhnThrow4 == null) {
                                                n8 = 0;
                                                continue;
                                            }
                                            n8 &= mhnThrow4.source == null ? 1 : 0;
                                        }
                                    }
                                }
                            }
                            if (n8 != 0) break;
                        }
                        if (n9 == mhnPattern2.max_occupancy) {
                            throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern"));
                        }
                        for (n8 = 0; n8 < mhnPattern2.indexes; ++n8) {
                            for (n7 = 0; n7 < mhnPattern2.numjugglers; ++n7) {
                                for (n6 = 0; n6 < 2; ++n6) {
                                    for (n5 = 0; n5 < mhnPattern2.max_occupancy; ++n5) {
                                        mhnThrow mhnThrow5 = mhnPattern2.th[n7][n6][n8][n5];
                                        if (mhnThrow5 == null || mhnThrow5.master != mhnThrow3 || mhnThrow5.targetindex >= mhnPattern2.indexes) continue;
                                        mhnThrow2 = mhnPattern2.th[mhnThrow5.targetjuggler - 1][mhnThrow5.targethand][mhnThrow5.targetindex][n9];
                                        if (mhnThrow2 == null) {
                                            throw new JuggleExceptionInternal("Got null target in assignPaths()");
                                        }
                                        mhnThrow5.target = mhnThrow2;
                                        mhnThrow2.source = mhnThrow5;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        n4 = 1;
        for (n3 = 0; n3 < mhnPattern2.indexes; ++n3) {
            for (n2 = 0; n2 < mhnPattern2.numjugglers; ++n2) {
                for (n = 0; n < 2; ++n) {
                    for (int i = 0; i < mhnPattern2.max_occupancy; ++i) {
                        mhnThrow mhnThrow6 = mhnPattern2.th[n2][n][n3][i];
                        if (mhnThrow6 == null) continue;
                        mhnThrow mhnThrow7 = mhnThrow6.source;
                        if (mhnThrow7 == null) {
                            if (n4 > mhnPattern2.numpaths) {
                                throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern"));
                            }
                            mhnThrow6.pathnum = n4++;
                            continue;
                        }
                        mhnThrow6.pathnum = mhnThrow7.pathnum;
                    }
                }
            }
        }
        if (n4 <= mhnPattern2.numpaths) {
            throw new JuggleExceptionInternal("Problem assigning path numbers 2");
        }
    }

    protected static void findThrowSources(mhnPattern mhnPattern2) throws JuggleExceptionInternal {
        for (int i = mhnPattern2.indexes - 1; i >= 0; --i) {
            for (int j = 0; j < mhnPattern2.numjugglers; ++j) {
                for (int k = 0; k < 2; ++k) {
                    for (int i2 = 0; i2 < mhnPattern2.max_occupancy; ++i2) {
                        mhnThrow mhnThrow2 = mhnPattern2.th[j][k][i][i2];
                        if (mhnThrow2 == null || mhnThrow2.source != null) continue;
                        if (i + mhnPattern2.getPeriod() < mhnPattern2.indexes) {
                            mhnThrow mhnThrow3 = mhnPattern2.th[j][k][i + mhnPattern2.getPeriod()][i2].source;
                            if (mhnThrow3 == null) {
                                throw new JuggleExceptionInternal("Could not get throw source 1");
                            }
                            mhnThrow mhnThrow4 = new mhnThrow();
                            mhnThrow4.juggler = mhnThrow3.juggler;
                            mhnThrow4.hand = mhnThrow3.hand;
                            mhnThrow4.index = mhnThrow3.index - mhnPattern2.getPeriod();
                            mhnThrow4.slot = mhnThrow3.slot;
                            mhnThrow4.targetjuggler = j;
                            mhnThrow4.targethand = k;
                            mhnThrow4.targetindex = i;
                            mhnThrow4.targetslot = i2;
                            mhnThrow4.handsindex = -1;
                            mhnThrow4.pathnum = mhnThrow2.pathnum;
                            mhnThrow4.mod = mhnThrow3.mod;
                            mhnThrow4.master = mhnThrow3.master;
                            mhnThrow4.source = null;
                            mhnThrow4.target = mhnThrow2;
                            mhnThrow2.source = mhnThrow4;
                            continue;
                        }
                        throw new JuggleExceptionInternal("Could not get throw source 2");
                    }
                }
            }
        }
    }

    protected static boolean isCatchOrderIncorrect(mhnThrow mhnThrow2, mhnThrow mhnThrow3) {
        int n;
        int n2;
        if (mhnThrow2.source.index > mhnThrow3.source.index) {
            return true;
        }
        if (mhnThrow2.source.index < mhnThrow3.source.index) {
            return false;
        }
        int n3 = Math.abs(mhnThrow2.juggler - mhnThrow2.source.juggler);
        if (n3 < (n2 = Math.abs(mhnThrow3.juggler - mhnThrow3.source.juggler))) {
            return true;
        }
        if (n3 > n2) {
            return false;
        }
        int n4 = Math.abs(mhnThrow2.hand - mhnThrow2.source.hand);
        if (n4 > (n = Math.abs(mhnThrow3.hand - mhnThrow3.source.hand))) {
            return true;
        }
        if (n4 < n) {
            return false;
        }
        return false;
    }

    protected static void setCatchOrder(mhnPattern mhnPattern2) throws JuggleExceptionInternal {
        int n;
        int n2;
        int n3;
        int n4;
        mhnThrow[][][][] mhnThrowArray = mhnPattern2.getThrows();
        for (n4 = 0; n4 < mhnPattern2.getIndexes(); ++n4) {
            for (n3 = 0; n3 < mhnPattern2.getNumberOfJugglers(); ++n3) {
                for (n2 = 0; n2 < 2; ++n2) {
                    mhnThrow mhnThrow2;
                    int n5;
                    n = 0;
                    for (n5 = 0; n5 < mhnPattern2.getMaxOccupancy() && (mhnThrow2 = mhnThrowArray[n3][n2][n4][n5]) != null; ++n5) {
                        boolean bl = mhnThrow2.catching = mhnThrow2.source.mod.charAt(0) != 'H';
                        if (!mhnThrow2.catching) continue;
                        mhnThrow2.catchnum = n++;
                    }
                    if (n < 2) continue;
                    for (n5 = 0; n5 < mhnPattern2.getMaxOccupancy() && (mhnThrow2 = mhnThrowArray[n3][n2][n4][n5]) != null && mhnThrow2.master == mhnThrow2; ++n5) {
                        mhnThrow mhnThrow3;
                        if (!mhnThrow2.catching) continue;
                        for (int i = n5 + 1; i < mhnPattern2.getMaxOccupancy() && (mhnThrow3 = mhnThrowArray[n3][n2][n4][i]) != null && mhnThrow3.master == mhnThrow3; ++i) {
                            if (!mhnThrow3.catching) continue;
                            boolean bl = false;
                            bl = mhnThrow2.catchnum < mhnThrow3.catchnum ? mhnNotation.isCatchOrderIncorrect(mhnThrow2, mhnThrow3) : mhnNotation.isCatchOrderIncorrect(mhnThrow3, mhnThrow2);
                            if (!bl) continue;
                            int n6 = mhnThrow2.catchnum;
                            mhnThrow2.catchnum = mhnThrow3.catchnum;
                            mhnThrow3.catchnum = n6;
                        }
                    }
                }
            }
        }
        for (n4 = 0; n4 < mhnPattern2.getIndexes(); ++n4) {
            for (n3 = 0; n3 < mhnPattern2.getNumberOfJugglers(); ++n3) {
                for (n2 = 0; n2 < 2; ++n2) {
                    mhnThrow mhnThrow4;
                    for (n = 0; n < mhnPattern2.getMaxOccupancy() && (mhnThrow4 = mhnThrowArray[n3][n2][n4][n]) != null && mhnThrow4.master != mhnThrow4; ++n) {
                        mhnThrow4.catchnum = mhnThrow4.master.catchnum;
                    }
                }
            }
        }
    }

    protected static JMLPattern convertPatternToJML(mhnPattern mhnPattern2) throws JuggleExceptionUser, JuggleExceptionInternal {
        double d;
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        JMLPattern jMLPattern = new JMLPattern();
        jMLPattern.setNumberOfJugglers(mhnPattern2.getNumberOfJugglers());
        jMLPattern.setNumberOfPaths(mhnPattern2.getNumberOfPaths());
        if (mhnPattern2.bps <= 0.0) {
            mhnPattern2.bps = mhnNotation.calcBps(mhnPattern2);
        }
        int n5 = mhnPattern2.getNumberOfPaths();
        int n6 = mhnPattern2.color == null ? 1 : Math.min(n5, mhnPattern2.color.length);
        for (int i = 0; i < n6; ++i) {
            Object object2 = null;
            if (mhnPattern2.propdiam != mhnPattern.propdiam_default) {
                object2 = "diam=" + mhnPattern2.propdiam;
            }
            if (mhnPattern2.color != null) {
                object = "color=" + mhnPattern2.color[i];
                object2 = object2 == null ? object : (String)object2 + ";" + (String)object;
            }
            jMLPattern.addProp(new PropDef(mhnPattern2.getPropName(), (String)object2));
        }
        int[] nArray = new int[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            nArray[n4] = 1 + n4 % n6;
        }
        jMLPattern.setPropAssignments(nArray);
        for (n4 = 0; n4 < mhnPattern2.getNumberOfSymmetries(); ++n4) {
            Object object3;
            int n7;
            Object object4;
            object = mhnPattern2.getSymmetry(n4);
            int[] nArray2 = new int[n5 + 1];
            switch (((mhnSymmetry)object).getType()) {
                case 1: {
                    mhnThrow mhnThrow2;
                    int n8;
                    int n9;
                    int n10;
                    n3 = 1;
                    object4 = mhnPattern2.getThrows();
                    for (n7 = 0; n7 < mhnPattern2.getIndexes() - ((mhnSymmetry)object).getDelay(); ++n7) {
                        for (n10 = 0; n10 < mhnPattern2.getNumberOfJugglers(); ++n10) {
                            for (n9 = 0; n9 < 2; ++n9) {
                                for (n8 = 0; n8 < mhnPattern2.getMaxOccupancy(); ++n8) {
                                    mhnThrow mhnThrow3 = object4[n10][n9][n7][n8];
                                    if (mhnThrow3 == null || mhnThrow3.pathnum == -1) continue;
                                    mhnThrow2 = object4[n10][n9][n7 + ((mhnSymmetry)object).getDelay()][n8];
                                    if (mhnThrow2 == null) {
                                        throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern_paths"));
                                    }
                                    if (mhnThrow3.pathnum == 0 || mhnThrow2.pathnum == 0) {
                                        throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern_paths"));
                                    }
                                    if (nArray2[mhnThrow3.pathnum] == 0) {
                                        nArray2[mhnThrow3.pathnum] = mhnThrow2.pathnum;
                                        continue;
                                    }
                                    if (nArray2[mhnThrow3.pathnum] == mhnThrow2.pathnum) continue;
                                    throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern_delay"));
                                }
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
                case 3: {
                    mhnThrow mhnThrow2;
                    int n8;
                    int n9;
                    int n10;
                    n3 = 3;
                    object4 = ((mhnSymmetry)object).getJugglerPerm();
                    object3 = mhnPattern2.getThrows();
                    for (n10 = 0; n10 < mhnPattern2.getIndexes() - ((mhnSymmetry)object).getDelay(); ++n10) {
                        for (n9 = 0; n9 < mhnPattern2.getNumberOfJugglers(); ++n9) {
                            for (n8 = 0; n8 < 2; ++n8) {
                                for (int i = 0; i < mhnPattern2.getMaxOccupancy(); ++i) {
                                    int n11;
                                    mhnThrow2 = object3[n9][n8][n10][i];
                                    if (mhnThrow2 == null || mhnThrow2.pathnum == -1) continue;
                                    n2 = ((Permutation)object4).getMapping(n9 + 1);
                                    int n12 = Math.abs(n2) - 1;
                                    mhnThrow mhnThrow4 = object3[n12][n11 = n2 > 0 ? n8 : 1 - n8][n10 + ((mhnSymmetry)object).getDelay()][i];
                                    if (mhnThrow4 == null) {
                                        throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern_paths"));
                                    }
                                    if (mhnThrow2.pathnum == 0 || mhnThrow4.pathnum == 0) {
                                        throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern_paths"));
                                    }
                                    if (nArray2[mhnThrow2.pathnum] == 0) {
                                        nArray2[mhnThrow2.pathnum] = mhnThrow4.pathnum;
                                        continue;
                                    }
                                    if (nArray2[mhnThrow2.pathnum] == mhnThrow4.pathnum) continue;
                                    throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern_switchdelay"));
                                }
                            }
                        }
                    }
                    break;
                }
                default: {
                    throw new JuggleExceptionUser(errorstrings.getString("Error_unknown_symmetry"));
                }
            }
            object4 = "";
            for (n7 = 1; n7 < n5; ++n7) {
                object4 = (String)object4 + nArray2[n7] + ",";
            }
            object4 = (String)object4 + nArray2[n5];
            object3 = new JMLSymmetry(n3, ((mhnSymmetry)object).getNumberOfJugglers(), ((mhnSymmetry)object).getJugglerPerm().toString(), mhnPattern2.getNumberOfPaths(), (String)object4, (double)((mhnSymmetry)object).getDelay() / mhnPattern2.bps);
            jMLPattern.addSymmetry((JMLSymmetry)object3);
        }
        boolean[][] blArray = new boolean[mhnPattern2.getNumberOfJugglers()][2];
        for (int i = 0; i < mhnPattern2.getNumberOfJugglers(); ++i) {
            for (n3 = 0; n3 < 2; ++n3) {
                blArray[i][n3] = false;
            }
        }
        boolean[] blArray2 = new boolean[mhnPattern2.getNumberOfPaths()];
        for (n3 = 0; n3 < mhnPattern2.getNumberOfPaths(); ++n3) {
            blArray2[n3] = false;
        }
        mhnThrow[][][][] mhnThrowArray = mhnPattern2.getThrows();
        for (n = 0; n < mhnPattern2.getPeriod(); ++n) {
            for (int i = 0; i < mhnPattern2.getNumberOfJugglers(); ++i) {
                int n13;
                for (n13 = 0; n13 < 2; ++n13) {
                    int n14;
                    Coordinate coordinate;
                    int n15;
                    int n16;
                    int n17;
                    mhnThrow mhnThrow5;
                    int n18;
                    int n19;
                    mhnThrow mhnThrow6 = mhnThrowArray[i][n13][n][0];
                    if (mhnThrow6 == null || mhnThrow6.master != mhnThrow6) continue;
                    JMLEvent jMLEvent = new JMLEvent();
                    double d2 = 0.0;
                    int n20 = 0;
                    n2 = 0;
                    for (int j = 0; j < mhnPattern2.getMaxOccupancy(); ++j) {
                        mhnThrow mhnThrow7 = mhnThrowArray[i][n13][n][j];
                        if (mhnThrow7 == null) continue;
                        String string = null;
                        String string2 = null;
                        switch (mhnThrow7.mod.charAt(0)) {
                            case 'B': {
                                string = "bounce";
                                string2 = null;
                                if (mhnThrow7.mod.indexOf("F") != -1) {
                                    string2 = string2 == null ? "forced=true" : string2 + ";forced=true";
                                }
                                if (mhnThrow7.mod.indexOf("H") != -1) {
                                    string2 = string2 == null ? "hyper=true" : string2 + ";hyper=true";
                                }
                                n19 = 1;
                                for (n18 = 1; n18 < mhnThrow7.mod.length(); ++n18) {
                                    if (mhnThrow7.mod.charAt(n18) != 'B') continue;
                                    ++n19;
                                }
                                if (n19 > 1) {
                                    string2 = string2 == null ? "bounces=" + n19 : string2 + ";bounces=" + n19;
                                }
                                if (mhnPattern2.bouncefrac != mhnPattern.bouncefrac_default) {
                                    string2 = string2 == null ? "bouncefrac=" + mhnPattern2.bouncefrac : string2 + ";bouncefrac=" + mhnPattern2.bouncefrac;
                                }
                                if (mhnPattern2.gravity == mhnPattern.gravity_default) break;
                                if (string2 == null) {
                                    string2 = "g=" + mhnPattern2.gravity;
                                    break;
                                }
                                string2 = string2 + ";g=" + mhnPattern2.gravity;
                                break;
                            }
                            case 'F': {
                                string = "bounce";
                                string2 = "forced=true";
                                if (mhnPattern2.bouncefrac != mhnPattern.bouncefrac_default) {
                                    string2 = string2 + ";bouncefrac=" + mhnPattern2.bouncefrac;
                                }
                                if (mhnPattern2.gravity == mhnPattern.gravity_default) break;
                                string2 = string2 + ";g=" + mhnPattern2.gravity;
                                break;
                            }
                            case 'H': {
                                string = "hold";
                                string2 = null;
                                break;
                            }
                            default: {
                                string = "toss";
                                string2 = null;
                                if (mhnPattern2.gravity == mhnPattern.gravity_default) break;
                                string2 = "g=" + mhnPattern2.gravity;
                            }
                        }
                        if (mhnThrow7.mod.charAt(0) != 'H') {
                            jMLEvent.addTransition(new JMLTransition(1, mhnThrow7.pathnum, string, string2));
                            n19 = mhnThrow7.targetindex - n;
                            if (n19 == 1) {
                                n2 = 1;
                            }
                            d2 = mhnThrow7.targethand == n13 ? (d2 += n19 > 8 ? samethrowx[8] : samethrowx[n19]) : (d2 += n19 > 8 ? crossingthrowx[8] : crossingthrowx[n19]);
                            ++n20;
                            continue;
                        }
                        if (mhnPattern2.hands == null || mhnThrow7.pathnum == -1) continue;
                        jMLEvent.addTransition(new JMLTransition(4, mhnThrow7.pathnum, string, string2));
                        blArray2[mhnThrow7.pathnum - 1] = true;
                    }
                    if (mhnPattern2.hands == null) {
                        if (n20 > 0) {
                            double d3 = d2 / (double)n20;
                            if (n13 == 1) {
                                d3 = -d3;
                            }
                            jMLEvent.setLocalCoordinate(new Coordinate(d3, 0.0, 0.0));
                            jMLEvent.calcpos = false;
                        } else {
                            jMLEvent.calcpos = true;
                        }
                    } else {
                        Coordinate coordinate2 = mhnPattern2.hands.getCoordinate(mhnThrow6.juggler, mhnThrow6.handsindex, 0);
                        if (n13 == 1) {
                            coordinate2.x = -coordinate2.x;
                        }
                        jMLEvent.setLocalCoordinate(coordinate2);
                        jMLEvent.calcpos = false;
                    }
                    double d4 = n2 != 0 ? ((double)n - 0.25 * mhnPattern2.dwell) / mhnPattern2.bps : (double)n / mhnPattern2.bps;
                    jMLEvent.setT(d4);
                    jMLEvent.setHand(i + 1, n13 == 0 ? 2 : 1);
                    jMLPattern.addEvent(jMLEvent);
                    for (int j = 0; j < mhnPattern2.indexes; ++j) {
                        for (int k = 0; k < mhnPattern2.numjugglers; ++k) {
                            for (n19 = 0; n19 < 2; ++n19) {
                                for (n18 = 0; n18 < mhnPattern2.max_occupancy; ++n18) {
                                    mhnThrow mhnThrow8 = mhnThrowArray[k][n19][j][n18];
                                    if (mhnThrow8 == null || mhnThrow8.master != mhnThrow6) continue;
                                    blArray[k][n19] = true;
                                }
                            }
                        }
                    }
                    double d5 = 0.0;
                    n19 = 0;
                    n18 = 0;
                    for (int j = 0; j < mhnPattern2.getMaxOccupancy() && (mhnThrow5 = mhnThrowArray[i][n13][n][j]) != null; ++j) {
                        if (!mhnThrow5.catching) continue;
                        n17 = mhnThrow5.pathnum;
                        n16 = n - mhnThrow5.source.index;
                        blArray2[n17 - 1] = true;
                        d5 += n16 > 8 ? catchx[8] : catchx[n16];
                        ++n19;
                        if (n16 != 1) continue;
                        n18 = 1;
                    }
                    d = 0.0;
                    if (n19 < 2) {
                        mhnThrow mhnThrow9;
                        jMLEvent = new JMLEvent();
                        if (mhnPattern2.hands == null) {
                            if (n19 > 0) {
                                double d6 = d5 / (double)n19;
                                jMLEvent.setLocalCoordinate(new Coordinate(n13 == 0 ? d6 : -d6, 0.0, 0.0));
                                jMLEvent.calcpos = false;
                            } else {
                                jMLEvent.calcpos = true;
                            }
                        } else {
                            for (n17 = mhnThrow6.handsindex - 2; n17 < 0; n17 += mhnPattern2.hands.getPeriod(mhnThrow6.juggler)) {
                            }
                            n16 = mhnPattern2.hands.getCatchIndex(mhnThrow6.juggler, n17);
                            Coordinate coordinate3 = mhnPattern2.hands.getCoordinate(mhnThrow6.juggler, n17, n16);
                            if (n13 == 1) {
                                coordinate3.x = -coordinate3.x;
                            }
                            jMLEvent.setLocalCoordinate(coordinate3);
                            jMLEvent.calcpos = false;
                        }
                        d = n18 != 0 ? ((double)n - 0.5 * mhnPattern2.dwell) / mhnPattern2.bps : ((double)n - mhnPattern2.dwell) / mhnPattern2.bps;
                        jMLEvent.setT(d);
                        jMLEvent.setHand(i + 1, n13 == 0 ? 2 : 1);
                        for (n17 = 0; n17 < mhnPattern2.getMaxOccupancy() && (mhnThrow9 = mhnThrowArray[i][n13][n][n17]) != null; ++n17) {
                            if (mhnThrow9.catching) {
                                jMLEvent.addTransition(new JMLTransition(2, mhnThrow9.pathnum, null, null));
                                continue;
                            }
                            if (mhnPattern2.hands == null || mhnThrow9.pathnum == -1) continue;
                            jMLEvent.addTransition(new JMLTransition(4, mhnThrow9.pathnum, null, null));
                            blArray2[mhnThrow9.pathnum - 1] = true;
                        }
                        jMLPattern.addEvent(jMLEvent);
                    } else {
                        for (n17 = 0; n17 < mhnPattern2.getMaxOccupancy(); ++n17) {
                            mhnThrow mhnThrow10 = mhnThrowArray[i][n13][n][n17];
                            if (mhnThrow10 == null || !mhnThrow10.catching) continue;
                            jMLEvent = new JMLEvent();
                            if (mhnPattern2.hands == null) {
                                double d7 = d5 / (double)n19;
                                jMLEvent.setLocalCoordinate(new Coordinate(n13 == 0 ? d7 : -d7, 0.0, 0.0));
                            } else {
                                int n21;
                                for (n21 = mhnThrow6.handsindex - 2; n21 < 0; n21 += mhnPattern2.hands.getPeriod(mhnThrow6.juggler)) {
                                }
                                n15 = mhnPattern2.hands.getCatchIndex(mhnThrow6.juggler, n21);
                                coordinate = mhnPattern2.hands.getCoordinate(mhnThrow6.juggler, n21, n15);
                                if (n13 == 1) {
                                    coordinate.x = -coordinate.x;
                                }
                                jMLEvent.setLocalCoordinate(coordinate);
                            }
                            jMLEvent.calcpos = false;
                            double d8 = n18 != 0 ? ((double)n - 0.5 * mhnPattern2.dwell + ((double)mhnThrow10.catchnum / (double)(n19 - 1) - 0.5) * 0.4) / mhnPattern2.bps : ((double)n - mhnPattern2.dwell + ((double)mhnThrow10.catchnum / (double)(n19 - 1) - 0.5) * 0.4) / mhnPattern2.bps;
                            jMLEvent.setT(d8);
                            if (mhnThrow6.catchnum == n19 - 1) {
                                d = d8;
                            }
                            jMLEvent.setHand(i + 1, n13 == 0 ? 2 : 1);
                            jMLEvent.addTransition(new JMLTransition(2, mhnThrow10.pathnum, null, null));
                            jMLPattern.addEvent(jMLEvent);
                        }
                    }
                    if (mhnPattern2.hands == null) continue;
                    for (n17 = mhnThrow6.handsindex - 2; n17 < 0; n17 += mhnPattern2.hands.getPeriod(mhnThrow6.juggler)) {
                    }
                    int n22 = mhnPattern2.hands.getCatchIndex(mhnThrow6.juggler, n17);
                    int n23 = mhnPattern2.hands.getNumberOfCoordinates(mhnThrow6.juggler, n17) - n22;
                    for (n15 = 1; n15 < n23; ++n15) {
                        coordinate = mhnPattern2.hands.getCoordinate(mhnThrow6.juggler, n17, n22 + n15);
                        if (coordinate == null) continue;
                        jMLEvent = new JMLEvent();
                        if (n13 == 1) {
                            coordinate.x = -coordinate.x;
                        }
                        jMLEvent.setLocalCoordinate(coordinate);
                        jMLEvent.calcpos = false;
                        jMLEvent.setT(d + (double)n15 * (d4 - d) / (double)n23);
                        jMLEvent.setHand(mhnThrow6.juggler, n13 == 0 ? 2 : 1);
                        jMLPattern.addEvent(jMLEvent);
                    }
                    double d9 = d;
                    for (n14 = n + 1; n14 < mhnPattern2.getIndexes(); ++n14) {
                        mhnThrow mhnThrow11;
                        int n24 = 0;
                        boolean bl = false;
                        boolean bl2 = false;
                        for (int j = 0; j < mhnPattern2.getMaxOccupancy() && (mhnThrow11 = mhnThrowArray[i][n13][n14][j]) != null; ++j) {
                            bl = true;
                            if (!mhnThrow11.catching) continue;
                            ++n24;
                            if (n14 - mhnThrow11.source.index != 1) continue;
                            bl2 = true;
                        }
                        if (!bl) continue;
                        if (n24 < 2) {
                            if (bl2) {
                                d9 = ((double)n14 - 0.5 * mhnPattern2.dwell) / mhnPattern2.bps;
                                break;
                            }
                            d9 = ((double)n14 - mhnPattern2.dwell) / mhnPattern2.bps;
                            break;
                        }
                        if (bl2) {
                            d9 = ((double)n14 - 0.5 * mhnPattern2.dwell - 0.2) / mhnPattern2.bps;
                            break;
                        }
                        d9 = ((double)n14 - mhnPattern2.dwell - 0.2) / mhnPattern2.bps;
                        break;
                    }
                    if (d9 == d) {
                        throw new JuggleExceptionInternal("Couldn't find next catch/hold past t=" + d);
                    }
                    n17 = mhnThrow6.handsindex;
                    n23 = mhnPattern2.hands.getCatchIndex(mhnThrow6.juggler, n17);
                    for (n14 = 1; n14 < n23; ++n14) {
                        Coordinate coordinate4 = mhnPattern2.hands.getCoordinate(mhnThrow6.juggler, n17, n14);
                        if (coordinate4 == null) continue;
                        jMLEvent = new JMLEvent();
                        if (n13 == 1) {
                            coordinate4.x = -coordinate4.x;
                        }
                        jMLEvent.setLocalCoordinate(coordinate4);
                        jMLEvent.calcpos = false;
                        jMLEvent.setT(d4 + (double)n14 * (d9 - d4) / (double)n23);
                        jMLEvent.setHand(mhnThrow6.juggler, n13 == 0 ? 2 : 1);
                        jMLPattern.addEvent(jMLEvent);
                    }
                }
                if (mhnPattern2.bodies == null) continue;
                n13 = n % mhnPattern2.bodies.getPeriod(i + 1);
                int n25 = mhnPattern2.bodies.getNumberOfPositions(i + 1, n13);
                for (int j = 0; j < n25; ++j) {
                    JMLPosition jMLPosition = mhnPattern2.bodies.getPosition(i + 1, n13, j);
                    if (jMLPosition == null) continue;
                    jMLPosition.setT(((double)n + (double)j / (double)n25) / mhnPattern2.bps);
                    jMLPattern.addPosition(jMLPosition);
                }
            }
        }
        for (n = 0; n < mhnPattern2.getNumberOfJugglers(); ++n) {
            for (int i = 0; i < 2; ++i) {
                if (blArray[n][i]) continue;
                JMLEvent jMLEvent = new JMLEvent();
                jMLEvent.setLocalCoordinate(new Coordinate(i == 0 ? 25.0 : -25.0, 0.0, 0.0));
                jMLEvent.setT(-1.0);
                jMLEvent.setHand(n + 1, i == 0 ? 2 : 1);
                jMLEvent.calcpos = false;
                jMLPattern.addEvent(jMLEvent);
            }
        }
        for (n = 0; n < jMLPattern.getNumberOfSymmetries(); ++n) {
            Permutation permutation = jMLPattern.getSymmetry(n).getPathPerm();
            for (int i = 0; i < mhnPattern2.getNumberOfPaths(); ++i) {
                if (!blArray2[i]) continue;
                for (int j = 1; j < permutation.getOrder(i + 1); ++j) {
                    blArray2[permutation.getMapping((int)(i + 1), (int)j) - 1] = true;
                }
            }
        }
        for (n = 0; n < mhnPattern2.getNumberOfPaths(); ++n) {
            int n26;
            int n27;
            if (blArray2[n]) continue;
            int n28 = 1;
            int n29 = 0;
            block61: for (int i = 0; i < mhnPattern2.getIndexes(); ++i) {
                for (n27 = 0; n27 < mhnPattern2.getNumberOfJugglers(); ++n27) {
                    for (int j = 0; j < 2; ++j) {
                        for (n26 = 0; n26 < mhnPattern2.getMaxOccupancy(); ++n26) {
                            mhnThrow mhnThrow12 = mhnThrowArray[n27][j][i][n26];
                            if (mhnThrow12 == null || mhnThrow12.pathnum != n + 1) continue;
                            n28 = j == 0 ? 2 : 1;
                            n29 = n27;
                            break block61;
                        }
                    }
                }
            }
            for (JMLEvent jMLEvent = jMLPattern.getEventList(); jMLEvent != null; jMLEvent = jMLEvent.getNext()) {
                if (jMLEvent.getHand() != n28 || jMLEvent.getJuggler() != n29 + 1) continue;
                jMLEvent.addTransition(new JMLTransition(4, n + 1, null, null));
                blArray2[n] = true;
                for (n27 = 0; n27 < jMLPattern.getNumberOfSymmetries(); ++n27) {
                    Permutation permutation = jMLPattern.getSymmetry(n27).getPathPerm();
                    for (n26 = 1; n26 < permutation.getOrder(n + 1); ++n26) {
                        blArray2[permutation.getMapping((int)(n + 1), (int)n26) - 1] = true;
                    }
                }
            }
        }
        jMLPattern.buildEventList();
        for (n = 1; n <= mhnPattern2.getNumberOfJugglers(); ++n) {
            for (int i = 0; i < 2; ++i) {
                JMLEvent jMLEvent;
                int n30 = i == 0 ? 2 : 1;
                JMLEvent jMLEvent2 = null;
                int n31 = 1;
                for (jMLEvent = jMLPattern.getEventList(); jMLEvent != null; jMLEvent = jMLEvent.getNext()) {
                    if (jMLEvent.getJuggler() != n || jMLEvent.getHand() != n30) continue;
                    if (jMLEvent.calcpos) {
                        n31 = 3;
                        continue;
                    }
                    switch (n31) {
                        case 1: {
                            n31 = 2;
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            if (jMLEvent2 != null) {
                                JMLEvent jMLEvent3 = jMLEvent;
                                double d10 = jMLEvent3.getT();
                                Coordinate coordinate = jMLEvent3.getLocalCoordinate();
                                double d11 = jMLEvent2.getT();
                                Coordinate coordinate5 = jMLEvent2.getLocalCoordinate();
                                for (jMLEvent = jMLEvent2.getNext(); jMLEvent != jMLEvent3; jMLEvent = jMLEvent.getNext()) {
                                    if (jMLEvent.getJuggler() != n || jMLEvent.getHand() != n30) continue;
                                    double d12 = jMLEvent.getT();
                                    d = coordinate5.x + (d12 - d11) * (coordinate.x - coordinate5.x) / (d10 - d11);
                                    double d13 = coordinate5.y + (d12 - d11) * (coordinate.y - coordinate5.y) / (d10 - d11);
                                    double d14 = coordinate5.z + (d12 - d11) * (coordinate.z - coordinate5.z) / (d10 - d11);
                                    jMLEvent.setLocalCoordinate(new Coordinate(d, d13, d14));
                                    jMLEvent.calcpos = false;
                                }
                            }
                            n31 = 2;
                        }
                    }
                    jMLEvent2 = jMLEvent;
                }
                for (jMLEvent = jMLPattern.getEventList(); jMLEvent != null; jMLEvent = jMLEvent.getNext()) {
                    if (jMLEvent.getJuggler() != n || jMLEvent.getHand() != n30 || !jMLEvent.calcpos) continue;
                    jMLEvent.setLocalCoordinate(new Coordinate(i == 0 ? 25.0 : -25.0, 0.0, 0.0));
                    jMLEvent.calcpos = false;
                }
            }
        }
        for (n = 0; n < mhnPattern2.getNumberOfPaths(); ++n) {
            boolean bl = false;
            boolean bl3 = false;
            int n32 = 0;
            int n33 = 0;
            JMLEvent jMLEvent = jMLPattern.getEventList();
            block74: while (jMLEvent != null) {
                JMLTransition jMLTransition = jMLEvent.getPathTransition(n + 1, 5);
                if (jMLTransition != null) {
                    switch (jMLTransition.getType()) {
                        case 1: {
                            if (!bl3 && !bl) {
                                bl = true;
                                n32 = jMLEvent.getJuggler();
                                n33 = jMLEvent.getHand();
                                jMLEvent = jMLPattern.getEventList();
                                continue block74;
                            }
                            bl = false;
                            break;
                        }
                        case 2: 
                        case 3: {
                            bl = true;
                            n32 = jMLEvent.getJuggler();
                            n33 = jMLEvent.getHand();
                            break;
                        }
                        case 4: {
                            if (!bl3 && !bl) {
                                bl = true;
                                n32 = jMLEvent.getJuggler();
                                n33 = jMLEvent.getHand();
                                jMLEvent = jMLPattern.getEventList();
                                continue block74;
                            }
                            bl = true;
                            n32 = jMLEvent.getJuggler();
                            n33 = jMLEvent.getHand();
                        }
                    }
                    bl3 = true;
                } else if (bl && jMLEvent.getJuggler() == n32 && jMLEvent.getHand() == n33 && jMLEvent.isMaster()) {
                    jMLEvent.addTransition(new JMLTransition(4, n + 1, null, null));
                }
                jMLEvent = jMLEvent.getNext();
            }
        }
        return jMLPattern;
    }

    protected static double calcBps(mhnPattern mhnPattern2) {
        double d = 0.0;
        mhnThrow[][][][] mhnThrowArray = mhnPattern2.getThrows();
        int n = 0;
        for (int i = 0; i < mhnPattern2.getPeriod(); ++i) {
            for (int j = 0; j < mhnPattern2.getNumberOfJugglers(); ++j) {
                for (int k = 0; k < 2; ++k) {
                    for (int i2 = 0; i2 < mhnPattern2.getMaxOccupancy(); ++i2) {
                        int n2;
                        mhnThrow mhnThrow2 = mhnThrowArray[j][k][i][i2];
                        if (mhnThrow2 == null || (n2 = mhnThrow2.targetindex - i) <= 2) continue;
                        d += throwspersec[n2 > 9 ? 9 : n2];
                        ++n;
                    }
                }
            }
        }
        d = n > 0 ? (d /= (double)n) : 2.0;
        return d;
    }
}

