/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jugglinglab.jml.JMLNode;
import jugglinglab.util.JuggleException;
import jugglinglab.util.JuggleExceptionInternal;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class JMLParser
extends DefaultHandler {
    protected boolean patternStarted = false;
    protected boolean patternFinished = false;
    protected JMLNode rootNode;
    protected JMLNode currentNode;
    protected static final boolean saxdebug = false;
    public static final int JML_INVALID = 0;
    public static final int JML_PATTERN = 1;
    public static final int JML_LIST = 2;

    public void parse(Reader reader) throws SAXException, IOException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setValidating(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(new InputSource(reader), (DefaultHandler)this);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException.getMessage());
        }
    }

    public InputSource resolveEntity(String string, String string2) {
        if (string2.equalsIgnoreCase("file://jml.dtd")) {
            return new InputSource(new StringReader("<!ELEMENT jml (pattern|patternlist)>\n<!ATTLIST jml\n          version  CDATA   \"1.0\">\n\n<!ELEMENT pattern (title?,prop*,setup,symmetry+,(event|position)*)>\n\n<!ELEMENT title (#PCDATA)>\n\n<!ELEMENT prop EMPTY>\n<!ATTLIST prop\n          type     CDATA   \"ball\"\n          mod      CDATA   #IMPLIED>\n\n<!ELEMENT setup EMPTY>\n<!ATTLIST setup\n          jugglers CDATA   \"1\"\n          paths    CDATA   #REQUIRED\n          props    CDATA   #IMPLIED>\n\n<!ELEMENT symmetry EMPTY>\n<!ATTLIST symmetry\n          type     CDATA   #REQUIRED\n          jperm    CDATA   #IMPLIED\n          pperm    CDATA   #REQUIRED\n          delay    CDATA   #IMPLIED>\n\n<!ELEMENT event (throw|catch|softcatch|holding)*>\n<!ATTLIST event\n          x        CDATA   #REQUIRED\n          y        CDATA   \"0.0\"\n          z        CDATA   \"0.0\"\n          t        CDATA   #REQUIRED\n          hand     CDATA   #REQUIRED>\n\n<!ELEMENT throw EMPTY>\n<!ATTLIST throw\n          path     CDATA   #REQUIRED\n          type     CDATA   \"toss\"\n          mod      CDATA   #IMPLIED>\n\n<!ELEMENT catch EMPTY>\n<!ATTLIST catch\n          path     CDATA   #REQUIRED>\n\n<!ELEMENT softcatch EMPTY>\n<!ATTLIST softcatch\n          path     CDATA   #REQUIRED>\n\n<!ELEMENT holding EMPTY>\n<!ATTLIST holding\n          path     CDATA   #REQUIRED>\n\n<!ELEMENT position EMPTY>\n<!ATTLIST position\n          x        CDATA   #REQUIRED\n          y        CDATA   #REQUIRED\n          z        CDATA   \"100.0\"\n          t        CDATA   #REQUIRED\n          angle    CDATA   \"0.0\"\n          juggler  CDATA   \"1\">\n\n<!ELEMENT patternlist (title?,line*)>\n\n<!ELEMENT line (#PCDATA|pattern)*>\n<!ATTLIST line\n          display    CDATA   #REQUIRED\n          animprefs  CDATA   #IMPLIED\n          notation   CDATA   #IMPLIED>\n"));
        }
        return null;
    }

    public void notationDecl(String string, String string2, String string3) {
    }

    public void unparsedEntityDecl(String string, String string2, String string3, String string4) {
    }

    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
    }

    public void startDocument() throws SAXException {
        try {
            this.startJMLPattern();
        }
        catch (JuggleException juggleException) {
            throw new SAXException(juggleException.getMessage());
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.endJMLPattern();
        }
        catch (JuggleException juggleException) {
            throw new SAXException(juggleException.getMessage());
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        try {
            this.startJMLElement(string3);
            for (int i = 0; i < attributes.getLength(); ++i) {
                this.addJMLAttribute(attributes.getQName(i), attributes.getValue(i));
            }
        }
        catch (JuggleException juggleException) {
            throw new SAXException(juggleException.getMessage());
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        try {
            this.endJMLElement(string3);
        }
        catch (JuggleException juggleException) {
            throw new SAXException(juggleException.getMessage());
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        try {
            this.addJMLText(new String(cArray, n, n2));
        }
        catch (JuggleException juggleException) {
            throw new SAXException(juggleException.getMessage());
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public void processingInstruction(String string, String string2) {
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    private static void display(char[] cArray, int n, int n2) {
    }

    public void startJMLPattern() throws JuggleExceptionInternal {
        if (this.patternStarted) {
            throw new JuggleExceptionInternal("startJMLPattern(): pattern already started");
        }
        this.patternStarted = true;
    }

    public void startJMLElement(String string) throws JuggleExceptionInternal {
        if (!this.patternStarted) {
            throw new JuggleExceptionInternal("startJMLEleent(): pattern not started");
        }
        if (this.patternFinished) {
            throw new JuggleExceptionInternal("startJMLElement(): pattern already finished");
        }
        if (this.currentNode == null && this.rootNode != null) {
            throw new JuggleExceptionInternal("startJMLElement(): can only have one root element");
        }
        JMLNode jMLNode = new JMLNode(string);
        if (this.currentNode != null) {
            this.currentNode.appendChild(jMLNode);
            this.currentNode = jMLNode;
        } else {
            this.rootNode = this.currentNode = jMLNode;
        }
    }

    public void endJMLElement(String string) throws JuggleExceptionInternal {
        if (!this.patternStarted) {
            throw new JuggleExceptionInternal("endJMLElement(): pattern not started");
        }
        if (this.patternFinished) {
            throw new JuggleExceptionInternal("endJMLElement(): pattern already finished");
        }
        if (this.currentNode == null) {
            throw new JuggleExceptionInternal("endJMLElement(): no correspanding startElement()");
        }
        this.currentNode = this.currentNode.getParentNode();
    }

    public void addJMLAttribute(String string, String string2) throws JuggleExceptionInternal {
        if (!this.patternStarted) {
            throw new JuggleExceptionInternal("addJMLAttribute(): pattern not started");
        }
        if (this.patternFinished) {
            throw new JuggleExceptionInternal("addJMLAttribute(): pattern already finished");
        }
        if (this.currentNode == null) {
            throw new JuggleExceptionInternal("addJMLAttribute(): no element to add to");
        }
        this.currentNode.addAttribute(string, string2);
    }

    public void addJMLText(String string) throws JuggleExceptionInternal {
        if (!this.patternStarted) {
            throw new JuggleExceptionInternal("addJMLText(): pattern not started");
        }
        if (this.patternFinished) {
            throw new JuggleExceptionInternal("addJMLText(): pattern already finished");
        }
        if (this.currentNode == null) {
            throw new JuggleExceptionInternal("addJMLText(): no element to add to");
        }
        String string2 = null;
        string2 = this.currentNode.getNodeValue() == null ? string : this.currentNode.getNodeValue() + string;
        this.currentNode.setNodeValue(string2);
    }

    public void endJMLPattern() throws JuggleExceptionInternal {
        if (!this.patternStarted) {
            throw new JuggleExceptionInternal("endJMLPattern(): pattern not started");
        }
        if (this.patternFinished) {
            throw new JuggleExceptionInternal("endJMLPattern(): pattern already finished");
        }
        if (this.rootNode == null) {
            throw new JuggleExceptionInternal("endJMLPattern(): empty pattern");
        }
        if (this.currentNode != null) {
            throw new JuggleExceptionInternal("endJMLPattern(): missing endElement()");
        }
        this.patternFinished = true;
    }

    public JMLNode getTree() {
        return this.rootNode;
    }

    public int getFileType() {
        if (this.rootNode.getNodeType().equalsIgnoreCase("jml")) {
            if (this.rootNode.getNumberOfChildren() == 1) {
                String string = this.rootNode.getChildNode(0).getNodeType();
                if (string.equalsIgnoreCase("pattern")) {
                    return 1;
                }
                if (string.equalsIgnoreCase("patternlist")) {
                    return 2;
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }
}

