/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.generator;

import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import jugglinglab.generator.GeneratorTarget;
import jugglinglab.util.JLLocale;
import jugglinglab.util.JuggleExceptionUser;

public abstract class Generator {
    static ResourceBundle guistrings = JLLocale.getBundle("GUIStrings");
    static ResourceBundle errorstrings = JLLocale.getBundle("ErrorStrings");
    public static final String[] builtinGenerators = new String[]{"siteswap"};

    public static Generator getGenerator(String string) {
        try {
            Object obj = Class.forName("jugglinglab.generator." + string.toLowerCase() + "Generator").newInstance();
            if (!(obj instanceof Generator)) {
                return null;
            }
            return (Generator)obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
    }

    public abstract String getStartupMessage();

    public abstract JPanel getGeneratorControls();

    public abstract void resetGeneratorControls();

    public abstract void initGenerator() throws JuggleExceptionUser;

    public abstract void initGenerator(String[] var1) throws JuggleExceptionUser;

    public void initGenerator(String string) throws JuggleExceptionUser {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \n");
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        this.initGenerator(stringArray);
    }

    public abstract int runGenerator(GeneratorTarget var1);

    public abstract int runGenerator(GeneratorTarget var1, int var2, double var3) throws JuggleExceptionUser;
}

