/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.curve;

import jugglinglab.curve.Curve;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;

public class splineCurve
extends Curve {
    protected int n;
    protected double[][] a;
    protected double[][] b;
    protected double[][] c;
    protected double[][] d;
    protected double[] durations;
    public static final int rmsaccel = 0;
    public static final int continaccel = 1;
    public static final int rmsvel = 2;

    public void initCurve(String string) {
    }

    public void calcCurve() throws JuggleExceptionInternal {
        int n;
        boolean bl = this.start_velocity != null && this.end_velocity != null;
        this.n = this.numpoints - 1;
        if (this.n < 1) {
            throw new JuggleExceptionInternal("splineCurve error 1");
        }
        this.a = new double[this.n][3];
        this.b = new double[this.n][3];
        this.c = new double[this.n][3];
        this.d = new double[this.n][3];
        this.durations = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.durations[n] = this.times[n + 1] - this.times[n];
            if (!(this.durations[n] < 0.0)) continue;
            throw new JuggleExceptionInternal("splineCurve error 2");
        }
        double[] dArray = new double[this.n + 1];
        double[] dArray2 = new double[this.n + 1];
        for (n = 0; n < 3; ++n) {
            int n2;
            for (n2 = 0; n2 < this.n + 1; ++n2) {
                dArray[n2] = this.positions[n2].getIndex(n);
            }
            if (bl) {
                dArray2[0] = this.start_velocity.getIndex(n);
                dArray2[this.n] = this.end_velocity.getIndex(n);
                jugglinglab.curve.splineCurve.findvels_edges_known(dArray2, dArray, this.durations, this.n, 0);
            } else {
                jugglinglab.curve.splineCurve.findvels_edges_unknown(dArray2, dArray, this.durations, this.n, 0);
            }
            for (n2 = 0; n2 < this.n; ++n2) {
                this.a[n2][n] = dArray[n2];
                this.b[n2][n] = dArray2[n2];
                double d = this.durations[n2];
                this.c[n2][n] = (3.0 * (dArray[n2 + 1] - dArray[n2]) - (dArray2[n2 + 1] + 2.0 * dArray2[n2]) * d) / (d * d);
                this.d[n2][n] = (-2.0 * (dArray[n2 + 1] - dArray[n2]) + (dArray2[n2 + 1] + dArray2[n2]) * d) / (d * d * d);
            }
        }
    }

    protected static void findvels_edges_known(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) throws JuggleExceptionInternal {
        if (n < 2) {
            return;
        }
        double[] dArray4 = new double[n - 1];
        double[] dArray5 = new double[n - 1];
        double[] dArray6 = new double[n - 1];
        block4: for (int i = 0; i < n - 1; ++i) {
            switch (n2) {
                case 0: 
                case 1: {
                    dArray4[i] = 2.0 / dArray3[i + 1] + 2.0 / dArray3[i];
                    dArray5[i] = 1.0 / dArray3[i + 1];
                    dArray6[i] = 3.0 * (dArray2[i + 2] - dArray2[i + 1]) / (dArray3[i + 1] * dArray3[i + 1]) + 3.0 * (dArray2[i + 1] - dArray2[i]) / (dArray3[i] * dArray3[i]);
                    if (i == 0) {
                        dArray6[0] = dArray6[0] - dArray[0] / dArray3[0];
                    }
                    if (i != n - 2) continue block4;
                    int n3 = n - 2;
                    dArray6[n3] = dArray6[n3] - dArray[n] / dArray3[n - 1];
                    continue block4;
                }
                case 2: {
                    dArray4[i] = 4.0 * (dArray3[i] + dArray3[i + 1]);
                    dArray5[i] = -dArray3[i + 1];
                    dArray6[i] = 3.0 * (dArray2[i + 2] - dArray2[i]);
                    if (i == 0) {
                        dArray6[0] = dArray6[0] + dArray[0] * dArray3[0];
                    }
                    if (i != n - 2) continue block4;
                    int n4 = n - 2;
                    dArray6[n4] = dArray6[n4] + dArray[n] * dArray3[n - 1];
                }
            }
        }
        double[] dArray7 = new double[n - 1];
        jugglinglab.curve.splineCurve.tridag(dArray5, dArray4, dArray5, dArray6, dArray7, n - 1);
        for (int i = 0; i < n - 1; ++i) {
            dArray[i + 1] = dArray7[i];
        }
    }

    protected static void findvels_edges_unknown(double[] dArray, double[] dArray2, double[] dArray3, int n, int n2) throws JuggleExceptionInternal {
        if (n < 2) {
            return;
        }
        double[] dArray4 = new double[n];
        double[] dArray5 = new double[n];
        double d = 0.0;
        double[] dArray6 = new double[n];
        block4: for (int i = 0; i < n; ++i) {
            switch (n2) {
                case 0: 
                case 1: {
                    if (i == 0) {
                        dArray4[0] = 2.0 / dArray3[n - 1] + 2.0 / dArray3[0];
                        d = 1.0 / dArray3[n - 1];
                        dArray6[0] = 3.0 * (dArray2[1] - dArray2[0]) / (dArray3[0] * dArray3[0]) + 3.0 * (dArray2[n] - dArray2[n - 1]) / (dArray3[n - 1] * dArray3[n - 1]);
                    } else {
                        dArray4[i] = 2.0 / dArray3[i - 1] + 2.0 / dArray3[i];
                        dArray6[i] = 3.0 * (dArray2[i + 1] - dArray2[i]) / (dArray3[i] * dArray3[i]) + 3.0 * (dArray2[i] - dArray2[i - 1]) / (dArray3[i - 1] * dArray3[i - 1]);
                    }
                    dArray5[i] = 1.0 / dArray3[i];
                    continue block4;
                }
                case 2: {
                    if (i == 0) {
                        dArray4[0] = 4.0 * (dArray3[n - 1] + dArray3[0]);
                        d = -dArray3[n - 1];
                        dArray6[0] = 3.0 * (dArray2[n] - dArray2[n - 1] + dArray2[1] - dArray2[0]);
                    } else {
                        dArray4[i] = 4.0 * (dArray3[i - 1] + dArray3[i]);
                        dArray6[i] = 3.0 * (dArray2[i + 1] - dArray2[i - 1]);
                    }
                    dArray5[i] = -dArray3[i];
                }
            }
        }
        jugglinglab.curve.splineCurve.tridag(dArray5, dArray4, dArray5, dArray6, dArray, n);
        if (n > 2) {
            double[] dArray7 = new double[n];
            dArray6[0] = d;
            for (int i = 1; i < n; ++i) {
                dArray6[i] = 0.0;
            }
            jugglinglab.curve.splineCurve.tridag(dArray5, dArray4, dArray5, dArray6, dArray7, n);
            double[] dArray8 = new double[n];
            dArray6[n - 1] = d;
            for (int i = 0; i < n - 1; ++i) {
                dArray6[i] = 0.0;
            }
            jugglinglab.curve.splineCurve.tridag(dArray5, dArray4, dArray5, dArray6, dArray8, n);
            double d2 = 1.0 + dArray8[0];
            double d3 = -dArray8[n - 1];
            double d4 = -dArray7[0];
            double d5 = 1.0 + dArray7[n - 1];
            double d6 = d2 * d5 - d3 * d4;
            double d7 = (d2 /= d6) * dArray[n - 1] + (d3 /= d6) * dArray[0];
            double d8 = (d4 /= d6) * dArray[n - 1] + (d5 /= d6) * dArray[0];
            for (int i = 0; i < n; ++i) {
                int n3 = i;
                dArray[n3] = dArray[n3] - (dArray7[i] * d7 + dArray8[i] * d8);
            }
        }
        dArray[n] = dArray[0];
    }

    protected static void tridag(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, int n) throws JuggleExceptionInternal {
        int n2;
        double[] dArray6 = new double[n];
        if (dArray2[0] == 0.0) {
            throw new JuggleExceptionInternal("Error 1 in TRIDAG");
        }
        double d = dArray2[0];
        dArray5[0] = dArray4[0] / d;
        for (n2 = 1; n2 < n; ++n2) {
            dArray6[n2] = dArray3[n2 - 1] / d;
            d = dArray2[n2] - dArray[n2 - 1] * dArray6[n2];
            if (d == 0.0) {
                throw new JuggleExceptionInternal("Error 2 in TRIDAG");
            }
            dArray5[n2] = (dArray4[n2] - dArray[n2 - 1] * dArray5[n2 - 1]) / d;
        }
        for (n2 = n - 1; n2 > 0; --n2) {
            int n3 = n2 - 1;
            dArray5[n3] = dArray5[n3] - dArray6[n2] * dArray5[n2];
        }
    }

    public void getCoordinate(double d, Coordinate coordinate) {
        int n;
        if (d < this.times[0] || d > this.times[this.n]) {
            return;
        }
        for (n = 0; n < this.n && !(d <= this.times[n + 1]); ++n) {
        }
        if (n == this.n) {
            n = this.n - 1;
        }
        coordinate.setCoordinate(this.a[n][0] + (d -= this.times[n]) * (this.b[n][0] + d * (this.c[n][0] + d * this.d[n][0])), this.a[n][1] + d * (this.b[n][1] + d * (this.c[n][1] + d * this.d[n][1])), this.a[n][2] + d * (this.b[n][2] + d * (this.c[n][2] + d * this.d[n][2])));
    }

    protected Coordinate getMax2(double d, double d2) {
        if (d2 < this.times[0] || d > this.times[this.n]) {
            return null;
        }
        Coordinate coordinate = null;
        double d3 = Math.max(this.times[0], d);
        double d4 = Math.min(this.times[this.n], d2);
        coordinate = this.check(coordinate, d3, true);
        coordinate = this.check(coordinate, d4, true);
        for (int i = 0; i <= this.n; ++i) {
            double d5;
            double d6;
            if (d3 <= this.times[i] && this.times[i] <= d4) {
                coordinate = this.check(coordinate, this.times[i], true);
            }
            if (i == this.n || !((d6 = Math.max(d3, this.times[i])) < (d5 = Math.min(d4, this.times[i + 1])))) continue;
            coordinate = this.check(coordinate, d6, true);
            coordinate = this.check(coordinate, d5, true);
            for (int j = 0; j < 3; ++j) {
                double d7;
                if (Math.abs(this.d[i][j]) > 1.0E-6) {
                    double d8;
                    d7 = this.c[i][j] * this.c[i][j] - 3.0 * this.b[i][j] * this.d[i][j];
                    if (!(d7 > 0.0) || !(d6 < (d8 = this.times[i] + (-this.c[i][j] - Math.sqrt(d7)) / (3.0 * this.d[i][j]))) || !(d8 < d5)) continue;
                    coordinate = this.check(coordinate, d8, true);
                    continue;
                }
                if (!(this.c[i][j] < 0.0)) continue;
                d7 = -this.b[i][j] / (2.0 * this.c[i][j]);
                if (!(d6 < (d7 += this.times[i])) || !(d7 < d5)) continue;
                coordinate = this.check(coordinate, d7, true);
            }
        }
        return coordinate;
    }

    protected Coordinate getMin2(double d, double d2) {
        if (d2 < this.times[0] || d > this.times[this.n]) {
            return null;
        }
        Coordinate coordinate = null;
        double d3 = Math.max(this.times[0], d);
        double d4 = Math.min(this.times[this.n], d2);
        coordinate = this.check(coordinate, d3, false);
        coordinate = this.check(coordinate, d4, false);
        for (int i = 0; i <= this.n; ++i) {
            double d5;
            double d6;
            if (d3 <= this.times[i] && this.times[i] <= d4) {
                coordinate = this.check(coordinate, this.times[i], false);
            }
            if (i == this.n || !((d6 = Math.max(d3, this.times[i])) < (d5 = Math.min(d4, this.times[i + 1])))) continue;
            coordinate = this.check(coordinate, d6, false);
            coordinate = this.check(coordinate, d5, false);
            for (int j = 0; j < 3; ++j) {
                double d7;
                if (Math.abs(this.d[i][j]) > 1.0E-6) {
                    double d8;
                    d7 = this.c[i][j] * this.c[i][j] - 3.0 * this.b[i][j] * this.d[i][j];
                    if (!(d7 > 0.0) || !(d6 < (d8 = this.times[i] + (-this.c[i][j] + Math.sqrt(d7)) / (3.0 * this.d[i][j]))) || !(d8 < d5)) continue;
                    coordinate = this.check(coordinate, d8, false);
                    continue;
                }
                if (!(this.c[i][j] > 0.0)) continue;
                d7 = -this.b[i][j] / (2.0 * this.c[i][j]);
                if (!(d6 < (d7 += this.times[i])) || !(d7 < d5)) continue;
                coordinate = this.check(coordinate, d7, false);
            }
        }
        return coordinate;
    }
}

