/*
 * Copyright (C) 2007, 2008, 2009 Patrick Balleux, Nicolas Cardoso De Castro
 * (nicolas_cardoso@users.sourceforge.net), Daniel Žalar (danizmax@gmail.com)
 *
 * This file is part of JSymphonic program.
 *
 * JSymphonic is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * JSymphonic is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with JSymphonic. If not, see <http://www.gnu.org/licenses/>.
 *
 *****
 *
 * TrackInfoWindow.java
 *
 * Created on May 10, 2008, 12:42 PM
 * 
 */

package org.danizmax.jsymphonic.gui.TrackInfo;

import java.io.IOException;
import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.naurd.media.jsymphonic.title.Title;

/**
 * @author  danizmax - Daniel Žalar (danizmax@gmail.com)
 */
public class TrackInfoWindow extends javax.swing.JFrame {

     private static Logger logger = Logger.getLogger("org.danizmax.jsymphonic.gui.TrackInfo.TrackInfoWindow");
     private NumberFormat nf = NumberFormat.getInstance();
    
   /**
    * Creates new form TrackInfoWindow  
    * @param trackobject the track object that represents the file
    */
    public TrackInfoWindow(Title trackobject) {
        initComponents();
        nf.setMinimumIntegerDigits(2);
        nf.setMaximumIntegerDigits(10);
        fillFields(trackobject);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        summaryPanel = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        summaryLabel = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        lenghtLabel = new javax.swing.JLabel();
        bitrateLabel = new javax.swing.JLabel();
        samplerateLabel = new javax.swing.JLabel();
        samplerateTextLabel = new javax.swing.JLabel();
        bitrateTextLabel = new javax.swing.JLabel();
        lenghtTextLabel = new javax.swing.JLabel();
        sizeLabel = new javax.swing.JLabel();
        sizeTextLabel = new javax.swing.JLabel();
        formatTextLabel = new javax.swing.JLabel();
        formatLabel = new javax.swing.JLabel();
        locationLabel = new javax.swing.JLabel();
        locationTextLabel = new javax.swing.JLabel();
        id3Panel = new javax.swing.JPanel();
        artistLabel1 = new javax.swing.JLabel();
        titleLabel = new javax.swing.JLabel();
        albumLabel = new javax.swing.JLabel();
        yearLabel = new javax.swing.JLabel();
        trackLabel = new javax.swing.JLabel();
        diskLabel = new javax.swing.JLabel();
        genreLabel = new javax.swing.JLabel();
        artistTextField = new javax.swing.JTextField();
        titleTextField = new javax.swing.JTextField();
        albumTextField = new javax.swing.JTextField();
        yearTextField = new javax.swing.JTextField();
        trackTextField = new javax.swing.JTextField();
        diskTextField = new javax.swing.JTextField();
        genreTextField = new javax.swing.JTextField();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setName("Form"); // NOI18N
        setResizable(false);

        okButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/ok.png"))); // NOI18N
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("localization/misc"); // NOI18N
        okButton.setText(bundle.getString("global.OK")); // NOI18N
        okButton.setName("okButton"); // NOI18N
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        cancelButton.setIcon(new javax.swing.ImageIcon(getClass().getResource("/org/danizmax/jsymphonic/resources/cancel.png"))); // NOI18N
        cancelButton.setText(bundle.getString("global.Cancel")); // NOI18N
        cancelButton.setName("cancelButton"); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        jTabbedPane1.setMinimumSize(new java.awt.Dimension(650, 310));
        jTabbedPane1.setName("jTabbedPane1"); // NOI18N

        summaryPanel.setName("summaryPanel"); // NOI18N

        jPanel1.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel1.setName("jPanel1"); // NOI18N

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 100, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 100, Short.MAX_VALUE)
        );

        summaryLabel.setName("summaryLabel"); // NOI18N

        jPanel2.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jPanel2.setName("jPanel2"); // NOI18N

        lenghtLabel.setFont(new java.awt.Font("Sans Serif", 1, 12)); // NOI18N
        java.util.ResourceBundle bundle1 = java.util.ResourceBundle.getBundle("localization/trackinfowindow"); // NOI18N
        lenghtLabel.setText(bundle1.getString("TrackInfoWindow.lenghtLabel.text")); // NOI18N
        lenghtLabel.setName("lenghtLabel"); // NOI18N

        bitrateLabel.setFont(new java.awt.Font("Sans Serif", 1, 12));
        bitrateLabel.setText(bundle1.getString("TrackInfoWindow.bitrateLabel.text")); // NOI18N
        bitrateLabel.setName("bitrateLabel"); // NOI18N

        samplerateLabel.setFont(new java.awt.Font("Sans Serif", 1, 12));
        samplerateLabel.setText(bundle1.getString("TrackInfoWindow.samplerateLabel.text")); // NOI18N
        samplerateLabel.setName("samplerateLabel"); // NOI18N

        samplerateTextLabel.setName("samplerateTextLabel"); // NOI18N

        bitrateTextLabel.setName("bitrateTextLabel"); // NOI18N

        lenghtTextLabel.setName("lenghtTextLabel"); // NOI18N

        sizeLabel.setFont(new java.awt.Font("Sans Serif", 1, 12));
        sizeLabel.setText(bundle1.getString("TrackInfoWindow.sizeLabel.text")); // NOI18N
        sizeLabel.setName("sizeLabel"); // NOI18N

        sizeTextLabel.setName("sizeTextLabel"); // NOI18N

        formatTextLabel.setName("formatTextLabel"); // NOI18N

        formatLabel.setFont(new java.awt.Font("Sans Serif", 1, 12));
        formatLabel.setText(bundle1.getString("TrackInfoWindow.formatLabel.text")); // NOI18N
        formatLabel.setName("formatLabel"); // NOI18N

        locationLabel.setFont(new java.awt.Font("Sans Serif", 1, 12)); // NOI18N
        locationLabel.setText(bundle1.getString("TrackInfoWindow.locationLabel.text")); // NOI18N
        locationLabel.setName("locationLabel"); // NOI18N

        locationTextLabel.setName("locationTextLabel"); // NOI18N

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(formatLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 114, Short.MAX_VALUE)
                    .add(sizeLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 114, Short.MAX_VALUE)
                    .add(samplerateLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 114, Short.MAX_VALUE)
                    .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                        .add(org.jdesktop.layout.GroupLayout.TRAILING, bitrateLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .add(org.jdesktop.layout.GroupLayout.TRAILING, lenghtLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 113, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(locationLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 114, Short.MAX_VALUE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(bitrateTextLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 473, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, lenghtTextLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 473, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, samplerateTextLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 473, Short.MAX_VALUE)
                    .add(sizeTextLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 473, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, formatTextLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 473, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, locationTextLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 473, Short.MAX_VALUE))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(jPanel2Layout.createSequentialGroup()
                        .add(1, 1, 1)
                        .add(lenghtTextLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .add(lenghtLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(bitrateTextLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(bitrateLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(samplerateTextLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(samplerateLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(sizeTextLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 16, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(sizeLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(formatLabel)
                    .add(formatTextLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 16, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(locationTextLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 16, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(locationLabel))
                .addContainerGap())
        );

        org.jdesktop.layout.GroupLayout summaryPanelLayout = new org.jdesktop.layout.GroupLayout(summaryPanel);
        summaryPanel.setLayout(summaryPanelLayout);
        summaryPanelLayout.setHorizontalGroup(
            summaryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(summaryPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(summaryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(summaryPanelLayout.createSequentialGroup()
                        .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(summaryLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 507, Short.MAX_VALUE)))
                .addContainerGap())
        );
        summaryPanelLayout.setVerticalGroup(
            summaryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(summaryPanelLayout.createSequentialGroup()
                .add(summaryPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(summaryPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .add(jPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(summaryPanelLayout.createSequentialGroup()
                        .add(28, 28, 28)
                        .add(summaryLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 21, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(13, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab(bundle1.getString("TrackInfoWindow.summaryPanel.TabConstraints.tabTitle"), summaryPanel); // NOI18N

        id3Panel.setName("id3Panel"); // NOI18N

        artistLabel1.setText(bundle1.getString("TrackInfoWindow.artistLabel1.text")); // NOI18N
        artistLabel1.setName("artistLabel1"); // NOI18N

        titleLabel.setText(bundle1.getString("TrackInfoWindow.titleLabel.text")); // NOI18N
        titleLabel.setName("titleLabel"); // NOI18N

        albumLabel.setText(bundle1.getString("TrackInfoWindow.albumLabel.text")); // NOI18N
        albumLabel.setName("albumLabel"); // NOI18N

        yearLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        yearLabel.setText(bundle1.getString("TrackInfoWindow.yearLabel.text")); // NOI18N
        yearLabel.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        yearLabel.setName("yearLabel"); // NOI18N

        trackLabel.setText(bundle1.getString("TrackInfoWindow.trackLabel.text")); // NOI18N
        trackLabel.setName("trackLabel"); // NOI18N

        diskLabel.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        diskLabel.setText(bundle1.getString("TrackInfoWindow.diskLabel.text")); // NOI18N
        diskLabel.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        diskLabel.setName("diskLabel"); // NOI18N

        genreLabel.setText(bundle1.getString("TrackInfoWindow.genreLabel.text")); // NOI18N
        genreLabel.setName("genreLabel"); // NOI18N

        artistTextField.setName("artistTextField"); // NOI18N

        titleTextField.setName("titleTextField"); // NOI18N

        albumTextField.setName("albumTextField"); // NOI18N

        yearTextField.setMaximumSize(new java.awt.Dimension(2147483647, 80));
        yearTextField.setMinimumSize(new java.awt.Dimension(4, 80));
        yearTextField.setName("yearTextField"); // NOI18N

        trackTextField.setName("trackTextField"); // NOI18N

        diskTextField.setName("diskTextField"); // NOI18N

        genreTextField.setName("genreTextField"); // NOI18N

        org.jdesktop.layout.GroupLayout id3PanelLayout = new org.jdesktop.layout.GroupLayout(id3Panel);
        id3Panel.setLayout(id3PanelLayout);
        id3PanelLayout.setHorizontalGroup(
            id3PanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(id3PanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(id3PanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(trackLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(genreLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(artistLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 105, Short.MAX_VALUE)
                    .add(albumLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(titleLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .add(23, 23, 23)
                .add(id3PanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(genreTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 499, Short.MAX_VALUE)
                    .add(albumTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 499, Short.MAX_VALUE)
                    .add(titleTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 499, Short.MAX_VALUE)
                    .add(artistTextField, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 499, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, id3PanelLayout.createSequentialGroup()
                        .add(trackTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 93, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(diskLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 80, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(diskTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 85, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(yearLabel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 99, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                        .add(yearTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 88, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        id3PanelLayout.setVerticalGroup(
            id3PanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(id3PanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(id3PanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(artistLabel1)
                    .add(artistTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(id3PanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(titleLabel)
                    .add(titleTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 19, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(id3PanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(albumLabel)
                    .add(albumTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 19, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(id3PanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(genreLabel)
                    .add(genreTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 19, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(id3PanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(trackLabel)
                    .add(trackTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 19, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(diskLabel)
                    .add(diskTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 19, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(yearLabel)
                    .add(yearTextField, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 19, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(153, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab(bundle1.getString("TrackInfoWindow.id3Panel.TabConstraints.tabTitle"), id3Panel); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jTabbedPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 650, Short.MAX_VALUE)
                    .add(layout.createSequentialGroup()
                        .add(okButton)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(cancelButton)))
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {cancelButton, okButton}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(jTabbedPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 311, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 18, Short.MAX_VALUE)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(cancelButton)
                    .add(okButton))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void fillFields(Title trackObject){
        artistTextField.setText(trackObject.getArtist());
        titleTextField.setText(trackObject.getTitle());
        albumTextField.setText(trackObject.getAlbum());
        genreTextField.setText(trackObject.getGenre());
        trackTextField.setText(String.valueOf(trackObject.getTitleNumber()));
        //diskTextField.setText(trackObject.get);
        yearTextField.setText(String.valueOf(trackObject.getYear()));
        
        summaryLabel.setText("'"+trackObject.getTitle() + "' " + java.util.ResourceBundle.getBundle("localization/trackinfowindow").getString("TrackInfoWindow.by") +" '"+ trackObject.getArtist() +"' "+ java.util.ResourceBundle.getBundle("localization/trackinfowindow").getString("TrackInfoWindow.on") +" '" + trackObject.getAlbum()+"'");
        this.setTitle(summaryLabel.getText());
        
        lenghtTextLabel.setText(longToTime(trackObject.getLength())); //TODO check if the method getLength() give a correct information!
        bitrateTextLabel.setText(String.valueOf(trackObject.getBitRate()) + " " + "kbps");
        samplerateTextLabel.setText(String.valueOf(trackObject.getFrequency()) + " " + "kHz");
        sizeTextLabel.setText(String.valueOf(trackObject.size()/1024) + " " + "kB");
        try {
            formatTextLabel.setText(trackObject.getFormatAsString());
            locationTextLabel.setText(trackObject.getSourceFile().getCanonicalPath());
        } catch (IOException ex) {
            Logger.getLogger(TrackInfoWindow.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    
    /** convert milliseconds to d+ HH:MM:SS
     * @param t time
     * @return returns date in the form d+ HH:MM:SS
     */
    private String longToTime(long t){
        int hours=0, minutes = 0, seconds =0, days =0;
        String out ="";
        while(t>=3600000){
            hours++;
            t -=3600000;
        }

        while(hours>=24){
            days++;
            hours-=24;
        }

        while(t>=60000){
            minutes++;
            t -=60000;
        }

        seconds=(int)t/1000;
        if(days>0){
            out = days+ " dni, " + nf.format(hours)+":"+nf.format(minutes)+":"+nf.format(seconds);
        }else{
            out = nf.format(hours)+":"+nf.format(minutes)+":"+nf.format(seconds);
        }

        return  out;
    }
    
private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
this.dispose();
}//GEN-LAST:event_okButtonActionPerformed

private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
this.dispose();
}//GEN-LAST:event_cancelButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel albumLabel;
    private javax.swing.JTextField albumTextField;
    private javax.swing.JLabel artistLabel1;
    private javax.swing.JTextField artistTextField;
    private javax.swing.JLabel bitrateLabel;
    private javax.swing.JLabel bitrateTextLabel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JLabel diskLabel;
    private javax.swing.JTextField diskTextField;
    private javax.swing.JLabel formatLabel;
    private javax.swing.JLabel formatTextLabel;
    private javax.swing.JLabel genreLabel;
    private javax.swing.JTextField genreTextField;
    private javax.swing.JPanel id3Panel;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JLabel lenghtLabel;
    private javax.swing.JLabel lenghtTextLabel;
    private javax.swing.JLabel locationLabel;
    private javax.swing.JLabel locationTextLabel;
    private javax.swing.JButton okButton;
    private javax.swing.JLabel samplerateLabel;
    private javax.swing.JLabel samplerateTextLabel;
    private javax.swing.JLabel sizeLabel;
    private javax.swing.JLabel sizeTextLabel;
    private javax.swing.JLabel summaryLabel;
    private javax.swing.JPanel summaryPanel;
    private javax.swing.JLabel titleLabel;
    private javax.swing.JTextField titleTextField;
    private javax.swing.JLabel trackLabel;
    private javax.swing.JTextField trackTextField;
    private javax.swing.JLabel yearLabel;
    private javax.swing.JTextField yearTextField;
    // End of variables declaration//GEN-END:variables

    
    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger aLogger) {
        logger = aLogger;
    }
    
    public static void setParentLogger(Logger aLogger) {
        logger.setParent(aLogger);
    }
}
