/*
 * Decompiled with CFR 0.152.
 */
package java.dyn;

import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wrappers {
    static final String PRIMITIVE_BITS_TABLE = "ZBCSFI  DJ";
    private static final HashMap<Object, Object[]> wrappers = new HashMap(20);

    private Wrappers() {
    }

    public static Class<?> asWrapperType(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (wrappers.isEmpty()) {
            Wrappers.fillWrappers();
        }
        Object[] objectArray = wrappers.get(clazz);
        assert (objectArray != null);
        return (Class)objectArray[0];
    }

    public static Class<?> asPrimitiveType(Class<?> clazz) {
        Object[] objectArray;
        if (clazz.isPrimitive()) {
            return clazz;
        }
        if (wrappers.isEmpty()) {
            Wrappers.fillWrappers();
        }
        if ((objectArray = wrappers.get(clazz)) == null) {
            return clazz;
        }
        return (Class)objectArray[1];
    }

    public static char basicTypeChar(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return 'L';
        }
        if (wrappers.isEmpty()) {
            Wrappers.fillWrappers();
        }
        Object[] objectArray = wrappers.get(clazz);
        assert (objectArray != null);
        return ((Character)objectArray[2]).charValue();
    }

    public static int bitWidth(Class<?> clazz) {
        return Wrappers.bitWidth(Wrappers.basicTypeChar(clazz));
    }

    public static int bitWidth(char c) {
        int n = PRIMITIVE_BITS_TABLE.indexOf(c);
        assert (c != ' ' && (n >= 0 || c == 'L'));
        return n + (n & 1);
    }

    public static boolean isSigned(Class<?> clazz) {
        return Wrappers.isSigned(Wrappers.basicTypeChar(clazz));
    }

    public static boolean isSigned(char c) {
        int n = PRIMITIVE_BITS_TABLE.indexOf(c);
        assert (c != ' ' && (n >= 0 || c == 'L'));
        return (n & 1) == 0;
    }

    public static boolean isSubwordOrInt(Class<?> clazz) {
        return Wrappers.isSubwordOrInt(Wrappers.basicTypeChar(clazz));
    }

    public static boolean isSubwordOrInt(char c) {
        return "IZBCS".indexOf(c) >= 0;
    }

    public static Class<?> basicTypeFromChar(char c) {
        Object[] objectArray;
        if (c == 'L') {
            return Object.class;
        }
        if (wrappers.isEmpty()) {
            Wrappers.fillWrappers();
        }
        if ((objectArray = wrappers.get(Character.valueOf(c))) == null) {
            return null;
        }
        return (Class)objectArray[1];
    }

    public static Object zeroValue(Class<?> clazz) {
        if (!clazz.isPrimitive()) {
            return null;
        }
        if (wrappers.isEmpty()) {
            Wrappers.fillWrappers();
        }
        Object[] objectArray = wrappers.get(clazz);
        assert (objectArray != null);
        return objectArray[3];
    }

    private static void fillWrappers() {
        Object[][] objectArrayArray;
        for (Object[] objectArray : objectArrayArray = new Object[][]{{Boolean.class, Boolean.TYPE, Character.valueOf('Z'), false}, {Character.class, Character.TYPE, Character.valueOf('C'), Character.valueOf('\u0000')}, {Byte.class, Byte.TYPE, Character.valueOf('B'), (byte)0}, {Short.class, Short.TYPE, Character.valueOf('S'), (short)0}, {Integer.class, Integer.TYPE, Character.valueOf('I'), 0}, {Long.class, Long.TYPE, Character.valueOf('J'), 0L}, {Float.class, Float.TYPE, Character.valueOf('F'), Float.valueOf(0.0f)}, {Double.class, Double.TYPE, Character.valueOf('D'), 0.0}, {Void.class, Void.TYPE, Character.valueOf('V'), null}}) {
            wrappers.put(objectArray[0], objectArray);
            wrappers.put(objectArray[1], objectArray);
            wrappers.put(objectArray[2], objectArray);
        }
    }
}

