import unittest
import jppy
import baseclass
import types

class eventTest(baseclass.baseTest):
    def setUp(self):
        baseclass.baseTest.setUp(self)
        self.calendar = jppy.calendar()
        self.e = jppy.Event()

    def testGetValues(self):
        hits = self.calendar.records()[0:10]
        hits.sort()
        for e in hits:
            e['begin'], e['end'], e['final']
            if e['alarm']:
                e['alarm'], e['begin'] - e['alarm']
            e['exceptions']
            e['dates'][0:50]

    def testToday(self):
        print "Today"
        for time, event in self.calendar.eventsToday():
            print time, event

    def testWeek(self):
        print "This Week"
        for time, event in self.calendar.eventsThisWeek():
            print time, event

    def testExtra(self):
        for bbb in self.calendar.records(search="last tu")[0:10]:
            print bbb
            for d in  bbb['dates'][0:20]:
                print d

def suite():
    suite = unittest.TestSuite((unittest.makeSuite(eventTest),))
    
    return suite
