import mx.DateTime
import os.path
import os
import re
import sys
import jppy

class letter:
    
    def texify(self,str):
        str = str.replace("&","\&")
        return str

    def pathify(self,str):
        str = str.replace(" ","_")
        return str

    def __init__(self,contact,select=1,sender=1,log="No Log Entry"):
        self.contact = contact

        self.letter_base_path = jppy.config.get("latex","letter_base_path")
        self.letter_base_file =  jppy.config.get("latex","letter_base_file")
        self.letter_base_makefile = jppy.config.get("latex","letter_base_makefile")
        
        self.merge(select)

    def merge(self,select=1):
        dir_name = "%s_%s_%s" % (self.contact['firstname'],
                                 self.contact['lastname'],
                                 self.contact['company'])
        path = os.path.join(self.letter_base_path,
                            self.pathify(dir_name),
                            mx.DateTime.now().strftime("%Y-%m-%d"))

        if not os.path.isdir(path):
            os.makedirs(path)

        data = {}

        for key in ('firstname','lastname','company',
                    'address','city','state',
                    'country','zip'):
            if key in ('firstname','lastname','company'):
                data[key] = self.contact[key] or ""
            else:
                data[key] = self.contact["%s%d" % (key,select)] or ""

        block = r"""%(firstname)s %(lastname)s\\%(company)s\\%(address)s\\%(city)s\\%(state)s\\%(country)s\\%(zip)s """ % data

        address = block.strip()
        address = re.sub("\n",r"\\\\",address)    
        address = re.sub(",[\t ]?\\\\",r"\\",address)
        address = re.sub(r"^\\\\","",address)
        address = re.sub(r"(\\)+$","",address)        
        address = self.texify(address)

        if data['firstname'] or data['lastname']:
            greeting = """Dear %(firstname)s %(lastname)s""" % data
        else:
            greeting = """Dear Sir/Madam"""

        greeting = self.texify("%s," % greeting.strip())

        base = open(self.letter_base_file,"r")
        letter = base.read().replace("\Adresse{}","\Adresse{%s}" % address)
        letter = letter.replace("\Anrede{,}","\Anrede{%s}" % greeting)
        base.close()

        i = 1
        while 1:
            self.full_filename = os.path.join(path,"letter%d.tex" % i)
            if not os.path.isfile(self.full_filename):
                break
            i += 1

        open(self.full_filename,"w").write(letter)

        open(os.path.join(path,"Makefile"),"w").write(
            open(self.letter_base_makefile,"r").read())

    def display(self,log="No Log Entry"):
        self.contact.log("Editing Letter",log)

        os.system("%s \"%s\" &" % (jppy.config.get("core","editor"),self.full_filename))

