#!/usr/bin/env python

"""Send a subset of Project list and an entire ToDo category
to an email address as a pdf attachment.

Usage: email_client_todos.py from to category token

Options:
    -h / --help
        Print this message and exit.

`from' is the email address of the sender of the message.

`to' is the email address of the recipient of the message

`category' is the name of the category to be included

`token' is the string to search for in the project list.

Example: email_client_todos.py me@here.com you@there.com "Big Jobs" "Bigs: "
"""

import jppy
from jppy.printers import todos_printer

from email.MIMEText import MIMEText
from email.MIMEMultipart import MIMEMultipart
from email.MIMEBase import MIMEBase
from email import Encoders
from email.Message import Message

import smtplib
import mimetypes
import sys
import os
import getopt
import tempfile

def usage(code, msg=''):
    print >> sys.stderr, __doc__
    if msg:
        print >> sys.stderr, msg
    sys.exit(code)

def main():
    try:
        opts, args = getopt.getopt(sys.argv[1:], 'h', ['help'])
    except getopt.error, msg:
        usage(1, msg)

    if not len(args) == 4:
        usage(1)
    
    sender   = args[0]
    recips   = args[1]
    category = args[2]
    token    = args[3]

    tasks = jppy.taskList()

    categorys   = tasks.getCategories()[:]


    projects = tasks.records(categories=[categorys.index("Project List")],
                             search=token)

    otherlists  = range(0,16)
    otherlists.remove(categorys.index(category))
    otherlists.remove(categorys.index("Project List"))
    othertasks = tasks.records(categories=[otherlists], search=token)

    taskitems    = tasks.records(categories=[categorys.index(category)])

    r = todos_printer(tasks, projects + taskitems + othertasks)
    filename = tempfile.mktemp() + ".pdf" # race condition/unsecure, etc.
    r.savecopy(filename)                  #

    outer = MIMEMultipart()
    outer['Subject'] = 'Category Task List'
    outer['To']      = recips
    outer['From']    = sender
    outer.preamble = 'This message is MIME encoded.\n'
    # To guarantee the message ends with a newline
    outer.epilogue = ''
    ctype, encoding = mimetypes.guess_type(filename)
    if ctype is None or encoding is not None:
        # No guess could be made, or the file is encoded (compressed), so
        # use a generic bag-of-bits type.
        ctype = 'application/octet-stream'
    maintype, subtype = ctype.split('/', 1)

    fp = open(filename, 'rb')
    msg = MIMEBase(maintype, subtype)
    msg.set_payload(fp.read())
    fp.close()
    # Encode the payload using Base64
    Encoders.encode_base64(msg)

    msg.add_header('Content-Disposition', 'attachment', filename=filename)
    outer.attach(msg)

    s = smtplib.SMTP()
    s.connect()
    s.sendmail(sender, recips, outer.as_string())
    s.close()

    os.unlink(filename)

if __name__ == '__main__':
    main()
