import jppy
import string
import mx.DateTime
import sys
import os

email_list = """
Firstname Middlename Lastname 0781842233 there@here.com
Firstname Lastname 0781842233 somewhere@there.com
John Doe 0781842233 some@email.biz
there@nowhere.com
"""

if len(sys.argv) > 1:
    fn = sys.argv[1]
    if os.path.exists(fn):
        print "Importing from %s" % fn
        email_list = open(fn,"r").read()
    else:
        raise RuntimeError("%s does not exist." % fn)

if 0:
    export = open("/tmp/import.vcf","w")
else:
    export = None

ab = jppy.addressBook()
_mobile_index = ab.getPhoneLabels().index("Mobile")
_email_index  = ab.getPhoneLabels().index("E-mail")
_pers_index   = ab.getPhoneLabels().index("Personal")

for person in email_list.split("\n"):
    if len(person) == 0:
        continue
    parts = person.split(" ")
    contact = ab.new()
    contact.category = _pers_index
    contact['phone1'] = parts[-1]
    contact['type1']  = _email_index
    if len(parts) > 1:
        contact['phone2'] = parts[-2]
        contact['type2']  = _mobile_index
    contact['firstname'] = string.join(parts[0:-3])
    if len(parts) > 1:
        contact['lastname'] = parts[-3]
    contact['note'] = "Added %s" % mx.DateTime.now().date
    contact['custom2'] = "nl-gen-l"
    if export:
        export.write(contact.vcard())
    ab.save(contact)
    print "Added %s" % contact
