/* backup.h
 *
 * Copyright (C) 1999 by Jason Day
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __BACKUP_H__
#define __BACKUP_H__


#define MAX_DBNAME          34  /* I got this number from struct DBInfo */
#define BACKUP_DIR_NAME     "Backup"
#define MANIFEST            ".manifest"
#define ACTIVE_DBM          "active.dbm"
#define INACTIVE_DBM        "inactive.dbm"

#define SECONDS_PER_DAY     (60 * 60 * 24)
#define SECONDS_PER_WEEK    (SECONDS_PER_DAY * 7)
#define SECONDS_PER_MONTH   (SECONDS_PER_DAY * 30)

/* backup_when constants */
#define EVERY_SYNC          0
#define DAILY               1
#define WEEKLY              2
#define MONTHLY             3

/* button id constants */
#define BACKUP_NEW_BUTTON   100
#define EVERY_SYNC_BUTTON   101
#define DAILY_BUTTON        102
#define WEEKLY_BUTTON       103
#define MONTHLY_BUTTON      104

/* preferences constants */
#define PREFS_FILE "backup.rc"

#define BPREF_BACKUP_WHEN        0
#define BPREF_BACKUP_NEW         1
#define BPREF_NUM_ARCHIVES       2
#define BPREF_LAST_BACKUP        3
#define BPREF_PERSISTENT_ARCHIVE 4

#define NUM_BPREFS 5
prefType backup_prefs[NUM_BPREFS] = {
    {"backup_when",        INTTYPE,  INTTYPE,  EVERY_SYNC, NULL, 0},
    {"backup_new",         INTTYPE,  INTTYPE,  1,          NULL, 0},
    {"num_archives",       INTTYPE,  INTTYPE,  3,          NULL, 0},
    {"last_backup",        CHARTYPE, CHARTYPE, 0,          NULL, 0},
    {"persistent_archive", INTTYPE,  INTTYPE,  0,          NULL, 0}
};

/* max possible number of archive directories */
#define MAX_ARCHIVES 99

#endif /* __BACKUP_H__ */
