#include <jmp-config.h>
#include <jmptime.h>

#ifdef unix
#if HAVE_SYS_TIME_H
#include <sys/time.h>
#endif
#if HAVE_SYS_TIMES_H
#include <sys/times.h>
 #ifdef HAVE_UNISTD_H
  #include <unistd.h>
 #endif
#endif
#include <string.h>
#endif /* unix */

#ifdef HAVE_SYS_TIMEB_H
#include <sys/timeb.h>
#if 0 /* unused */
 #include <sys/types.h>
 #include <winsock.h>
#endif

#ifndef HAVE_GETTIMEOFDAY
static void win32_gettimeofday (struct timeval* t,void* timezone) {
    struct timeb timebuffer;
    ftime (&timebuffer);
    t->tv_sec = timebuffer.time;
    t->tv_usec = 1000 * timebuffer.millitm;
}
#define HAVE_GETTIMEOFDAY
#define gettimeofday	win32_gettimeofday
#endif /* HAVE_GETTIMEOFDAY */
#endif /* HAVE_SYS_TIMEB_H */

#ifdef linux
#ifdef HAVE_SYS_TIMES_H
#define JMPTIME_USE_TIMES
static jlong CLOCK_FACTOR = 0;
#endif /* HAVE_SYS_TIMES_H */
#endif /* linux */

jlong get_thread_time_impl (JVMPI_Interface* jvmpi);

jlong get_absolute_time (JVMPI_Interface* jvmpi) {
#ifdef HAVE_GETTIMEOFDAY
    jlong tval;
    struct timeval tv;
    /* MW: This method costs around 126 seconds for my test case */
    gettimeofday (&tv, NULL);
#ifdef __GNUC__
    tval = ((jlong)tv.tv_sec) * 1000000000ll + ((jlong)tv.tv_usec) * 1000;
#else
    tval = ((jlong)tv.tv_sec) * 1000000000 + ((jlong)tv.tv_usec) * 1000;
#endif
    return tval;
#else
    return get_thread_time_impl (jvmpi);
#endif
}

jlong get_thread_time_sun (JVMPI_Interface* jvmpi) {
    /* MW: This method costs around 145 seconds for the same test case.
       Overall time is currently 415 seconds. */

    /* Currently there is a bug in the SUN jvm, returns microsec 
     * instead of nanosec. 
     */
    return jvmpi->GetCurrentThreadCpuTime () * 1000;
}

/**
 * This one is for correct JVMs conforming to the specification.
 */
jlong get_thread_time_impl (JVMPI_Interface* jvmpi) {
#ifdef JMPTIME_USE_TIMES
    /**
     * On Linux SUN JVMs don't seem to return the thread cpu time in
     * GetCurrentThreadTimeMillis and IBM returns the result of times. So we
     * may call it directly on our own.
     */
    struct tms mytms;
    times (&mytms);
    return (mytms.tms_utime + mytms.tms_stime) * CLOCK_FACTOR;
#else
    return jvmpi->GetCurrentThreadCpuTime ();
#endif
}

/* Start with the definition causing the smallest error */
jlong (*get_thread_time) (JVMPI_Interface* jvmpi) = get_thread_time_impl;

void jmptime_init (int absolute_times, const char* vm_version,
		   const char* vm_vendor, const char* vm_name) {
    if (absolute_times) {
	get_thread_time = get_absolute_time;
    } else {
#ifdef JMPTIME_USE_TIMES
 #ifdef __GNUC__
	CLOCK_FACTOR = 1000000000ll / sysconf (_SC_CLK_TCK);
 #else
	CLOCK_FACTOR = 1000000000 / sysconf (_SC_CLK_TCK);
 #endif
#else
	if (strncmp (vm_vendor, "IBM", 3)) get_thread_time = get_thread_time_sun;
#endif
    }
}

void jmptime_set_time_values (jlong td, jlong* jsec, jlong* jnsec) {
#ifdef __GNUC__
    *jsec = td / 1000000000ll;
    *jnsec = (td % 1000000000ll) / 1000ll;
#else
    *jsec = td / 1000000000;
    *jnsec = (td % 1000000000) / 1000;
#endif
}

/* Emacs Local Variables: */
/* Emacs mode:C */
/* Emacs c-indentation-style:"gnu" */
/* Emacs c-hanging-braces-alist:((brace-list-open)(brace-entry-open)(defun-open after)(substatement-open after)(block-close . c-snug-do-while)(extern-lang-open after)) */
/* Emacs c-cleanup-list:(brace-else-brace brace-elseif-brace space-before-funcall) */
/* Emacs c-basic-offset:4 */
/* Emacs End: */
