/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jftp.gui.tasks;

import java.awt.BorderLayout;
import java.util.Vector;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import net.sf.jftp.JFtp;
import net.sf.jftp.gui.base.dir.Dir;
import net.sf.jftp.system.logging.Log;

public class HttpBrowser
extends JInternalFrame
implements HyperlinkListener {
    public HttpBrowser(String url) {
        super("Http Browser", true, true, true, true);
        try {
            this.setTitle(url);
            JEditorPane pane = new JEditorPane(url);
            pane.setEditable(false);
            pane.addHyperlinkListener(this);
            if (!pane.getEditorKit().getContentType().equals("text/html") && !pane.getEditorKit().getContentType().equals("text/rtf")) {
                if (!pane.getEditorKit().getContentType().equals("text/plain")) {
                    Log.debug("Could not display URL.");
                    return;
                }
                pane.setEditable(false);
                pane.addHyperlinkListener(this);
            }
            JScrollPane jsp = new JScrollPane(pane);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add("Center", jsp);
            this.setLocation(50, 50);
            this.setSize(600, 400);
            this.show();
            this.requestFocus();
        }
        catch (Exception ex) {
            Log.debug("Error fetching URL: " + ex);
            ex.printStackTrace();
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane)e.getSource();
            if (e instanceof HTMLFrameHyperlinkEvent) {
                HTMLFrameHyperlinkEvent evt = (HTMLFrameHyperlinkEvent)e;
                HTMLDocument doc = (HTMLDocument)pane.getDocument();
                doc.processHTMLFrameHyperlinkEvent(evt);
            } else {
                try {
                    String url = e.getURL().toString();
                    String tmp = url.substring(url.lastIndexOf("/"));
                    Vector<Dir> listeners = new Vector<Dir>();
                    listeners.add(JFtp.localDir);
                    if (!url.endsWith(".htm") && !url.endsWith(".html") && tmp.indexOf(".") >= 0) {
                        JFtp.statusP.startTransfer(url, JFtp.localDir.getPath(), listeners, JFtp.getConnectionHandler());
                    } else {
                        pane.setPage(e.getURL());
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }
}

