<?
    function snmp_netsnmp_fix ($value) {
	//BUGFIXES FOR NET-SNMP 5
	$value=preg_replace("/INTEGER: /","",$value);
	
	if (preg_match("/STRING: \"(\S.+)\"/",$value,$parts)) $value = $parts[1];
	$value=preg_replace("/STRING: /","",$value);

	//$value=preg_replace("/IpAddress: /","",$value); //Breaks discovery/snmp_interfaces
    
	$value = trim ($value);
	
	return $value;    
    }

    function snmp_walk ($host,$comm,$oid,$include_oid = 0,$retries = 2) {

	if ($include_oid==0)
	    $result = @snmpwalk($host,$comm,$oid,(1000000*1),$retries);
	else 
	    $result = @snmpwalkoid($host,$comm,$oid,(1000000*1),$retries); //OPTION to get OIDs in the key
	
	if (is_array($result)) 
	    foreach ($result as $key=>$aux) {
		$aux = snmp_netsnmp_fix($aux);
		if (strpos($aux,"=")) $aux = substr($aux,strpos($aux,"=")+2,strlen($aux));
		$result[$key]=$aux;
	    }	

	//logger ("\nsnmpwalk $host:$comm $oid = ".vd($result)."\n");
	return $result;
    }

    function get_snmp_counter ($ip,$community,$oid) {
	$aux = explode(":",@snmp_get($ip,$community,$oid));
	if (count($aux)==1) $result = $aux[0];
	    else $result = $aux[1];
	return $result;
    }

    function snmp_get($host,$comm,$oid, $retries = 2) { 
	$aux = @snmpget($host,$comm,$oid,(1000000*1), $retries);

	if ($aux!==false) {
	    $aux = snmp_netsnmp_fix($aux);
	    if (strpos($aux,"=")) $aux = substr($aux,strpos($aux,"=")+2,strlen($aux));
	}

	//logger ("\nsnmpget $host:$comm $oid = $aux\n");
	return $aux;
    }
    
    
//MISC
//--------------------------------------------------------

    function snmp_hex_to_string ($hex) {
	$value = trim($hex);
	if (substr($value,0,3)=="Hex") { 
	    $data = substr($value,4,strlen($value)-5);

	    for ($i=0; $i < strlen($data) ; $i++) 
		if (ord($data[$i])==10) $data[$i]=" ";
		
	    $data_array = explode(" ",$data);
	    $value = "";
	    foreach ($data_array as $aux) if ($aux!="00") $value .= chr(hexdec($aux));
	}
	return $value;
    }

    function http_post_message ($url,$vars,$raw_data = "", $debug = 0,$comment = NULL, $HTTP_MODE = "1.0") {

	unset($comment);    
	if ($comment) $url.="?method=".$vars[method]."&from=$comment";

	preg_match("/^(.*:\/\/)?([^:\/]+):?([0-9]+)?(.*)/", $url,$match);
	list(,$proto,$host,$port,$path) = $match;  

	if (!$port) $port = 80; 
	
	if ($proto=="https://") {
	    $host = "ssl://".$host;
	    $port = 443;
	}
	
	$user_agent = "JFFNMS";

	$urlencoded = "";
	while (list($key,$value) = each($vars))
	    if (!is_array($value))
		$urlencoded.= "$key=$value&";
	    else 
		$urlencoded.= "$key=".str_replace("&","%26",satellize($value))."&";


	$urlencoded = substr($urlencoded,0,-1);	

	$content_length = strlen($urlencoded);

	//Changed to HTTP/1.0 without KeepAlive
	$headers =	"POST $path HTTP/".$HTTP_MODE."\r\n".
			"Host: $host\r\n".
			(($HTTP_MODE=="1.1")?"Connection: close\r\n":"").
			"Content-Type: application/x-www-form-urlencoded\r\n".
			"User-Agent: $user_agent\r\n".
			"Content-Length: $content_length\r\n".
			"\r\n$raw_data";
	
	$fp = @fsockopen($host, $port, $errno, $errstr,4);
	if (!$fp) return false;

	$time_send = time_usec();

	$a = fputs($fp, $headers.$urlencoded);
	
	$time_send = time_usec_diff($time_send);
	if ($debug == 1) echo "time send: $time_send \n";
	
	if ($debug == 2) var_dump($headers.$urlencoded);

	$time_recv = time_usec();

	$ret = "";
	while (!feof($fp))
		$ret.= fgets($fp, 1024);
    	fclose($fp);

	$time_recv = time_usec_diff($time_recv);
	if ($debug == 1) echo "time recv: $time_recv \n";

	$init = strpos($ret,"\r\n\r\n");
	$data1 = substr($ret,$init+4,strlen($ret)-$init);
	
	if ($HTTP_MODE=="1.1") {
	    $init = strpos($data1,"\r\n")+2;
	    $len = strrpos($data1,"\r\n")-$init-4;
	} else {
	    $init = strpos($data1,"\r\n");
	    $len = strlen($data1)-$init;
	}	
	$data = trim(substr($data1,$init,$len));

	return $data;
    }

    function https_post_message ($url,$vars,$raw_data = "", $debug = 0,$comment = NULL) {

        unset($comment);
        if ($comment) $url.="?method=".$vars["method"]."&from=$comment";

        $user_agent = "JFFNMS";

        $urlencoded = "";
        while (list($key,$value) = each($vars))
            if (!is_array($value))
                $urlencoded.= "$key=$value&";
            else
                $urlencoded.= "$key=".str_replace("&","%26",satellize($value))."&";

        $urlencoded = substr($urlencoded,0,-1);

        $ch = curl_init();
        curl_setopt ($ch, CURLOPT_URL, $url);
        curl_setopt ($ch, CURLOPT_USERAGENT, $user_agent);
        curl_setopt ($ch, CURLOPT_SSL_VERIFYHOST,  2);
        curl_setopt ($ch, CURLOPT_HEADER, 0);
        curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt ($ch, CURLOPT_SSL_VERIFYPEER,  0);
        curl_setopt ($ch,CURLOPT_POST,1);
        curl_setopt ($ch, CURLOPT_POSTFIELDS,$urlencoded);

        $data = curl_exec ($ch);
        curl_close ($ch);

        return $data;
    }


    function soap_post_message ($url, $vars, $debug = 0,$comment = NULL) {
	
	require_once "SOAP/Client.php";

	$url = str_replace("soap://","http://",$url);
    	$options = array('namespace' => 'urn:JFFNMS', 'trace' => 1);
	$soapclient = new SOAP_Client("$url?capabilities=O");
	
	$method = $vars["method"];
	unset($vars["method"]);
	unset($vars["capabilities"]);
	$ret = $soapclient->call($method,$vars,$options);
	unset($soapclient);
	
	$ret = object2array($ret);

	if (is_array($ret["item"])) {
	    $aux = $ret["item"];
	    unset ($ret["item"]);
	    $ret = array_merge ($ret,$aux);
	}
	
	return $ret;
    }

    function wddx_post_message ($url,$vars,$raw_data = "", $debug = 0,$comment = NULL) {

	preg_match("/^(.*:\/\/)?([^:\/]+):?([0-9]+)?(.*)/", $url,$match);
	list(,,$host,$port,$path) = $match;  
	if (!$port) $port = 5000; 

	$send = satellize ($vars,"W");	

	$fp = fsockopen($host, $port, $errno, $errstr);
	if (!$fp) return false;

	fputs($fp, $send);

	$ret = "";
	while (!feof($fp))
		$ret.= fgets($fp, 1024);
    	fclose($fp);

	return $ret;
    }

    function satellite_query ($satellite_url,$message,$comment = NULL,$debug = 0) {
	//debug = 1, debug the transport
	//debug = 2, debug the RAW reply
	//debug = 4, debug the reply
	//debug = 8, return Result and Raw Result
    
	if (!$message["capabilities"] && ($message["session"]=="get")) //set capabilities when establishing a session
	    $message["capabilities"] = unsatellize();
    
	$message["from_sat_id"]=$GLOBALS["my_sat_id"]; //add my sat id as from
	
	preg_match("/^(.*:\/\/)?([^:\/]+):?([0-9]+)?(.*)/", $satellite_url,$match);
	$proto = $match[1];

	$result_raw = NULL;    

	switch ($proto) {
	    
	    case "https://" : 	$result_raw = https_post_message ($satellite_url,$message,"",$debug,$comment);
				break;

	    case "http://" : 	$result_raw = http_post_message ($satellite_url,$message,"",$debug,$comment);
				break;

	    case "soap://" : 	$result = soap_post_message ($satellite_url,$message,$debug,$comment); //no need to unsatellize
				break;

	    case "wddx://" : 	$result_raw = wddx_post_message ($satellite_url,$message,$debug,$comment);
				break;

	}

	if ($debug==2) var_dump($result_raw);
	
	if ($result_raw) $result = unsatellize($result_raw);

	if ($debug==4) var_dump($result);
	
	if ($debug==8) $result = array($result,$result_raw);
	
	return $result;
    }
    
    function satellite_call ($sat_id, $class, $method, $params = NULL) {

        $sat_url = current(satellite_get ($sat_id));
        $sat_url = $sat_url["url"];
	
	if (!is_array($params)) $params = array ($params);
	
	$message = array(
	    "sat_id"=>$sat_id,
	    "class"=>$class,
	    "method"=>$method,
	    "params"=>$params
	);
	
	$result = satellite_query ($sat_url, $message);
	
	return $result;
    }

?>
