<?
/* SNMP Trap Integrator
 * Copyright (C) <2002,2003> Javier Szyszlican <javier@szysz.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

if (!function_exists("get_varbind_value")) {
    function get_varbind_value($trapid, $oidid) {
	if ($oidid != '*')
    	    $query_varbinds = "SELECT value, oidid FROM traps_varbinds WHERE trapid = $trapid AND oidid = $oidid";
	else
    	    $query_varbinds = "SELECT value, oidid FROM traps_varbinds WHERE trapid = $trapid ORDER BY oidid";

	$result_varbinds = db_query($query_varbinds) or die ("Query failed ($query_varbinds) get_varbind_value($trapid,$oidid) - ".db_error());
	if (db_num_rows ($result_varbinds) == 0) return '';

	if ($oidid != '*') //if we're asked for a specific OID id
    	    $varbind_value = current(db_fetch_array($result_varbinds)); //get first (value) field of the recordset
	else //if we're asked for all varbinds
	    while ( $rows_varbinds = db_fetch_array($result_varbinds)) //save all varbinds with key and value
    		$varbind_value .= " ".$rows_varbinds["oidid"].": ".$rows_varbinds["value"];
	
	return $varbind_value;
    }
}

    $varbinds_fields = array("interface","state","username","info");
    
    $query_traps = "select id as trap_id, date, ip, trap_oid from traps where analized = 0 order by id asc";
    $result_traps = db_query ($query_traps) or die ("Query failed - TA2 - ".db_error());

    logger( "SNMP Trap to Process: ".db_num_rows($result_traps)."\n");

    while ($trap = db_fetch_array($result_traps)) {

	$values = array();
	$trap_id = $trap["trap_id"];
	unset($output);

	//get Host ID
	$query_host="Select id from hosts where hosts.ip = '".$trap["ip"]."'"; 
	$result_host = db_query ($query_host) or die ("Query failed - TA5 - ".db_error());
	$host_id = (db_num_rows ($result_host) > 0)?current(db_fetch_array($result_host)):1; //if not host is found use 1 (unknown)
	    
	unset($query_host);
	unset($result_host);
	    
	if ($host_id == 1) $values["info"] .= "Trap from: ".$trap["ip"]; //record the HostIP in the info field

	$query_types="Select type, interface, username, state, info FROM traps_types WHERE match_oid = '".$trap["trap_oid"]."'"; 
    	$result_types = db_query ($query_types) or die ("Query failed - TA3 - ".db_error());

	if (db_num_rows ($result_types) <= 0) {
	    $query_types="Select type, interface, username, state, info FROM traps_types where id = 1"; //get uknown trap type
    	    $result_types = db_query ($query_types) or die ("Query failed - TA3 - ".db_error());
	    $values["info"] .= " OID: ".$trap["trap_oid"]; //record the Trap OID in the info field
	    unset ($query_types);
	}
	$trap_type = db_fetch_array($result_types); //get the current record it will be only 1
	unset ($result_types);
	    
	// Match varbinds to fields
	foreach ($varbinds_fields as $field) //go thru all fields
	    if (!empty($trap_type[$field])) { //if they its not empty
		if (is_numeric($trap_type[$field]) || ($trap_type[$field]=="*")) //if its numeric or *
		    $values[$field] .= get_varbind_value($trap_id, $trap_type[$field]); //look it up
		else
		    $values[$field] .= $trap_type[$field]; //use the field contents as value
	    
		$output .= "\t".$field."(".$trap_type[$field]."): ".$values[$field];
	    } else
	        $values[$field] .= ""; //if it was empty return empty

	logger("SNMP Trap ID: $trap_id \tHost: ".$trap["ip"]."\tType: ".$trap_type["type"].": ".$output."\n");

	insert_event($trap["date"], $trap_type["type"], $host_id, $values["interface"], $values["state"], $values["username"], $values["info"], $trap_id); //insert the required event
	traps_analized($trap_id); //mark trap as analized
    }
?>
