<?

function oid_cmp($a, $b) {
   if ($a == $b) return 0;
    
    $a1 = explode (".",$a);
    $b1 = explode (".",$b);

    if (count($a1) < count($b1)) return -1;
    if (count($a1) > count($b1)) return 1;
    
    for ($i = 0; $i < count($a1); $i++) {
	if ($a1[$i] < $b1[$i]) return -1;
	if ($a1[$i] > $b1[$i]) return 1;
    }    
}
		

function truncate_counter (&$value) {
    $max 	= pow(2,31);
    $max_pass 	= ($value/$max);
    $max_less	= ($max * floor($max_pass));

    if ($max_pass >= 1) $value = floor($value - $max_less);
}


function create_rama ($oid,$k,$data,$deep,&$tree) {
    if (!is_numeric(current(array_keys($data)))) $data = array_values ($data);

    //echo "rama $oid -deep $deep -k $k\n";
    //var_dump($data);

    while (list ($k1,$item) = each ($data)) {
	if (is_array($item)) create_rama ("$oid.$k",$k1,$item,++$deep,$tree);
	else 
	    if ($deep==0) {
		$tree["$oid.$k.$k1"]=$item;
	        //echo "B: $oid - $k - $k1 - $item\n";
	    } else {
		$tree["$oid.$k1.$k"]=$item;
	        //echo "C: $oid - $k1 - $k - $item\n";
	    }
    }
}

function create_tree ($oid,$data,&$tree) {
    $data = array_values($data);
    //echo "tree\n";
    foreach ($data as $k=>$v) {
	if (is_array($v)) 
	    create_rama ($oid,$k,$v,0,$tree);
	else {
	    $tree["$oid.$k"]=$v;
	    //echo "A: $oid.$k - $v\n";
	}
    }
    return $tree;
}

function secho ($oid,$var = NULL) {
    $out .= "$oid\n";
    if (!is_null($var)){ 
	if (is_numeric($var)) $out .="integer\n";
	else $out.= "string\n";

        $out.="$var\n";
    }
    echo $out;
}

function walk_tree ($start, &$tree) {
    $show_next = 0;

    while (list ($k,$v) = each ($tree)) {

	if (($show_next == 1) || (preg_match("/^$start\S+/",$k,$aux))) {
	    secho ($k,$v);
	    break;
	}
	
	if ($k===$start) 
	    $show_next = 1;
    }
}


list ($myself, $tree_to_use, $base, $oper, $oid)  = $_SERVER["argv"];

$trees = array("tc","iptables");

if (in_array($tree_to_use,$trees)) {
    $tree = array();
    
    $tree_filename = dirname($myself)."/".$tree_to_use.".state";
    $generate_again = 1;
    
    if ((file_exists($tree_filename)===true) && ((time() - filemtime($tree_filename)) < 60)) { //if tree is less than 60 seconds old
	$generate_again = 0; 	//don't generate it again
	$tree = unserialize(join("",file($tree_filename))); //load it from file
    }
    
    if ($generate_again == 1) {
	include ("$tree_to_use.inc.php");
        create_tree ($base,call_user_func("tree_$tree_to_use"),$tree);
	uksort($tree,"oid_cmp");
	reset ($tree);
	
	//save tree
	$fp = fopen($tree_filename,"w+");
	fputs($fp,serialize($tree));
	fclose($fp);
    }
    
    switch ($oper) {
	case "-n" : walk_tree ($oid,$tree); break;
	case "-g" : if (isset($tree[$oid])) secho ($oid,$tree[$oid]); break;
	case "debug" : print_r ($tree); echo "Gen: $generate_again\n"; break;
    }
}

?>
