<?php

    @set_time_limit(0);
    declare(ticks=1)
    
    pcntl_signal(SIGHUP, "sig_handler");
    pcntl_signal(SIGINT, "sig_handler");
    pcntl_signal(SIGTERM, "sig_handler");	
    
    include_once("../conf/config.php");

    $shm;
    
    //GC: save all tue current variables
    foreach ($GLOBALS as $key=>$val)
	$keys["$key"]=$key;

    $keys["shm"]="shm";
    $keys["keys"]="keys";

    function main($argc,$argv) {
	global $shm,$keys;
	
	$jffnms_real_path = get_config_option ("jffnms_real_path");
	/**
	 * The second argument should be
	 * A reference to a shared memory address
	 * If it is not around, return false;
	 */
	
	if ( $argc < 2 )
	    die("No shared memory address given!\n");
	
	$shm = init();
	
	/**
	 * Enter main loop
	 */
	while ( 1 ) {
	    
	    /**
	     * Read data from shared memory
	     */
			
	    $data = trim(ReadCmd($shm));
	    
	    if ( $data == "EXIT" ) {
		/** 
		 * Time to exit
		 */
		shutdown($shm);
		exit();
	    }
	
	    list ($host_id, $interface_id) = explode(" ",$data);
			
	    if (!empty($host_id) && !empty($interface_id)) {
		/**
		 * Should do work here
		 */
		$poller_plan_filter = array("interface"=>$interface_id,"host"=>$host_id);
    		$poller_plan_result = poller_plan ($poller_plan_filter); //Get the Poller Plan (things to poll)

		/**
		 * Put out an ACK first
		 */
		$num_items = $poller_plan_result["items"];
	        $completed_items = 0;
	
		$cmd = "ACK $host_id:$interface_id := $num_items Items"; 
		SendCmd($shm,$cmd);
		usleep(10);
			
		while ($poller_data = poller_plan_next(&$poller_plan_result)) {
		
		    $poller_command = $poller_data["poller_command"];
 		    $backend_command = $poller_data["backend_command"];
		    $poller_filename = "$jffnms_real_path/engine/pollers/$poller_command.php";
		    $backend_filename = "$jffnms_real_path/engine/backends/$backend_command.php";

		    if ((file_exists($poller_filename)==TRUE) && (file_exists($backend_filename)==TRUE)) {
			
			$time_poller_query = time_usec();
			//unset result variables
			unset($poller_result);
			unset($backend_result);
			unset($backend_result_description);
			unset($times_description);

			//Tell the master what are we doing
			$cmd = "BUSY $host_id:$interface_id $completed_items/$num_items := $poller_command -> $backend_command"; 
			SendCmd($shm,$cmd);
			usleep(10);
			//sleep(1);
					
			include_once($poller_filename);
			$poller_result = call_user_func_array("poller_$poller_command",array($poller_data));
                	
			$cmd = "Poller result: $poller_result";
			SendCmd($shm,$cmd);
			usleep(10);
			    
			include_once($backend_filename);
       		        $backend_result = call_user_func_array("backend_$backend_command",array($poller_data,$poller_result));
			$cmd = "Backend result: ".$backend_result;
			SendCmd($shm,$cmd);
			usleep(10);
	
			$completed_items++;
		    }
		}	
		
		//Tell the master we're done & ready
		$cmd = "DONE $host_id:$interface_id = $completed_items/$num_items finished.";
		SendCmd($shm,$cmd);
		usleep(10);
	
		$cmd = "READY";
		SendCmd($shm,$cmd);
	    }
            
	    //GC: unset all globals that are not in the keys array 
	    foreach ($GLOBALS as $key=>$val)
        	if (isset($GLOBALS[$key]) && ($key != "keys") && !array_search($key,$keys))
		    unset($GLOBALS[$key]);

	    sleep(2);
	}
	return true;
    }	
	
    function shutdown($shm) {
	$cmd = "Exiting";
	
	SendCmd($shm,$cmd);
	close_shm($shm);
    }

    function init() {
	global $argv,$shm;

	$handler_id = $argv[1];
	$shm = open_shm($handler_id);
	$cmd = "READY";
	SendCmd($shm,$cmd);
	return $shm;
    }

    function sig_handler($signo) {
	global $shm;
    
        switch($signo) {
    	    case SIGTERM:
	    case SIGINT:
        		// handle shutdown tasks
            		shutdown($shm);
			exit();
			break;
            
	    case SIGHUP:
        		// handle restart tasks
            		shutdown($shm);
			$shm = init();
			break;
    	    default:
        		// handle all other signals
        }
    }

    function SendCmd($shm,$cmd) {
	/**
	 * Function that writes something to a shared memory, that a
	 * "Client" ( Child, or other process) is reading from
	 */
	
	/**
	 * Ok, lets put some data into the shared memory
	 */
	//shmop_write($shm ,str_repeat(" ",1024), 0);
	//sleep(1);
	//logger ($cmd);
	$cmd = str_pad($cmd ,shmop_size($shm)-1, " ", STR_PAD_RIGHT);

	$shm_bytes_written = shmop_write($shm ,$cmd, 0);
	//close_shm($shm);

	return $shm_bytes_written;
    }

    function ReadCmd($shm) {
	/**
	 * Read what was put in the shared memory
	 */
	$str = shmop_read($shm,0,shmop_size($shm));
	return trim($str);
    }

    function open_shm($handler_id) {
	if ( ! $shm = shmop_open($handler_id, "c", 0, 0) ) {
	    /**
	     * Could not open shared memory handler!
	     */
	    die("Fatal error, failed to open shared memory at $handler_id !!\n");
	}	
	return $shm;
    }

    function close_shm($shm_id) {
 	/**
	 * Closes the shared memory
	 */
	
	shmop_close($shm_id);
    }


    main($argc,$argv);

?>
