<?
    function discovery_bgp_peers ($ip,$rocommunity,$hostid,$param) {

	    $bgp_interfaces = array();

	    if ($ip && $hostid && $rocommunity)  
		$ifIndex = snmp_walk("$ip","$rocommunity",".1.3.6.1.2.1.15.3.1.1"); //bgp.bgpPeerTable.bgpPeerEntry.bgpPeerIdentifier
	    
	    if (count($ifIndex) > 0) {
		$ifLocal = snmp_walk($ip,$rocommunity,".1.3.6.1.2.1.15.3.1.5");
		$ifRemote = snmp_walk($ip,$rocommunity,".1.3.6.1.2.1.15.3.1.7");
		$ifOperStatus = snmp_walk($ip,$rocommunity,".1.3.6.1.2.1.15.3.1.2");
		$ifAdminStatus = snmp_walk($ip,$rocommunity,".1.3.6.1.2.1.15.3.1.3");
		$ifRemoteAS = snmp_walk($ip,$rocommunity,".1.3.6.1.2.1.15.3.1.9");

		// debug ($ifAdminStatus);
		for ($i=0; $i < count($ifIndex) ; $i++) if ($ifIndex[$i]) {
		    list($aux, $ifRemote[$i]) = explode(":",$ifRemote[$i]);
		    list($aux, $ifLocal[$i]) = explode(":",$ifLocal[$i]);
		    list($ifAdminStatus[$i]) = explode("(",$ifAdminStatus[$i]);
		    list($ifOperStatus[$i]) = explode("(",$ifOperStatus[$i]);
		
		    unset ($aux);
		
		    switch ($ifAdminStatus[$i]) {
			case 1: $AdminStatus[$i] = "down"; break;
			case 2: $AdminStatus[$i] = "up"; break;
		    }

		    switch ($ifOperStatus[$i]) {
			case 1: $OperStatus[$i] = "down"; break;
			case 3: $OperStatus[$i] = "down"; break; //active
			case 6: $OperStatus[$i] = "up"; break;
		    }
		    
		    $aux1 = array();
	    	    $aux1["local"] = trim($ifLocal[$i]); 
		    $aux1["remote"] = trim($ifRemote[$i]); 
		    $aux1["asn"] = "AS ".$ifRemoteAS[$i]; 
		    $aux1["interface"] = trim($ifRemote[$i]);

		    $aux1["admin"] = $OperStatus[$i];
		    $aux1["oper"] = $OperStatus[$i]; 

		    //calculate the index, unique for each remote ip
		    foreach (explode(".",$aux1["remote"]) as $ip_key_aux)
			$ip_index += $ip_key_aux*++$a;
    
		    $bgp_interfaces[$ip_index]= $aux1;
		
		    unset($aux1);
		    unset($ip_index);
		    unset($ip_key_aux);
		    unset($a);
		}
	    }
	    return $bgp_interfaces;
    }
?>
