---
title: 置換文字列の設定(ReplaceStr)
layout: default
---

&gt; [Top](../) &gt; [その他]({{ site.baseurl }}/info/) &gt; {{ page.title }}

## {{ page.title }}

- [置換処理について](#replacement)
- [置換条件設定](#config)
- [設定例](#example)


<a name="replacement"></a>
### 置換処理について
_v0.4.0+から追加_

スレビューに表示するテキストに対して条件に応じた置換処理を設定する。
設定はメニューバーの `設定(C)`＞`その他(O)`＞`置換文字列の編集(R)` からダイアログを開いて行う。

&#160; | 特徴
--- | ---
置換対象の区分 | スレタイトル &#8251;、名前欄、メール欄、日付/ID、レス本文
置換のタイミング | 対象を区分けした後、IDやリンクなどを解析する前に実行する
置換の順序 | 登録した置換条件をリストの上から順に実行していく
置換の方法 | シンプルな**キーワード置き換え**、または高度な**正規表現**が利用できる
一時的な処理 | 置換処理の結果はキャッシュデータ(DATファイル)に**保存しない**

&#8251; _v0.8.0-20220820 から追加_


#### 対象の置換前に文字参照をデコード
有効にするとHTMLとして意味のある文字(`"&<>`)を除き文字参照(e.g. `&hearts;`, `&#9829;`, `&#x2665;`)を置換前にデコードする
(置換条件の登録が無くても実行)。これにより文字参照でリンク生成を回避したURLなどを解釈することができる。


#### 設定ファイル
置換文字列の設定はキャッシュディレクトリの「**replacestr.xml**」ファイルにダイアログのOKを押したとき保存される。
設定ファイルが存在しないときはデフォルト設定が無効の状態で追加される。


#### 注意
- 設定ファイルを直接編集するときはJDimを終了(＆バックアップ)してから行うこと
- ファイルが壊れているときは読み込んだときに設定がすべて消去される
- ファイルのフォーマットは予告なく変更する場合がある


<a name="config"></a>
### 置換条件設定

項目 | 説明
--- | ---
有効/無効 | 無効にした置換条件は実行しない
正規表現 | 正規表現を使用するかどうか
大文字小文字 &#8251;1 | 大文字小文字を区別しない
全角半角 &#8251;2 | 英数字とカナの文字幅(いわゆる全角半角)を区別しない
互換文字 &#8251;3 | Unicodeの互換文字を区別しない
置換パターン | 置換するテキストのパターン
置換文字列 | マッチしたテキストを置き換える内容

* &#8251;1 _v0.8.0-20220917 から正規表現を使わないときも使える(ASCIIのみ)_
* &#8251;2 _v0.8.0-20221001 から追加_, 正規表現を使わないときは効果無し
* &#8251;3 _v0.8.0-20221008 から追加_, 正規表現を使わないときは効果無し

<a name="replchar"></a>
正規表現を使うと一致した文字列をもとに、以下の置換文字を使用できる。

置換文字 | 内容 |
--- | --- |
`\0` | 正規表現にマッチした文字列 |
`\1`〜`\9` | 正規表現で「(...)」にマッチした部分文字列 |


#### この設定をクリップボードにコピー
設定をXML要素としてシリアライズしてコピーする。


<a name="example"></a>
### 設定例

#### `ps://` から始まるテキストを `https://` にする

項目 | 設定
--- | ---
置換対象 | 本文
正規表現 | ON
置換パターン | `(?<!t)ps://([[:alnum:]]+)`
置換文字列 | `https://\1`


#### 日付を `YYYY年MM月DD日` 表示にする

項目 | 設定
--- | ---
置換対象 | 日付/ID
正規表現 | ON
置換パターン | `([0-9]{4})/([0-9]{2})/([0-9]{2})`
置換文字列 | `\1年\2月\3日`
