/* 
    * $id:cal.h - Jalali Calendar
    * Tools for converting Jalali to Gregorian dates and vice-versa.
    * author: Ashkan Ghassemi (ghassemi at ftml dot net)
    * 
    * This program is free software; you can redistribute it and/or modify
    * it under the terms of the GNU General Public License as published by
    * the Free Software Foundation; either version 2 of the License, or
    * (at your option) any later version.
    *
    * This program is distributed in the hope that it will be useful,
    * but WITHOUT ANY WARRANTY; without even the implied warranty of
    * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    * GNU General Public License for more details.
    *
    * You should have received a copy of the GNU General Public License
    * along with this program; if not, write to the Free Software
    * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/ 

#ifndef __CAL_H
#define __CAL_H

/*
 * show_month() is a method to display calendar for a certain month.
 * It takes ``dyear'' and ``dmonth'' as arguments which represents
 * the target month to be displayed. ``x_d'' is the distant from line's
 * beginning, "jf" stands for Julian_Flag which is used to display Julian
 * days and "pf" stands for Pahlavi_Flag which is another epoch for Jalali
 * calendar. It finaly returns calendar's height.
 */
int show_month(int dyear, int dmonth, int cday, int x_d, int jf, int pf) ;

/*
 * show_current() is a method to show current month's calendar. It takes
 * Julian_Flang and Pahlavi_Flag as arguments.
 */
void show_current(int jf, int pf) ;

/* 
 * show_three() is a method to display a calendar for the prev/current/next
 * month and it also gets Julian and Pahlavi flags.
 */
void show_three(int jf, int pf) ;

/* 
 * show_whole_year() is a method to display a celendar for the whole year.
 * It takes the year to be displayed, as well as ``isc'' which indicates 
 * whether it must calculate the current year or look to the argument supplied 
 * by caller. It then takes Julian and Pahlavi flags again.
 */
void show_whole_year(int dyear, int isc, int jf, int pf) ;

#endif /* __CAL_H */
