package jamvm.java.lang;
 
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.zip.ZipFile;
import java.net.URLClassLoader;
import gnu.java.io.PlatformHelper;
 
public class SystemClassLoader extends URLClassLoader {

    /**
     * Creates a class loader. Note that the parent may be null, when this is
     * created as the system class loader by ClassLoader.getSystemClassLoader.
     *
     * @param parent the parent class loader
     */
    public SystemClassLoader(ClassLoader parent) {
        super(getURLsFromClassPath(), parent);
    }
     
    private static URL[] getURLsFromClassPath() {
        ArrayList urls = new ArrayList();
        String cp = System.getProperty("java.class.path", ".");
        StringTokenizer st = new StringTokenizer(cp, File.pathSeparator);

        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            File f = new File(path);

            if(!f.exists())
                continue;
 	    
            String lc_path = path.toLowerCase();
            path = f.getAbsolutePath();
 	    
            try {
                URL url;

                if (lc_path.endsWith(".zip") || lc_path.endsWith(".jar")) {
                    // Construct URL object for the path
                    StringBuffer sb = new StringBuffer(PlatformHelper.INITIAL_MAX_PATH);
                    sb.append("file://");
                    sb.append(path);
                    url = new URL(sb.toString());
                } else {
                    // Assume it is a directory
                    url = new File(path).toURL();
                }

                urls.add(url);
            } catch (Exception e) {}
        }
   
        URL[] result = new URL[urls.size()];
        urls.toArray(result);
        return result;
    }
}
