#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>
#include <sys/times.h>
#include <errno.h>
#include <math.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>


#include "main.h"
#include "callbacks.h"
#include "callbacks_help.h"
#include "interface.h"
#include "support.h"
#include "process.h"
#include "gtkmeter.h"
#include "gtkmeterscale.h"
#include "aux-ui.h"
#include "djeq-ui.h"
#include "master-ui.h"
#include "monitor-ui.h"
#include "db.h"
#include "help.h"


#define MAIN_BUTTONS             0
#define INPUT                    1
#define EQ_OPTIONS               3
#define LO                       4
#define MID                      5
#define HIGH                     6
#define OUTPUT                   8

/* Convert from dB's to a coefficient */
#define DB_CO(g) powf(10.0f, (g) * 0.05f)

static char *help_ptr = general_help;


gboolean
on_window1_delete_event                (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
    gtk_main_quit();

    return FALSE;
}

void
on_quit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    gtk_main_quit();

}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}




/*
void 
knob_slider_handler  (GtkWidget *adj, Control *c) {
  control_emit(c, GTK_ADJUSTMENT(adj)->value);
}
*/

GtkWidget*
make_meter (gchar *widget_name, gchar *string1, gchar *string2,
                gint int1, gint int2)
{
    GtkWidget *ret;
    gint dir = GTK_METER_UP;
    GtkAdjustment *adjustment = (GtkAdjustment*) gtk_adjustment_new (0.0,
		    (float)int1, (float)int2, 0.0, 0.0, 0.0);

    if (!string1 || !strcmp(string1, "up")) {
        dir = GTK_METER_UP;
    } else if (!strcmp(string1, "down")) {
	dir = GTK_METER_DOWN;
    } else if (!strcmp(string1, "left")) {
	dir = GTK_METER_LEFT;
    } else if (!strcmp(string1, "right")) {
	dir = GTK_METER_RIGHT;
    }

    ret = gtk_meter_new(adjustment, dir);

    return ret;
}


GtkWidget*
make_mscale (gchar *widget_name, gchar *string1, gchar *string2,
                gint int1, gint int2)
{
    int sides = 0;
    GtkWidget *ret;

    if (string1 && strstr(string1, "left")) {
	sides |= GTK_METERSCALE_LEFT;
    }
    if (string1 && strstr(string1, "right")) {
	sides |= GTK_METERSCALE_RIGHT;
    }
    if (string1 && strstr(string1, "top")) {
	sides |= GTK_METERSCALE_TOP;
    }
    if (string1 && strstr(string1, "bottom")) {
	sides |= GTK_METERSCALE_BOTTOM;
    }

    ret = gtk_meterscale_new(sides, int1, int2);

    return ret;
}

void
on_Hi_scale_value_changed              (GtkRange        *range,
                                        gpointer         user_data)
{
    int i;
    GtkWidget *slider;
    char name[256];
    GtkAdjustment *a[N_PLUGINS]; 

    for (i=0; i<N_PLUGINS; i++) {
	snprintf(name, 255, "djeq%i_1", i+1);
	slider = lookup_widget(main_window, name); 
        a[i] = gtk_range_get_adjustment(slider);
	djeq[i].hi = a[i]->value;
    }
}


void
on_Mid_scale_value_changed             (GtkRange        *range,
                                        gpointer         user_data)
{
    int i;
    GtkWidget *slider;
    char name[256];
    GtkAdjustment *a[N_PLUGINS]; 

    for (i=0; i<N_PLUGINS; i++) {
	snprintf(name, 255, "djeq%i_2", i+1);
	slider = lookup_widget(main_window, name); 
        a[i] = gtk_range_get_adjustment(slider);
	djeq[i].mid = a[i]->value;
    }
}


void
on_Lo_scale_value_changed              (GtkRange        *range,
                                        gpointer         user_data)
{
    int i;
    GtkWidget *slider;
    char name[256];
    GtkAdjustment *a[N_PLUGINS]; 
    
    for (i=0; i<N_PLUGINS; i++) {
	snprintf(name, 255, "djeq%i_3", i+1);
	slider = lookup_widget(main_window, name); 
        a[i] = gtk_range_get_adjustment(slider);
	djeq[i].lo = a[i]->value;
    }
}

void
on_channel_gain_scale_value_changed    (GtkRange        *range,
                                        gpointer         user_data)
{
    int i;
    GtkWidget *slider;
    char name[256];
    GtkAdjustment *a[N_PLUGINS]; 
    
    for (i=0; i<N_PLUGINS; i++) {
	snprintf(name, 255, "channel_gain_%i", i+1);
	slider = lookup_widget(main_window, name); 
        a[i] = gtk_range_get_adjustment(slider);
        chan_gain_target[i] = DB_CO(a[i]->value);
//	printf ("adj chan%i\n", i);
    }
}


void
on_fader_scale_value_changed           (GtkRange        *range,
                                        gpointer         user_data)
{
    int i;
    GtkWidget *slider;
    char name[256];
    GtkAdjustment *a[N_PLUGINS]; 
    
    for (i=0; i<2; i++) {
	snprintf(name, 255, "fader_%i", i+1);
	slider = lookup_widget(main_window, name); 
        a[i] = gtk_range_get_adjustment(slider);
        fader_gain_target[i] = a[i]->value;
//	printf ("adj fader%i\n", i);
    }

}


void
on_aux_gain_scale_value_changed        (GtkRange        *range,
                                        gpointer         user_data)
{
    int i;
    GtkWidget *slider;
    char name[256];
    GtkAdjustment *a[2]; 
    
    for (i=0; i<2; i++) {
	snprintf(name, 255, "aux_gain_%i", i+1);
	slider = lookup_widget(main_window, name); 
        a[i] = gtk_range_get_adjustment(slider);
        aux_gain_target[i] = DB_CO(a[i]->value);
//	printf ("adj aux_%i\n", i);
    }

}
 
void
on_master_scale_value_changed          (GtkRange        *range,
                                        gpointer         user_data)
{
    GtkAdjustment *a = gtk_range_get_adjustment(range);
    mast_gain_target = DB_CO(a->value);
}

void
on_mon_scale_value_changed             (GtkRange        *range,
                                        gpointer         user_data)
{

    GtkAdjustment *a = gtk_range_get_adjustment(range);
    mon_gain_target = DB_CO(a->value);

}


void
on_mon_button_toggled                  (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    int i;
    GtkWidget *button;
    char name[256];
    
    for (i=0; i < N_PLUGINS +2; i++) {
	snprintf(name, 255, "mon_button_%i", i+1);
	button = lookup_widget(main_window, name); 
	global_mon[i] = gtk_toggle_button_get_active(button);
//	printf ("global_mon_%i = %i\n", i, global_mon[i]);
	
    }
}


void
on_aux1_toggled                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    int i;
    GtkWidget *button;
    char name[256];
    
    for (i=0; i < N_PLUGINS; i++) {
	snprintf(name, 255, "aux1_%i", i+1);
	button = lookup_widget(main_window, name); 
	global_aux1[i] = gtk_toggle_button_get_active(button);
//	printf ("global_aux1_%i = %i\n", i, global_aux1[i]);
	
    }

}


void
on_aux2_toggled                        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    int i;
    GtkWidget *button;
    char name[256];
    
    for (i=0; i < N_PLUGINS; i++) {
	snprintf(name, 255, "aux2_%i", i+1);
	button = lookup_widget(main_window, name); 
	global_aux2[i] = gtk_toggle_button_get_active(button);
//	printf ("global_aux2_%i = %i\n", i, global_aux2[i]);
	
    }

}

void
on_group_clicked                       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    int g, i;
    GtkWidget *button;
    char name[256];
    
    for (g=0; g < 4; g++) {
	for (i=0; i < 6; i++) {
	    snprintf(name, 255, "g%i_%i",g+1, i+1);
	    button = lookup_widget(main_window, name); 
	    global_group[g][i] = gtk_toggle_button_get_active(button);
//	    printf ("global_group[%i][%i] = %i\n", g, i, global_group[g][i]);
	}
    }
}

void
on_mon_menu_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{

}


void
on_mast_menu_realize                   (GtkWidget       *widget,
                                        gpointer         user_data)
{

}

void
on_mast_menu_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{

}



gboolean
on_EQ_reset_button_release_event       (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{

  return FALSE;
}




void
on_jack_ports_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    iomenu_pull_down_ports();
}

