#ifndef _TIME_C
#define _TIME_C

#include <sys/time.h>

inline struct timeval
get_current_time ( void )
{
  struct timeval tv ;
  gettimeofday ( &tv , 0 ) ;
  return tv ;
}

inline double
timeval_to_real_utc ( struct timeval tv ) 
{
  return (double)tv.tv_sec + ( (double)tv.tv_usec / 1000000.0 ) ;
}

inline uint64_t
timeval_to_ntp ( struct timeval tv )
{
  const uint64_t seconds_from_1900_to_1970 = (uint64_t)2208988800UL ;
  const double ms_to_ntp = (double)4294.967296 ;
  return ( ( (uint64_t)tv.tv_sec + seconds_from_1900_to_1970 ) << 32 ) + ( (uint64_t) ( (double)tv.tv_usec * ms_to_ntp ) ) ;
}

inline uint64_t
real_utc_to_ntp ( double utc )
{
  struct timeval tv ;
  tv.tv_sec = (long int) utc ;
  tv.tv_usec = (long int) ( ( utc - (double)tv.tv_sec ) * 1000000.0 ) ;
  return timeval_to_ntp ( tv ) ;
}

#endif
