/*
 * Copyright (c) 1995,1999 Vectaport Inc.
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, distribute, and sell this software and
 * its documentation for any purpose is hereby granted without fee, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the names of the copyright holders not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The copyright holders make
 * no representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 * FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 * NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 * 
 */

/*
 * OvPrintCmd - a command for printing graphical objects
 */

#ifndef ov_print_h
#define ov_print_h

#include <Unidraw/Commands/catcmds.h>

class PrintChooser;

//: evolved clone of PrintCmd.
class OvPrintCmd : public Command {
public:
    OvPrintCmd(ControlInfo*, PrintChooser* = nil);
    OvPrintCmd(Editor* = nil, PrintChooser* = nil);
    virtual ~OvPrintCmd();

    virtual void Execute();
    virtual boolean Reversible();
    // returns false.

    virtual Command* Copy();
    virtual ClassId GetClassId();
    virtual boolean IsA(ClassId);

    virtual boolean to_printer();
    // return flag that indicates whether "to printer" is checked in dialog box.
    virtual boolean idraw_format();
    // return flag that indicates whether "idraw format" is checked in dialog box.

    int print(const char* cmd, const char* file);

protected:
    PrintChooser* chooser_;

    void Init(PrintChooser*);
};

#endif

