
/****************************************************************************
 *
 * Copyright (C) 2004 Ikke - http://www.eikke.com.  All rights reserved.
 *
 * This file is part of IVMan (ivm).
 *
 * This file may be distributed under the terms of the Q Public License
 * as defined by Troll Tech AS of Norway and appearing in the file
 * LICENSE.QPL included in the packaging of this file.
 * 
 * See http://www.troll.no/qpl for QPL licensing information.
 *
 * $Id: common.h,v 1.24 2007/01/29 11:52:31 makoenig Exp $
 *****************************************************************************/

#ifndef _COMMON_H
#define _COMMON_H

#ifdef HAVE_CONFIG_H
# ifndef _CONFIG_H
#  define _CONFIG_H
#  include "../config.h"
# endif
#else
# error "No config.h!"
#endif

#ifndef __GNUC__
#define __FUNCTION__   ""
#endif

#include <locale.h>
#include <gettext.h>
#define _(str) gettext(str)

#include <glib.h>
#include <libhal.h>


#include "hal_compat.h"
#include "dbus_interface.h"
#include "debug.h"
#define DEBUG(fmt, arg...) debug(fmt,__FILE__,__LINE__,__FUNCTION__,##arg)
#include "IvmConfig/IvmConfigBase.h"

IvmConfigBase *cfg_base;
gboolean isdaemon;
gboolean usermode;
GHashTable *devices;
GHashTable *execuns;
GHashTable *pss;
GMainLoop *loop;
LibHalContext *hal_ctx;
DBusConnection *dbus_connection;

void xmlReadFailed(char const * filename);

#endif
