# -*- Mode: Python -*-
# vi:si:et:sw=4:sts=4:ts=4
#
# Istanbul - A desktop recorder
# Copyright (C) 2005 Zaheer Abbas Merali (zaheerabbas at merali dot org)
# Portions Copyright (C) 2004,2005 Fluendo, S.L. (www.fluendo.com).
# All rights reserved.

# This file may be distributed and/or modified under the terms of
# the GNU General Public License version 2 as published by
# the Free Software Foundation.
# This file is distributed without any warranty; without even the implied
# warranty of merchantability or fitness for a particular purpose.
# See "LICENSE.GPL" in the source distribution for more information.

# Headers in this file shall remain intact.
try:
    import gconf
except:
    GCONF_AVAILABLE = False
else:
    GCONF_AVAILABLE = True

import optparse
import sys
import locale, gettext
import tempfile

from istanbul.configure import config
from istanbul.main.save_window import SaveWindow
from istanbul.main.select import GtkAreaSelector
from istanbul.main.preferences import Preferences
from istanbul.main.gconf_client import GConfClient
from istanbul.main.tray_icon import TrayIcon
from istanbul.main.constants import RecordingState

import gobject
import gtk

# import 0.10 as required
import pygst
pygst.require('0.10')

import gst

import egg.trayicon

_ = gettext.gettext

class Istanbul:
    def __init__(self):

        self.encode_later = False
        self.selector = None

        TrayIcon()

def error_dialog(message):
    dialog = gtk.MessageDialog(type=gtk.MESSAGE_ERROR,
                               buttons=gtk.BUTTONS_OK)
    dialog.set_markup("<b>"+message+"</b>")
    dialog.run()
    sys.exit()

import command_line
def main(args):

    if command_line.CommandLine().Options.version:
        print config.version
        return 0

    # check plugins installed
    reg = gst.registry_get_default()
    if not reg.find_plugin("istximagesrc"):
        error_dialog(_("You do not have the ximagesrc GStreamer plugin installed    ."))
    if not reg.find_plugin("theora"):
        error_dialog(_("You do not have the theora GStreamer plugin installed."))
    if not reg.find_plugin("ogg"):
        error_dialog(_("You do not have the ogg GStreamer plugin installed."))
        
    locale.setlocale(locale.LC_ALL,"")
    gettext.bindtextdomain(config.domain, config.localedir)
    gettext.textdomain(config.domain)
    
    deskrec = Istanbul()
    gtk.main()

if __name__ == "__main__":
    import sys
    main(sys.argv)
