#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>

/*
   Copyright (C) 2003 Red Hat, Inc. All rights reserved.
                                                                                                             
   Usage and distribution of this file are subject to the Open Software License version 1.1
   that can be found at http://www.opensource.org/licenses/osl-1.1.txt and the COPYING file as
   distributed together with this file is included herein by reference.
                                                                                                                      
   Author: Arjan van de Ven   <arjanv@redhat.com>

*/

#include "prototypes.h"

int irq_cost[MAX_CPU];		/* cummulative assigned irq's already */
int this_type[MAX_CPU];		/* number of irq's already assigned within this class */

struct irqdescriptor interrupts[MAX_INTERRUPTS];


int rotate_premium = 12500;


void commandpolicy(char *pol, int phase)
{
	/* Allow --noethernet */
	if (!strcmp("--noethernet",pol)) {
		class_policy[IRQ_ETH] = POLICY_IGNORE;
		class_policy[IRQ_GIGE] = POLICY_IGNORE;
		if (phase>0) {
			class_policy[IRQ_OTHER] = POLICY_ROTATE;
			class_policy[IRQ_LEGACY] = POLICY_ROTATE;
			class_policy[IRQ_SCSI] = POLICY_ROTATE;
			class_policy[IRQ_TIMER] = POLICY_ROTATE;
		}
	}

}


int main(int argc, char **argv)
{
	int oneshot = 0;
	
	class_policy[IRQ_TIMER] = POLICY_ROTATE;
	
	parse_proc_cpuinfo();
	
	/* Allow --oneshot as option to force a once only setting of the affinity and then exit */
	if ((argc>1) &&  (!strcmp("--oneshot",argv[1])))
		oneshot = 1;

	if (argc>1) 		
		commandpolicy(argv[1], 0);
	
	if (cpucount < 2) 
		exit(EXIT_SUCCESS); /* UP balancing is useless */
		
	/* in oneshot mode, don't do anything except on pIV boxes */
	if (oneshot && (machineneedsbalance!=15))
		exit(EXIT_SUCCESS);
	parse_proc_interrupts(0); 

#ifndef DEBUG	
	daemon(0,0);
#endif
	/* 
	 * Allow 5 seconds for gathering irq counts before the first balance; 60 in case of one-shot
	 * balancing 
	 */
	sleep(5 + 55*oneshot);  
	while (1) {
		parse_proc_interrupts(1); 
		balance_policy();
		activate_irqtable();
		if (argc>1)
			commandpolicy(argv[1], 1);

#ifdef DEBUG
		dump_settings();
#endif
		if (oneshot)
			break;
		sleep(10);
	}
	return EXIT_SUCCESS;
}
