<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
require_once 'include/i18n.php';

AuthCheck("post-only");
commonHeader(_("Help Desk"));
__("Welcome to the IRM Help Desk.  This is where you can request help with a
computing resource problem. To report a problem, just enter the IRM ID
or name of the computer below.");

if(Config::Get('groups'))
{
  __("Alternately, you can report problems with entire groups of computers by selecting it below.");
}
?>

<hr noshade>
<form method=get action="<?php echo Config::AbsLoc('users/helper-add.php') ?>">
<?php __("IRM ID:") ?> <input type=text name=ID size=10>&nbsp;&nbsp;
<input type=hidden name=is_group value="no">
<input type=submit value="<?php __("Continue with IRM ID") ?>">
</form>
<br>

<?php
if(Config::Get('usenamesearch'))
{
  __("Or, you can enter the name of the computer:");
  PRINT '<br><form method=get action="'.Config::AbsLoc('users/helper-search.php').'">';
  PRINT _("Name:")." <input type=text name=name size=15> ";
  printf('<input type=submit value="%s"></form>', _("Continue with Name"));
  PRINT "<br>\n";
}
if(Config::Get('groups'))
{
  __("Or, you can select a group of computers:");
  PRINT '<br><form method=get action="'.Config::AbsLoc('users/helper-add.php').'">';
  Dropdown("groups", "groupname");
  PRINT "<input type=hidden name=is_group value=\"yes\">\n";
  printf('<input type=submit value="%s">', _("Continue with group selection"));
  PRINT "</form>";
}
commonFooter();
