<?php
#    IRM - The Information Resource Manager
#    Copyright (C) 1999,2000 Yann Ramin
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License (in file COPYING) for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
################################################################################

include("../include/irm.inc");
require_once 'lib/Config.php';
require_once 'include/i18n.php';

AuthCheck("normal");

commonHeader(_("Computers") . " - " . _("Info"));

showComputer($ID, 1);
showPortsOnDevice($ID, 1);

$inGroup = computerInGroup($ID);
$DB = Config::Database();

$qID = $DB->getTextValue($ID);
$allquery = "SELECT COUNT(ID) FROM tracking,comp_group
			WHERE ((tracking.computer = $qID
				AND tracking.is_group='no')
			OR (comp_group.comp_id=$qID
				AND tracking.is_group='yes'
				AND tracking.computer=comp_group.group_id))";
$allcount = $DB->getOne($allquery);
$opencount = $DB->getOne($allquery . " AND tracking.status != 'complete'");

// Set default showtracking if none given
if (!@$_REQUEST['showtracking'])
{
	$_REQUEST['showtracking'] = 'open';
}
	
if ($allcount == 0)
{
	echo '<i>'._("No Tracking Found").'</i>';
}
else
{
?>
	<table border=1 width=100%>
	<tr>
		<th colspan=3>
			<a name="tracking">
				Tracking Summary
			</a>
		</th>
	</tr>
	<tr>
		<td>
<?php
	echo "<p>\n";
	printf(_("Found %s tracking items, %s currently open."), $allcount, $opencount);
	echo "</p>\n";
	PRINT '<form method=get action="'.Config::AbsLoc('users/computers-info.php/').'#tracking">';
	PRINT "<input type=hidden name=ID value=$ID>";
	echo '<select name="showtracking" size="1">';
	$options = array('all' => _("Show All Tracking"),
			'open' => _("Show Current Tracking"),
			'none' => _("Hide Tracking")
			);
	echo select_options($options, $_REQUEST['showtracking']);
	?>
	</select>
	<input type="checkbox" name="showfollowups"<?php echo @$_REQUEST['showfollowups'] ? ' checked' : '' ?>> Show Followups
	<input type="submit" value="<?php __("Show Tracking") ?>"></form>
	</td>
	</tr>
	<?php
	
	if ($_REQUEST['showtracking'] != 'none')
	{
		$q = "SELECT DISTINCT(ID) FROM tracking,comp_group
			WHERE ((tracking.computer = $qID
				AND tracking.is_group='no')
			OR (comp_group.comp_id=$qID
				AND tracking.is_group='yes'
				AND tracking.computer=comp_group.group_id))";
		if ($_REQUEST['showtracking'] == 'open')
		{
			$q .= " AND tracking.status != 'complete'";
		}
		$q .= ' ORDER BY date DESC';

		$data = $DB->getCol($q);

		PRINT '<tr><td valign=top colspan=3>';
		Tracking::displayHeader();
  		foreach ($data as $tID)
  		{
			$track2 = new Tracking($tID);
			$track2->display(@$_REQUEST['showfollowups']);
  		}
		Tracking::displayFooter();
		PRINT '</tr></td>';
	}
	PRINT '</table>';
}

PRINT "<br><br>";
compsoftShow($ID);


PRINT "</center><br>";
if (Config::Get('groups'))
{
	PRINT "<br><b>";
	__("Group Memberships");
	PRINT "</b><p>	";

	$query = "SELECT * FROM comp_group where comp_id = $qID";
	$data = $DB->getAll($query);
	foreach ($data as $result)
	{
		$gID = $result["group_id"];
		$qgID = $DB->getTextValue($gID);
		$q2 = "SELECT name FROM groups WHERE id = $qgID";
		$gname = $DB->getOne($q2);
		PRINT '<a href="'.Config::AbsLoc("users/setup-groups-members.php?id=$gID")."\">$gname</a><br>";
	}
}
commonFooter();
