# -------------------------------------------------------- #
# Table structure for table `nicks`
DROP TABLE IF EXISTS nicks;
CREATE TABLE nicks (
  snid int(11) NOT NULL auto_increment,
  nick varchar(32) NOT NULL default '',
  rtype int(1) NOT NULL,
  t_reg timestamp(14) NOT NULL,
  t_ident timestamp(14) NOT NULL,
  t_seen timestamp(14) NOT NULL,
  t_sign timestamp(14) NOT NULL,
  pass varchar(64) default NULL,
  req_email varchar(64) default NULL,
  email varchar(64) default NULL,
  url varchar(64) default NULL,
  imid varchar(20) default NULL,
  location varchar(64) default NULL,
  ontime int(11) NOT NULL default '0',
  auth varchar(21) default NULL,
  username varchar(32) NOT NULL default '0',
  realhost varchar(64) default NULL,
  info varchar(64) default NULL,
  nmask int(11) default NULL,
  ajoin varchar(128) default NULL,
  status int NOT NULL default '0',
  flags int NOT NULL default '0',
  memoscount int NOT NULL default '0',
  authcode varchar(21) default NULL,
  lang int NOT NULL default '0',
  master_snid int(11) NOT NULL default '0',
  max_members int(4) NOT NULL default '0',
  PRIMARY KEY  (snid),
  KEY snid (snid),
  KEY nick (nick)
) Type = InnoDB;


DROP TABLE IF EXISTS nicks_groups;
CREATE TABLE nicks_groups(
  snid int(11) unsigned NOT NULL,
  member int(11) NOT NULL
);

# -------------------------------------------------------- #
# Table structure for table `nicks_memos`
DROP TABLE IF EXISTS nicks_memos;
CREATE TABLE nicks_memos (
  id int(11) unsigned NOT NULL auto_increment,
  owner_id int(11) unsigned NOT NULL default '0',
  number int(2) unsigned NOT NULL default '0',
  status int(2) unsigned NOT NULL default '0',
  t_sent timestamp(14) NOT NULL,
  sender varchar(32) NOT NULL default '',
  msg text NOT NULL,
  PRIMARY KEY  (id),
  KEY owner_id (owner_id)
) TYPE=MyISAM COMMENT='memoserv data';

# -------------------------------------------------------- #
# Table structure for table `nicks_notes`
DROP TABLE IF EXISTS nicks_notes;
CREATE TABLE nicks_notes (
  owner_id int(11) unsigned NOT NULL default '0',
  number int(2) unsigned NOT NULL default '0',
  msg text NOT NULL,
  PRIMARY KEY  (owner_id,number)
) TYPE=MyISAM COMMENT='nickserv notes';    # Table structure for table `chans`
DROP TABLE IF EXISTS chans;
CREATE TABLE chans (
  id int(11) NOT NULL auto_increment,
  name varchar(64) NOT NULL default '',
  enctype tinyint(1) NOT NULL default '0',
  pass varchar(64) default NULL,
  url varchar(64) default NULL,
  email varchar(64) default NULL,
  founder int(11) NOT NULL default '0',
  successor int(11) NOT NULL default '0',
  last_topic varchar(255) default NULL,
  last_topic_setter varchar(32) default NULL,
  last_topic_time timestamp(14) NOT NULL,
  t_reg timestamp(14) NOT NULL,
  t_ident timestamp(14) NOT NULL,
  mlock varchar(64) default NULL,
  status int(11) NOT NULL default '0',
  memoscount int(2) NOT NULL default '0',
  entrymsg varchar(255) default NULL,
  t_maxusers timestamp(14) NOT NULL,
  maxusers int(4) NOT NULL default '0',
  PRIMARY KEY  (id),
  KEY id (id)
) TYPE=MyISAM;

# -------------------------------------------------------- #
# Table structure for table `chans_accesses`
DROP TABLE IF EXISTS chans_accesses;
CREATE TABLE chans_accesses (
  chan_id int(11) NOT NULL default '0',
  who int(11) NOT NULL default '0',
  nick_id int(11) NOT NULL default '0',
  level int(5) NOT NULL default '0',
  KEY chan_id (chan_id,nick_id)
) TYPE=MyISAM COMMENT='Channel access list info';

# -------------------------------------------------------- #
# Table structure for table `chans_akicks`
DROP TABLE IF EXISTS chans_akicks;
CREATE TABLE chans_akicks (
  chan_id int(11) NOT NULL default '0',
  who int(11) NOT NULL default '0',
  t_kick timestamp(14) NOT NULL,  
  mask varchar(64) NOT NULL default '',
  reason varchar(128) default NULL,
  KEY chan_id (chan_id)
) TYPE=MyISAM;
